/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidException;

public class ReflectionHelper {
    private Class targetClass;
    private Map methodMap = null;

    public ReflectionHelper(Class targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ReflectionHelper.errorConstructing"));
        }
        this.targetClass = targetClass;
    }

    public Method findBestMethodOnTarget(String methodName, Object[] arguments) throws NoSuchMethodException, SecurityException {
        if (arguments == null) {
            return this.findBestMethodWithSignature(methodName, Collections.EMPTY_LIST);
        }
        int size = arguments.length;
        ArrayList argumentClasses = new ArrayList(size);
        for (int i = 0; i != size; ++i) {
            if (arguments[i] != null) {
                Class<?> clazz = arguments[i].getClass();
                argumentClasses.add(clazz);
                continue;
            }
            argumentClasses.add(null);
        }
        return this.findBestMethodWithSignature(methodName, argumentClasses);
    }

    public Method findBestMethodWithSignature(String methodName, Object[] argumentsClasses) throws NoSuchMethodException, SecurityException {
        List<Object> argumentClassesList = Arrays.asList(argumentsClasses);
        return this.findBestMethodWithSignature(methodName, argumentClassesList);
    }

    public Method findBestMethodWithSignature(String methodName, List argumentsClasses) throws NoSuchMethodException, SecurityException {
        Method result = null;
        Class[] classArgs = new Class[argumentsClasses.size()];
        try {
            argumentsClasses.toArray(classArgs);
            result = this.targetClass.getMethod(methodName, classArgs);
            return result;
        }
        catch (NoSuchMethodException e) {
            List argumentsClassList = ReflectionHelper.convertArgumentClassesToPrimitives(argumentsClasses);
            argumentsClassList.toArray(classArgs);
            try {
                result = this.targetClass.getMethod(methodName, classArgs);
                return result;
            }
            catch (NoSuchMethodException e2) {
                LinkedList methodsWithSameName;
                if (this.methodMap == null) {
                    this.methodMap = new HashMap();
                    Method[] methods = this.targetClass.getMethods();
                    for (int i = 0; i != methods.length; ++i) {
                        Method method = methods[i];
                        LinkedList<Method> methodsWithSameName2 = (LinkedList<Method>)this.methodMap.get(method.getName());
                        if (methodsWithSameName2 == null) {
                            methodsWithSameName2 = new LinkedList<Method>();
                            this.methodMap.put(method.getName(), methodsWithSameName2);
                        }
                        methodsWithSameName2.addFirst(method);
                    }
                }
                if ((methodsWithSameName = (LinkedList)this.methodMap.get(methodName)) == null) {
                    throw new NoSuchMethodException(methodName);
                }
                for (Method method : methodsWithSameName) {
                    Class<?>[] args = method.getParameterTypes();
                    if (args.length != argumentsClasses.size()) continue;
                    boolean allMatch = true;
                    for (int i = 0; i < args.length && allMatch; ++i) {
                        Class primitiveClazz = (Class)argumentsClassList.get(i);
                        Class objectClazz = (Class)argumentsClasses.get(i);
                        if (objectClazz != null) {
                            if (args[i].equals(primitiveClazz) || args[i].isAssignableFrom(objectClazz)) continue;
                            allMatch = false;
                            continue;
                        }
                        if (!args[i].isPrimitive()) continue;
                        allMatch = false;
                    }
                    if (!allMatch) continue;
                    if (result != null) {
                        throw new NoSuchMethodException(methodName + " Args: " + argumentsClasses + " has multiple possible signatures.");
                    }
                    result = method;
                }
                if (result != null) {
                    return result;
                }
                throw new NoSuchMethodException(methodName + " Args: " + argumentsClasses);
            }
        }
    }

    private static List convertArgumentClassesToPrimitives(List arguments) {
        ArrayList<Class<Boolean>> result = new ArrayList<Class<Boolean>>(arguments.size());
        for (Class<Object> clazz : arguments) {
            if (clazz == Boolean.class) {
                clazz = Boolean.TYPE;
            } else if (clazz == Character.class) {
                clazz = Character.TYPE;
            } else if (clazz == Byte.class) {
                clazz = Byte.TYPE;
            } else if (clazz == Short.class) {
                clazz = Short.TYPE;
            } else if (clazz == Integer.class) {
                clazz = Integer.TYPE;
            } else if (clazz == Long.class) {
                clazz = Long.TYPE;
            } else if (clazz == Float.class) {
                clazz = Float.TYPE;
            } else if (clazz == Double.class) {
                clazz = Double.TYPE;
            } else if (clazz == Void.class) {
                clazz = Void.TYPE;
            }
            result.add(clazz);
        }
        return result;
    }

    private static final Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> cls = null;
        cls = classLoader == null ? Class.forName(className.trim()) : Class.forName(className.trim(), true, classLoader);
        return cls;
    }

    public static final Object create(String className, Collection ctorObjs, ClassLoader classLoader) throws TeiidException {
        try {
            int size = ctorObjs == null ? 0 : ctorObjs.size();
            Class[] names = new Class[size];
            Object[] objArray = new Object[size];
            int i = 0;
            if (size > 0) {
                for (Object obj : ctorObjs) {
                    names[i] = ReflectionHelper.loadClass(obj.getClass().getName(), classLoader);
                    objArray[i] = obj;
                    ++i;
                }
            }
            return ReflectionHelper.create(className, objArray, names, classLoader);
        }
        catch (Exception e) {
            throw new TeiidException(e);
        }
    }

    public static final Object create(String className, Object[] ctorObjs, Class<?>[] argTypes, ClassLoader classLoader) throws TeiidException {
        try {
            Class cls = ReflectionHelper.loadClass(className, classLoader);
            Constructor ctor = cls.getDeclaredConstructor(argTypes);
            return ctor.newInstance(ctorObjs);
        }
        catch (Exception e) {
            throw new TeiidException(e);
        }
    }
}

