/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.client.metadata.ResultsMetadataDefaults;
import org.teiid.client.plan.Annotation;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.util.SqlUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.DataTypeTransformer;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.JDBCURL;
import org.teiid.jdbc.MetadataProvider;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.ResultSetMetaDataImpl;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.TeiidStatement;
import org.teiid.jdbc.WarningUtil;
import org.teiid.jdbc.WrapperImpl;

public class StatementImpl
extends WrapperImpl
implements TeiidStatement {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    protected static final int TIMED_OUT = 4;
    protected static final int CANCELLED = 3;
    protected static final int NO_TIMEOUT = 0;
    private static final int NO_LIMIT = 0;
    private ConnectionImpl driverConnection;
    private Properties execProps;
    private int fetchSize = 2048;
    private int fetchDirection = 1000;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private boolean isClosed = false;
    protected int commandStatus = -1;
    protected int queryTimeout = 0;
    protected long currentRequestID = -1L;
    private PlanNode currentPlanDescription;
    private String debugLog;
    private Collection<Annotation> annotations;
    protected ResultSetImpl resultSet;
    private List<Exception> serverWarnings;
    private Serializable payload;
    private List batchedUpdates;
    protected int[] updateCounts;
    private Calendar defaultCalendar;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private static int SPIN_TIMEOUT = 500;
    protected Map outParamIndexMap = new HashMap();
    private static Pattern TRANSACTION_STATEMENT = Pattern.compile("\\s*(commit|rollback|(start\\s*transaction))\\s*;?", 2);
    private static Pattern SET_STATEMENT = Pattern.compile("\\s*set\\s*(\\w+)\\s*(\\w*);?", 2);
    private static Pattern SHOW_STATEMENT = Pattern.compile("\\s*show\\s*(\\w*);?", 2);

    static StatementImpl newInstance(ConnectionImpl driverConnection, int resultSetType, int resultSetConcurrency) {
        return new StatementImpl(driverConnection, resultSetType, resultSetConcurrency);
    }

    StatementImpl(ConnectionImpl driverConnection, int resultSetType, int resultSetConcurrency) {
        this.driverConnection = driverConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.execProps = new Properties(this.driverConnection.getExecutionProperties());
        String fetchSizeStr = this.execProps.getProperty("fetchSize");
        if (fetchSizeStr != null) {
            try {
                this.fetchSize = Integer.parseInt(fetchSizeStr);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected DQP getDQP() {
        return this.driverConnection.getDQP();
    }

    protected ConnectionImpl getMMConnection() {
        return this.driverConnection;
    }

    protected TimeZone getServerTimeZone() throws SQLException {
        return this.driverConnection.getServerConnection().getLogonResult().getTimeZone();
    }

    protected void resetExecutionState() throws SQLException {
        this.currentRequestID = -1L;
        this.currentPlanDescription = null;
        this.debugLog = null;
        this.annotations = null;
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.serverWarnings = null;
        this.batchedUpdates = null;
        this.updateCounts = null;
        this.outParamIndexMap.clear();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkStatement();
        if (this.batchedUpdates == null) {
            this.batchedUpdates = new ArrayList();
        }
        this.batchedUpdates.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.commandStatus = 3;
        this.cancelRequest();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkStatement();
        this.serverWarnings = null;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchedUpdates.clear();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.isClosed = true;
        this.driverConnection.closeStatement(this);
        logger.fine(JDBCPlugin.Util.getString("MMStatement.Close_stmt_success"));
    }

    protected void checkStatement() throws TeiidSQLException {
        if (this.isClosed) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMStatement.Stmt_closed"));
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.EITHER);
        return this.hasResultSet();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchedUpdates == null || this.batchedUpdates.isEmpty()) {
            return new int[0];
        }
        String[] commands = this.batchedUpdates.toArray(new String[this.batchedUpdates.size()]);
        this.executeSql(commands, true, RequestMessage.ResultsMode.UPDATECOUNT);
        return this.updateCounts;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.RESULTSET);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        String[] commands = new String[]{sql};
        this.executeSql(commands, false, RequestMessage.ResultsMode.UPDATECOUNT);
        return this.updateCounts[0];
    }

    protected boolean hasResultSet() throws SQLException {
        return this.resultSet != null && this.resultSet.getMetaData().getColumnCount() > 0;
    }

    protected void createResultSet(ResultsMessage resultsMsg) throws SQLException {
        List listOfParameters = resultsMsg.getParameters();
        if (listOfParameters != null) {
            int resultSetSize = 0;
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() != 5) continue;
                resultSetSize = parameter.getNumColumns();
                break;
            }
            int index = 0;
            int count = 0;
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() != 4) continue;
                this.outParamIndexMap.put(new Integer(++index), new Integer(resultSetSize + ++count));
                break;
            }
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() == 4 || parameter.getType() == 5) continue;
                ++index;
                if (parameter.getType() != 2 && parameter.getType() != 3) continue;
                this.outParamIndexMap.put(new Integer(index), new Integer(resultSetSize + ++count));
            }
        }
        this.resultSet = new ResultSetImpl(resultsMsg, this, null, this.outParamIndexMap.size());
        this.resultSet.setMaxFieldSize(this.maxFieldSize);
    }

    protected void executeSql(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode) throws SQLException {
        this.checkStatement();
        this.resetExecutionState();
        if (commands.length == 1) {
            Matcher match = SET_STATEMENT.matcher(commands[0]);
            if (match.matches()) {
                if (resultsMode == RequestMessage.ResultsMode.RESULTSET) {
                    throw new TeiidSQLException(JDBCPlugin.Util.getString("StatementImpl.set_result_set"));
                }
                String key = match.group(1);
                String value = match.group(2);
                if ("NEWINSTANCE".equalsIgnoreCase(key) && Boolean.valueOf(value).booleanValue()) {
                    this.getMMConnection().getServerConnection().cleanUp();
                } else {
                    JDBCURL.addNormalizedProperty(key, value, this.driverConnection.getExecutionProperties());
                }
                this.updateCounts = new int[]{0};
                return;
            }
            match = TRANSACTION_STATEMENT.matcher(commands[0]);
            if (match.matches()) {
                if (resultsMode == RequestMessage.ResultsMode.RESULTSET) {
                    throw new TeiidSQLException(JDBCPlugin.Util.getString("StatementImpl.set_result_set"));
                }
                String command = match.group(1);
                if (StringUtil.startsWithIgnoreCase(command, "start")) {
                    this.getConnection().setAutoCommit(false);
                } else if (command.equalsIgnoreCase("commit")) {
                    this.getConnection().setAutoCommit(true);
                } else if (command.equalsIgnoreCase("rollback")) {
                    this.getConnection().rollback(false);
                }
                this.updateCounts = new int[]{0};
                return;
            }
            match = SHOW_STATEMENT.matcher(commands[0]);
            if (match.matches()) {
                if (resultsMode == RequestMessage.ResultsMode.UPDATECOUNT) {
                    throw new TeiidSQLException(JDBCPlugin.Util.getString("StatementImpl.show_update_count"));
                }
                String show = match.group(1);
                if (show.equalsIgnoreCase("PLAN")) {
                    ArrayList records = new ArrayList(1);
                    PlanNode plan = this.driverConnection.getCurrentPlanDescription();
                    if (plan != null) {
                        ArrayList<Object> row = new ArrayList<Object>(3);
                        row.add(DataTypeTransformer.getClob(plan.toString()));
                        row.add(new SQLXMLImpl(plan.toXml()));
                        row.add(DataTypeTransformer.getClob(this.driverConnection.getDebugLog()));
                        records.add(row);
                    }
                    this.createResultSet(records, new String[]{"PLAN_TEXT", "PLAN_XML", "DEBUG_LOG"}, new String[]{"clob", "xml", "clob"});
                    return;
                }
                if (show.equalsIgnoreCase("ANNOTATIONS")) {
                    ArrayList records = new ArrayList(1);
                    Collection<Annotation> annos = this.driverConnection.getAnnotations();
                    for (Annotation annotation : annos) {
                        ArrayList<String> row = new ArrayList<String>(4);
                        row.add(annotation.getCategory());
                        row.add(annotation.getPriority().name());
                        row.add(annotation.getAnnotation());
                        row.add(annotation.getResolution());
                        records.add(row);
                    }
                    this.createResultSet(records, new String[]{"CATEGORY", "PRIORITY", "ANNOTATION", "RESOLUTION"}, new String[]{"string", "string", "string", "string"});
                    return;
                }
                if (show.equalsIgnoreCase("ALL")) {
                    ArrayList records = new ArrayList(1);
                    for (String key : this.driverConnection.getExecutionProperties().stringPropertyNames()) {
                        ArrayList<Object> row = new ArrayList<Object>(4);
                        row.add(key);
                        row.add(this.driverConnection.getExecutionProperties().get(key));
                        records.add(row);
                    }
                    this.createResultSet(records, new String[]{"NAME", "VALUE"}, new String[]{"string", "string"});
                    return;
                }
                List<List<String>> records = Collections.singletonList(Collections.singletonList(this.driverConnection.getExecutionProperties().getProperty(JDBCURL.getValidKey(show))));
                this.createResultSet(records, new String[]{show}, new String[]{"string"});
                return;
            }
        }
        RequestMessage reqMessage = this.createRequestMessage(commands, isBatchedCommand, resultsMode);
        ResultsMessage resultsMsg = null;
        try {
            resultsMsg = this.sendRequestMessageAndWait(reqMessage);
        }
        catch (Throwable ex) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Error_executing_stmt", reqMessage.getCommandString());
            logger.log(ex instanceof SQLException ? Level.WARNING : Level.SEVERE, msg, ex);
            throw TeiidSQLException.create(ex, msg);
        }
        List resultsWarning = resultsMsg.getWarnings();
        this.setAnalysisInfo(resultsMsg);
        if (resultsMsg.getException() != null) {
            throw TeiidSQLException.create(resultsMsg.getException());
        }
        if (resultsWarning != null) {
            this.accumulateWarnings(resultsWarning);
        }
        if (resultsMsg.isUpdateResult()) {
            List[] results = resultsMsg.getResults();
            this.updateCounts = new int[results.length];
            for (int i = 0; i < results.length; ++i) {
                this.updateCounts[i] = (Integer)results[i].get(0);
            }
            try {
                this.getDQP().closeRequest(this.getCurrentRequestID());
            }
            catch (TeiidProcessingException e) {
                throw TeiidSQLException.create(e);
            }
            catch (TeiidComponentException e) {
                throw TeiidSQLException.create(e);
            }
        } else {
            this.createResultSet(resultsMsg);
        }
        logger.fine(JDBCPlugin.Util.getString("MMStatement.Success_query", reqMessage.getCommandString()));
    }

    protected RequestMessage createRequestMessage(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode) {
        RequestMessage reqMessage = new RequestMessage();
        reqMessage.setCommands(commands);
        reqMessage.setBatchedUpdate(isBatchedCommand);
        reqMessage.setResultsMode(resultsMode);
        return reqMessage;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkStatement();
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.updateCounts = null;
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkStatement();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkStatement();
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkStatement();
        if (!this.hasResultSet()) {
            return null;
        }
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkStatement();
        if (this.updateCounts == null) {
            return -1;
        }
        return this.updateCounts[0];
    }

    protected void accumulateWarnings(List<Exception> serverWarnings) {
        if (serverWarnings == null || serverWarnings.isEmpty()) {
            return;
        }
        if (this.serverWarnings == null) {
            this.serverWarnings = new ArrayList<Exception>();
        }
        this.serverWarnings.addAll(serverWarnings);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkStatement();
        if (this.serverWarnings != null && this.serverWarnings.size() != 0) {
            return WarningUtil.convertWarnings(this.serverWarnings);
        }
        return null;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkStatement();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkStatement();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkStatement();
        if (rows < 0) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Invalid_fetch_size");
            throw new TeiidSQLException(msg);
        }
        this.fetchSize = rows == 0 ? 2048 : rows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.checkStatement();
        this.maxRows = maxRows;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkStatement();
        if (seconds < 0) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMStatement.Bad_timeout_value"));
        }
        this.queryTimeout = seconds;
    }

    protected void copyPropertiesToRequest(RequestMessage res) throws TeiidSQLException {
        String noExec;
        String partial = this.getExecutionProperty("partialResultsMode");
        res.setPartialResults(Boolean.valueOf(partial));
        String validate = this.getExecutionProperty("XMLValidation");
        if (validate == null) {
            res.setValidationMode(false);
        } else {
            res.setValidationMode(Boolean.valueOf(validate));
        }
        String format = this.getExecutionProperty("XMLFormat");
        res.setXMLFormat(format);
        String txnAutoWrapMode = this.getExecutionProperty("autoCommitTxn");
        try {
            res.setTxnAutoWrapMode(txnAutoWrapMode);
        }
        catch (TeiidProcessingException e) {
            throw TeiidSQLException.create(e);
        }
        String rsCache = this.getExecutionProperty("resultSetCacheMode");
        res.setUseResultSetCache(Boolean.valueOf(rsCache));
        res.setAnsiQuotedIdentifiers(Boolean.valueOf(this.getExecutionProperty("ansiQuotedIdentifiers")));
        String showPlan = this.getExecutionProperty("SHOWPLAN");
        if (showPlan != null) {
            try {
                res.setShowPlan(RequestMessage.ShowPlan.valueOf(showPlan.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if ((noExec = this.getExecutionProperty("NOEXEC")) != null) {
            res.setNoExec(noExec.equalsIgnoreCase("ON"));
        }
    }

    protected void timeoutOccurred() {
        logger.warning(JDBCPlugin.Util.getString("MMStatement.Timeout_ocurred_in_Statement."));
        try {
            this.cancel();
            this.commandStatus = 4;
            this.queryTimeout = 0;
            this.currentRequestID = -1L;
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException se) {
            logger.log(Level.SEVERE, JDBCPlugin.Util.getString("MMStatement.Error_timing_out."), se);
        }
    }

    protected void cancelRequest() throws SQLException {
        this.checkStatement();
        try {
            this.getDQP().cancelRequest(this.currentRequestID);
        }
        catch (TeiidProcessingException e) {
            throw TeiidSQLException.create(e);
        }
        catch (TeiidComponentException e) {
            throw TeiidSQLException.create(e);
        }
    }

    @Override
    public void setPayload(Serializable payload) {
        this.payload = payload;
    }

    @Override
    public void setExecutionProperty(String name, String value) {
        this.execProps.setProperty(name, value);
    }

    @Override
    public String getExecutionProperty(String name) {
        return this.execProps.getProperty(name);
    }

    protected ResultsMessage sendRequestMessageAndWait(RequestMessage reqMsg) throws SQLException, InterruptedException {
        this.currentRequestID = this.driverConnection.nextRequestID();
        reqMsg.setExecutionPayload(this.payload);
        reqMsg.setCursorType(this.resultSetType);
        reqMsg.setFetchSize(this.fetchSize);
        reqMsg.setRowLimit(this.maxRows);
        reqMsg.setTransactionIsolation(this.driverConnection.getTransactionIsolation());
        this.copyPropertiesToRequest(reqMsg);
        reqMsg.setExecutionId(this.currentRequestID);
        ResultsFuture<ResultsMessage> pendingResult = null;
        try {
            pendingResult = this.getDQP().executeRequest(this.currentRequestID, reqMsg);
        }
        catch (TeiidException e) {
            throw TeiidSQLException.create(e);
        }
        long timeoutMillis = this.queryTimeout * 1000;
        long endTime = System.currentTimeMillis() + timeoutMillis;
        ResultsMessage result = null;
        while (result == null) {
            if (timeoutMillis > 0L && endTime <= System.currentTimeMillis() && this.commandStatus != 4 && this.commandStatus != 3) {
                this.timeoutOccurred();
            }
            this.checkStatement();
            try {
                result = (ResultsMessage)pendingResult.get(SPIN_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                throw TeiidSQLException.create(e);
            }
            catch (TimeoutException e) {
            }
        }
        if (this.commandStatus == 3) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMStatement.Cancel_before_execute"));
        }
        if (this.commandStatus == 4) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMStatement.Timeout_before_complete"));
        }
        return result;
    }

    long getCurrentRequestID() {
        return this.currentRequestID;
    }

    @Override
    public PlanNode getPlanDescription() {
        if (this.resultSet != null) {
            return this.resultSet.getUpdatedPlanDescription();
        }
        if (this.currentPlanDescription != null) {
            return this.currentPlanDescription;
        }
        return null;
    }

    @Override
    public String getDebugLog() {
        return this.debugLog;
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getRequestIdentifier() {
        if (this.currentRequestID >= 0L) {
            return Long.toString(this.currentRequestID);
        }
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected void setAnalysisInfo(ResultsMessage resultsMsg) {
        this.debugLog = resultsMsg.getDebugLog();
        this.currentPlanDescription = resultsMsg.getPlanDescription();
        this.annotations = resultsMsg.getAnnotations();
        this.driverConnection.setDebugLog(this.debugLog);
        this.driverConnection.setCurrentPlanDescription(this.currentPlanDescription);
        this.driverConnection.setAnnotations(this.annotations);
    }

    Calendar getDefaultCalendar() {
        if (this.defaultCalendar == null) {
            this.defaultCalendar = Calendar.getInstance();
        }
        return this.defaultCalendar;
    }

    void setDefaultCalendar(Calendar cal) {
        this.defaultCalendar = cal;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkStatement();
        return false;
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        this.checkStatement();
    }

    @Override
    public ConnectionImpl getConnection() throws SQLException {
        return this.driverConnection;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkStatement();
        if (max < 0) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMStatement.Invalid_field_size", max));
        }
        this.maxFieldSize = max;
    }

    ResultSetImpl createResultSet(List records, String[] columnNames, String[] dataTypes) throws SQLException {
        Map[] metadata = new Map[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            metadata[i] = StatementImpl.getColumnMetadata(null, columnNames[i], dataTypes[i], ResultsMetadataConstants.NULL_TYPES.UNKNOWN, this.driverConnection);
        }
        return this.createResultSet(records, metadata);
    }

    ResultSetImpl createResultSet(List records, Map[] columnMetadata) throws SQLException {
        ResultSetMetaDataImpl rsmd = new ResultSetMetaDataImpl(new MetadataProvider(columnMetadata));
        return this.createResultSet(records, rsmd);
    }

    ResultSetImpl createResultSet(List records, ResultSetMetaData rsmd) throws SQLException {
        rsmd.getScale(1);
        ResultsMessage resultsMsg = StatementImpl.createDummyResultsMessage(null, null, records);
        this.resultSet = new ResultSetImpl(resultsMsg, this, rsmd, 0);
        this.resultSet.setMaxFieldSize(this.maxFieldSize);
        return this.resultSet;
    }

    static ResultsMessage createDummyResultsMessage(String[] columnNames, String[] dataTypes, List records) {
        ResultsMessage resultsMsg = new ResultsMessage();
        resultsMsg.setColumnNames(columnNames);
        resultsMsg.setDataTypes(dataTypes);
        resultsMsg.setFirstRow(1);
        resultsMsg.setLastRow(records.size());
        resultsMsg.setFinalRow(records.size());
        resultsMsg.setResults(records.toArray(new List[records.size()]));
        return resultsMsg;
    }

    static Map<Integer, Object> getColumnMetadata(String tableName, String columnName, String dataType, Integer nullable, ConnectionImpl driverConnection) throws SQLException {
        return StatementImpl.getColumnMetadata(tableName, columnName, dataType, nullable, ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, driverConnection);
    }

    static Map<Integer, Object> getColumnMetadata(String tableName, String columnName, String dataType, Integer nullable, Integer searchable, Boolean writable, Boolean signed, Boolean caseSensitive, ConnectionImpl driverConnection) throws SQLException {
        HashMap<Integer, Object> metadataMap = new HashMap<Integer, Object>();
        metadataMap.put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, driverConnection.getVDBName());
        metadataMap.put(ResultsMetadataConstants.GROUP_NAME, tableName);
        metadataMap.put(ResultsMetadataConstants.ELEMENT_NAME, columnName);
        metadataMap.put(ResultsMetadataConstants.DATA_TYPE, dataType);
        metadataMap.put(ResultsMetadataConstants.PRECISION, ResultsMetadataDefaults.getDefaultPrecision(dataType));
        metadataMap.put(ResultsMetadataConstants.RADIX, new Integer(10));
        metadataMap.put(ResultsMetadataConstants.SCALE, new Integer(0));
        metadataMap.put(ResultsMetadataConstants.AUTO_INCREMENTING, Boolean.FALSE);
        metadataMap.put(ResultsMetadataConstants.CASE_SENSITIVE, caseSensitive);
        metadataMap.put(ResultsMetadataConstants.NULLABLE, nullable);
        metadataMap.put(ResultsMetadataConstants.SEARCHABLE, searchable);
        metadataMap.put(ResultsMetadataConstants.SIGNED, signed);
        metadataMap.put(ResultsMetadataConstants.WRITABLE, writable);
        metadataMap.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        metadataMap.put(ResultsMetadataConstants.DISPLAY_SIZE, ResultsMetadataDefaults.getMaxDisplaySize(dataType));
        return metadataMap;
    }
}

