/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.XAConnectionImpl;
import org.teiid.net.CommunicationException;

public class XAResourceImpl
implements XAResource {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    private XAConnectionImpl mmConnection;
    private int timeOut;

    public static XAResourceImpl newInstance(XAConnectionImpl mmConnection) {
        return new XAResourceImpl(mmConnection);
    }

    public XAResourceImpl(XAConnectionImpl mmConnection) {
        this.mmConnection = mmConnection;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().commitTransaction(mmXid, onePhase);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedCommitTXN", xid, onePhase ? "true" : "false");
            throw this.handleError(e, logMsg);
        }
    }

    private XAException handleError(Exception e, String logMsg) {
        logger.log(Level.SEVERE, logMsg, e);
        if (e instanceof TeiidSQLException) {
            Throwable ex = ((TeiidSQLException)e).getCause();
            if (ex instanceof XAException) {
                return (XAException)ex;
            }
            if (ex instanceof XATransactionException) {
                return ((XATransactionException)ex).getXAException();
            }
        }
        return new XAException(-3);
    }

    @Override
    public void end(Xid xid, int flag) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().endTransaction(mmXid, flag);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedEndTXN", xid, new Integer(flag));
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().forgetTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedForgetTXN", xid);
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeOut;
    }

    @Override
    public boolean isSameRM(XAResource arg0) throws XAException {
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof XAResourceImpl)) {
            return false;
        }
        XAResourceImpl other = (XAResourceImpl)arg0;
        try {
            return this.getMMConnection().isSameProcess(other.getMMConnection());
        }
        catch (CommunicationException e) {
            throw this.handleError(e, JDBCPlugin.Util.getString("MMXAResource.FailedISSameRM"));
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            return this.getMMConnection().prepareTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedPrepareTXN", xid);
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        try {
            return this.getMMConnection().recoverTransaction(flag);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedRecoverTXN", flag);
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().rollbackTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedRollbackTXN", xid);
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.timeOut = seconds;
        return true;
    }

    @Override
    public void start(Xid xid, int flag) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().startTransaction(mmXid, flag, this.timeOut);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedStartTXN", xid, new Integer(flag));
            this.handleError(e, logMsg);
        }
    }

    private ConnectionImpl getMMConnection() throws XAException {
        try {
            return this.mmConnection.getConnectionImpl();
        }
        catch (SQLException e) {
            throw new XAException(-7);
        }
    }

    private XidImpl getMMXid(Xid originalXid) {
        return new XidImpl(originalXid);
    }
}

