/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.netty.handler.codec.serialization;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.teiid.core.util.AccessibleByteArrayOutputStream;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.netty.handler.codec.serialization.CompactObjectOutputStream;

public class ObjectEncoderOutputStream
extends ObjectOutputStream {
    private final DataOutputStream out;
    private final int estimatedLength;

    public ObjectEncoderOutputStream(DataOutputStream out, int estimatedLength) throws SecurityException, IOException {
        this.out = out;
        this.estimatedLength = estimatedLength;
    }

    @Override
    protected final void writeObjectOverride(Object obj) throws IOException {
        AccessibleByteArrayOutputStream baos = new AccessibleByteArrayOutputStream(this.estimatedLength);
        CompactObjectOutputStream oout = new CompactObjectOutputStream(baos);
        oout.writeObject(obj);
        ExternalizeUtil.writeCollection(oout, oout.getReferences());
        oout.flush();
        oout.close();
        this.out.writeInt(baos.getCount());
        this.out.write(baos.getBuffer(), 0, baos.getCount());
        byte[] chunk = new byte[65535];
        block0: for (InputStream is : oout.getStreams()) {
            while (true) {
                int bytes = is.read(chunk);
                this.out.writeShort(Math.max(0, bytes));
                if (bytes < 1) {
                    is.close();
                    continue block0;
                }
                this.out.write(chunk, 0, bytes);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void reset() throws IOException {
    }
}

