/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.SPage;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;

public class STree {
    private static final Random seedGenerator = new Random();
    protected int randomSeed;
    private int mask = 1;
    private int shift = 1;
    protected volatile SPage[] header = new SPage[]{new SPage(this, true)};
    protected BatchManager keyManager;
    protected BatchManager leafManager;
    protected Comparator comparator;
    protected int pageSize;
    protected int keyLength;
    protected String[] types;
    protected String[] keytypes;
    protected boolean preferMemory;
    protected ReentrantLock updateLock = new ReentrantLock();
    private AtomicInteger rowCount = new AtomicInteger();

    public STree(BatchManager manager, BatchManager leafManager, Comparator comparator, int pageSize, int keyLength, String[] types) {
        this.randomSeed = seedGenerator.nextInt() | 0x100;
        this.keyManager = manager;
        this.leafManager = leafManager;
        this.comparator = comparator;
        this.pageSize = Math.max(pageSize, 16);
        pageSize >>>= 3;
        while (pageSize > 0) {
            pageSize >>>= 1;
            ++this.shift;
            this.mask <<= 1;
            ++this.mask;
        }
        this.keyLength = keyLength;
        this.types = types;
        this.keytypes = Arrays.copyOf(types, keyLength);
    }

    protected SPage findChildTail(SPage page) {
        if (page == null) {
            page = this.header[this.header.length - 1];
            while (page.next != null) {
                page = page.next;
            }
            return page;
        }
        if (page.children != null) {
            page = page.children.get(page.children.size() - 1);
            while (page.next != null) {
                page = page.next;
            }
        }
        return page;
    }

    private int randomLevel() {
        int x = this.randomSeed;
        x ^= x << 13;
        x ^= x >>> 17;
        x ^= x << 5;
        this.randomSeed = x;
        int level = 0;
        while ((x & this.mask) == this.mask) {
            ++level;
            x >>>= this.shift;
        }
        return level;
    }

    List find(List n, LinkedList<SPage.SearchResult> places) throws TeiidComponentException {
        SPage x = null;
        for (int i = this.header.length - 1; i >= 0; --i) {
            if (x == null) {
                x = this.header[i];
            }
            SPage.SearchResult s = SPage.search(x, n, places);
            if (places != null) {
                places.add(s);
            }
            if (s.index == -1 && s.page == this.header[i] || s.values.getTuples().isEmpty()) {
                x = null;
                continue;
            }
            x = s.page;
            int index = s.index;
            boolean matched = true;
            if (index < 0) {
                matched = false;
                index = Math.max(0, -index - 2);
            }
            if (i == 0) {
                if (!matched) {
                    return null;
                }
                return s.values.getTuples().get(index);
            }
            x = x.children.get(index);
        }
        return null;
    }

    public List insert(List tuple, InsertMode mode) throws TeiidComponentException {
        LinkedList<SPage.SearchResult> places = new LinkedList<SPage.SearchResult>();
        List match = null;
        if (mode == InsertMode.ORDERED) {
            SPage last = null;
            while (last == null || last.children != null) {
                last = this.findChildTail(last);
                TupleBatch batch = last.getValues();
                places.add(new SPage.SearchResult(-batch.getTuples().size() - 1, last, batch));
            }
        } else {
            match = this.find(tuple, places);
            if (match != null) {
                if (mode != InsertMode.UPDATE) {
                    return match;
                }
                SPage.SearchResult last = places.getLast();
                SPage page = last.page;
                last.values.getTuples().set(last.index, tuple);
                page.setValues(last.values);
                return match;
            }
        }
        List key = this.extractKey(tuple);
        int level = this.randomLevel();
        assert (this.header.length == places.size());
        if (level >= this.header.length) {
            this.header = Arrays.copyOf(this.header, level + 1);
        }
        this.rowCount.addAndGet(1);
        SPage page = null;
        for (int i = 0; i <= level; ++i) {
            if (places.isEmpty()) {
                SPage newHead = new SPage(this, false);
                TupleBatch batch = newHead.getValues();
                batch.getTuples().add(key);
                newHead.setValues(batch);
                newHead.children.add(page);
                this.header[i] = newHead;
                page = newHead;
                continue;
            }
            SPage.SearchResult result = places.removeLast();
            List value = i == 0 ? tuple : page;
            page = this.insert(key, result, places.peekLast(), value, mode == InsertMode.ORDERED);
        }
        return null;
    }

    List extractKey(List tuple) {
        return tuple.subList(0, this.keyLength);
    }

    SPage insert(List k, SPage.SearchResult result, SPage.SearchResult parent, Object value, boolean ordered) throws TeiidComponentException {
        SPage page = result.page;
        int index = -result.index - 1;
        if (result.values.getTuples().size() == this.pageSize) {
            boolean leaf = !(value instanceof SPage);
            SPage nextPage = new SPage(this, leaf);
            TupleBatch nextValues = nextPage.getValues();
            nextPage.next = page.next;
            nextPage.prev = page;
            if (nextPage.next != null) {
                nextPage.next.prev = nextPage;
            }
            page.next = nextPage;
            boolean inNext = false;
            if (!ordered) {
                nextValues.getTuples().addAll(result.values.getTuples().subList(this.pageSize / 2, this.pageSize));
                result.values.getTuples().subList(this.pageSize / 2, this.pageSize).clear();
                if (!leaf) {
                    nextPage.children.addAll(page.children.subList(this.pageSize / 2, this.pageSize));
                    page.children.subList(this.pageSize / 2, this.pageSize).clear();
                }
                if (index <= this.pageSize / 2) {
                    STree.setValue(index, k, value, result.values, page);
                } else {
                    inNext = true;
                    STree.setValue(index - this.pageSize / 2, k, value, nextValues, nextPage);
                }
                page.setValues(result.values);
                if (parent != null) {
                    List min = nextPage.getValues().getTuples().get(0);
                    SPage.correctParents(parent.page, min, page, nextPage);
                }
            } else {
                inNext = true;
                STree.setValue(0, k, value, nextValues, nextPage);
            }
            nextPage.setValues(nextValues);
            if (inNext) {
                page = nextPage;
            }
        } else {
            STree.setValue(index, k, value, result.values, page);
            page.setValues(result.values);
        }
        return page;
    }

    static void setValue(int index, List key, Object value, TupleBatch values, SPage page) {
        if (value instanceof SPage) {
            values.getTuples().add(index, key);
            page.children.add(index, (SPage)value);
        } else {
            values.getTuples().add(index, (List)value);
        }
    }

    public List remove(List key) throws TeiidComponentException {
        LinkedList<SPage.SearchResult> places = new LinkedList<SPage.SearchResult>();
        List tuple = this.find(key, places);
        if (tuple == null) {
            return null;
        }
        this.rowCount.addAndGet(-1);
        for (int i = 0; i < this.header.length; ++i) {
            int size;
            SPage.SearchResult searchResult = places.removeLast();
            if (searchResult.index < 0) continue;
            searchResult.values.getTuples().remove(searchResult.index);
            if (searchResult.page.children != null) {
                searchResult.page.children.remove(searchResult.index);
            }
            if ((size = searchResult.values.getTuples().size()) == 0) {
                if (this.header[i] != searchResult.page) {
                    searchResult.page.remove();
                    if (searchResult.page.next != null) {
                        searchResult.page.next.prev = searchResult.page.prev;
                    }
                    searchResult.page.prev.next = searchResult.page.next;
                    searchResult.page.next = this.header[i];
                    searchResult.page.prev = null;
                    continue;
                }
                this.header[i].remove();
                if (this.header[i].next != null) {
                    this.header[i] = this.header[i].next;
                    this.header[i].prev = null;
                    continue;
                }
                if (i != 0) {
                    this.header = Arrays.copyOf(this.header, i);
                    break;
                }
                this.header[0] = new SPage(this, true);
                continue;
            }
            if (size < this.pageSize / 2) {
                TupleBatch prevValues;
                TupleBatch nextValues;
                if (searchResult.page.next != null && (nextValues = searchResult.page.next.getValues()).getTuples().size() < this.pageSize / 4) {
                    SPage.merge(places, nextValues, searchResult.page, searchResult.values);
                    continue;
                }
                if (searchResult.page.prev != null && (prevValues = searchResult.page.prev.getValues()).getTuples().size() < this.pageSize / 4) {
                    SPage.merge(places, searchResult.values, searchResult.page.prev, prevValues);
                    continue;
                }
            }
            searchResult.page.setValues(searchResult.values);
        }
        return tuple;
    }

    public void remove() {
        this.truncate();
        this.keyManager.remove();
        this.leafManager.remove();
    }

    public int getRowCount() {
        return this.rowCount.get();
    }

    public int truncate() {
        int oldSize = this.rowCount.getAndSet(0);
        for (int i = 0; i < this.header.length; ++i) {
            SPage page = this.header[i];
            while (page != null) {
                page.remove();
                page = page.next;
            }
        }
        this.header = new SPage[]{new SPage(this, true)};
        return oldSize;
    }

    public int getHeight() {
        return this.header.length;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = this.header.length - 1; i >= 0; --i) {
            SPage page = this.header[i];
            result.append("Level ").append(i).append(" ");
            while (page != null) {
                result.append(page);
                result.append(", ");
                page = page.next;
            }
            result.append("\n");
        }
        return result.toString();
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setPreferMemory(boolean preferMemory) {
        this.preferMemory = preferMemory;
    }

    public boolean isPreferMemory() {
        return this.preferMemory;
    }

    public static enum InsertMode {
        ORDERED,
        NEW,
        UPDATE;

    }
}

