/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import java.io.Serializable;
import org.teiid.core.CorePlugin;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.ObjectID;
import org.teiid.core.util.Assertion;

public class UUID
implements ObjectID,
Serializable {
    private static final String NOT_UUID_MESSAGE = CorePlugin.Util.getString("UUID.ID_must_be_of_type_UUID_1");
    private static final String UNPARSABLE_MESSAGE = CorePlugin.Util.getString("UUID.ID_must_be_of_type_UUID_to_parse_2");
    public static final String PROTOCOL = "mmuuid";
    public static final String PROTOCOL_UCASE = "mmuuid".toUpperCase();
    private static final int ID_STRING_LEN = 36;
    public static final int FQ_LENGTH = "mmuuid".length() + 1 + 36;
    private final java.util.UUID uuid;
    private String cachedExportableFormUuidString;

    public UUID(long mostSig, long leastSig) {
        this.uuid = new java.util.UUID(mostSig, leastSig);
    }

    public UUID(java.util.UUID uuid) {
        this.uuid = uuid;
    }

    public static long getPart1(ObjectID id) {
        Assertion.assertTrue((boolean)(id instanceof UUID), (String)UNPARSABLE_MESSAGE);
        UUID uuid = (UUID)id;
        return uuid.uuid.getMostSignificantBits();
    }

    public static long getPart2(ObjectID id) {
        Assertion.assertTrue((boolean)(id instanceof UUID), (String)UNPARSABLE_MESSAGE);
        UUID uuid = (UUID)id;
        return uuid.uuid.getLeastSignificantBits();
    }

    public static int getVariant(ObjectID id) {
        Assertion.assertTrue((boolean)(id instanceof UUID), (String)NOT_UUID_MESSAGE);
        UUID uuid = (UUID)id;
        return uuid.uuid.variant();
    }

    public static int getVersion(ObjectID id) {
        Assertion.assertTrue((boolean)(id instanceof UUID), (String)NOT_UUID_MESSAGE);
        UUID uuid = (UUID)id;
        return uuid.uuid.version();
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UUID) {
            UUID that = (UUID)obj;
            return this.uuid.equals(that.uuid);
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        UUID that = (UUID)obj;
        return this.uuid.compareTo(that.uuid);
    }

    @Override
    public String toString() {
        return this.toString(':');
    }

    @Override
    public String toString(char delim) {
        return new StringBuffer(43).append(PROTOCOL).append(delim).append(this.exportableForm()).toString();
    }

    public String exportableForm() {
        if (this.cachedExportableFormUuidString == null) {
            this.cachedExportableFormUuidString = this.uuid.toString();
        }
        return this.cachedExportableFormUuidString;
    }

    public static ObjectID stringToObject(String value) throws InvalidIDException {
        try {
            return new UUID(java.util.UUID.fromString(value));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("UUID.InvalidFormatForProtocol", new Object[]{value, PROTOCOL}));
        }
    }

    class Version {
        public static final int TIME_BASED = 1;
        public static final int DCE_RESERVED = 2;
        public static final int NAME_BASED = 3;
        public static final int PSEUDO_RANDOM = 4;

        Version() {
        }
    }

    class Variant {
        public static final int NSC_COMPATIBLE = 0;
        public static final int STANDARD = 2;
        public static final int MICROSOFT = 6;
        public static final int RESERVED_FUTURE = 7;

        Variant() {
        }
    }
}

