/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;

public class BatchCollector {
    private BatchProducer sourceNode;
    private boolean done = false;
    private TupleBuffer buffer;

    public BatchCollector(BatchProducer sourceNode, TupleBuffer buffer) {
        this.sourceNode = sourceNode;
        this.buffer = buffer;
    }

    public TupleBuffer collectTuples() throws TeiidComponentException, TeiidProcessingException {
        TupleBatch batch = null;
        while (!this.done) {
            batch = this.sourceNode.nextBatch();
            this.flushBatch(batch);
            if (!batch.getTerminationFlag()) continue;
            this.done = true;
            this.buffer.close();
            break;
        }
        return this.buffer;
    }

    public TupleBuffer getTupleBuffer() {
        return this.buffer;
    }

    private void flushBatch(TupleBatch batch) throws TeiidComponentException, TeiidProcessingException {
        if (batch.getRowCount() == 0 && !batch.getTerminationFlag()) {
            return;
        }
        this.flushBatchDirect(batch, true);
    }

    protected void flushBatchDirect(TupleBatch batch, boolean add) throws TeiidComponentException, TeiidProcessingException {
        this.buffer.addTupleBatch(batch, add);
    }

    public int getRowCount() {
        return this.buffer.getRowCount();
    }

    public static class BatchProducerTupleSource
    implements TupleSource {
        private final BatchProducer sourceNode;
        private TupleBatch sourceBatch;
        private int sourceRow = 1;

        public BatchProducerTupleSource(BatchProducer sourceNode) {
            this.sourceNode = sourceNode;
        }

        @Override
        public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            while (true) {
                if (this.sourceBatch == null) {
                    this.sourceBatch = this.sourceNode.nextBatch();
                }
                if (this.sourceBatch.getRowCount() > 0 && this.sourceRow <= this.sourceBatch.getEndRow()) {
                    List tuple = this.sourceBatch.getTuple(this.sourceRow);
                    tuple = this.updateTuple(tuple);
                    ++this.sourceRow;
                    return tuple;
                }
                if (this.sourceBatch.getTerminationFlag()) {
                    this.sourceBatch = null;
                    return null;
                }
                this.sourceBatch = null;
            }
        }

        protected List updateTuple(List tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
            return tuple;
        }

        @Override
        public void closeSource() {
        }
    }

    public static interface BatchProducer {
        public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException;

        public List getOutputElements();
    }
}

