/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.model.ui.IStructuredChangeListener;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.StructuredChange;
import org.jboss.tools.common.model.ui.StructuredChangedEvent;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class StructuredListAdapter
extends DefaultValueAdapter
implements IStructuredChangeListener,
IListContentProvider {
    protected static final String DEFAULT_DELIMITER = ";";
    ILabelProvider labelProvider = new LabelProvider();
    INewValueProvider newValueProvider = null;
    String delimiter = ";";
    boolean trim = false;

    public void setAttribute(XAttribute attribute) {
        super.setAttribute(attribute);
        this.setDelimiter(attribute);
    }

    public void setAttributeData(XAttributeData data) {
        super.setAttributeData(data);
        this.setDelimiter(data.getAttribute());
    }

    private void setDelimiter(XAttribute attribute) {
        String s = attribute.getProperty("delimiter");
        if (s != null && s.equals("comma")) {
            s = ",";
        }
        this.delimiter = s == null || s.length() != 1 ? DEFAULT_DELIMITER : s;
        this.trim = "true".equals(attribute.getProperty("trim"));
        String newValueClassName = attribute.getProperty("newValueClassName");
        if (newValueClassName != null) {
            try {
                this.newValueProvider = (INewValueProvider)ModelFeatureFactory.getInstance().createFeatureInstance(newValueClassName);
            }
            catch (ClassCastException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        result = adapter == INewValueProvider.class ? this.newValueProvider : (adapter == IValueChangeListener.class ? this : (adapter == IStructuredChangeListener.class ? this : (adapter == IListContentProvider.class ? this : (adapter == ILabelProvider.class ? this.labelProvider : super.getAdapter(adapter)))));
        return result;
    }

    public void structureChanged(StructuredChangedEvent event) {
        StringBuffer newValue = new StringBuffer();
        StructuredChange change = (StructuredChange)event.getChange();
        Iterator iterator = change.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                newValue.append(iterator.next());
                if (!iterator.hasNext()) continue;
                newValue.append(this.delimiter);
            }
        }
        this.setValue(newValue.toString());
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.getStringValue(true), this.delimiter);
        while (tokenizer.hasMoreTokens()) {
            String t = tokenizer.nextToken();
            if (this.trim) {
                t = t.trim();
            }
            tokens.add(t);
        }
        return tokens.toArray();
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        this.labelProvider = null;
        this.newValueProvider = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setNewValueProvider(INewValueProvider provider) {
        this.newValueProvider = provider;
    }

    public static interface INewValueProvider {
        public Object getValue();
    }
}

