/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.Argument;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Delete;
import org.teiid.language.DerivedColumn;
import org.teiid.language.DerivedTable;
import org.teiid.language.Exists;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Function;
import org.teiid.language.GroupBy;
import org.teiid.language.In;
import org.teiid.language.Insert;
import org.teiid.language.IsNull;
import org.teiid.language.IteratorValueSource;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Not;
import org.teiid.language.OrderBy;
import org.teiid.language.ScalarSubquery;
import org.teiid.language.SearchedCase;
import org.teiid.language.SearchedWhenClause;
import org.teiid.language.Select;
import org.teiid.language.SetClause;
import org.teiid.language.SetQuery;
import org.teiid.language.SortSpecification;
import org.teiid.language.SubqueryComparison;
import org.teiid.language.SubqueryIn;
import org.teiid.language.Update;
import org.teiid.language.visitor.DelegatingHierarchyVisitor;
import org.teiid.language.visitor.LanguageObjectVisitor;

public class CollectorVisitor<T>
implements LanguageObjectVisitor {
    private Class<T> type;
    private Collection<T> objects = new ArrayList<T>();

    public CollectorVisitor(Class<T> type) {
        this.type = type;
    }

    private void checkInstance(LanguageObject obj) {
        if (this.type.isInstance(obj)) {
            this.objects.add(obj);
        }
    }

    public Collection<T> getCollectedObjects() {
        return this.objects;
    }

    @Override
    public void visit(AggregateFunction obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(BatchedUpdates obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Comparison obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(AndOr obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Delete obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ColumnReference obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Exists obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Function obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(NamedTable obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(GroupBy obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(In obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(DerivedTable obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Insert obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ExpressionValueSource obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IsNull obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Join obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Like obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Limit obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Literal obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Not obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(OrderBy obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(SortSpecification obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Argument obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Call obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Select obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(SearchedCase obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(DerivedColumn obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(SubqueryComparison obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(SubqueryIn obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(Update obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(SetQuery obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(SetClause obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(SearchedWhenClause obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IteratorValueSource obj) {
        this.checkInstance(obj);
    }

    public static <T> Collection<T> collectObjects(Class<T> type, LanguageObject object) {
        CollectorVisitor<T> visitor = new CollectorVisitor<T>(type);
        DelegatingHierarchyVisitor hierarchyVisitor = new DelegatingHierarchyVisitor(visitor, null);
        object.acceptVisitor(hierarchyVisitor);
        return visitor.getCollectedObjects();
    }

    public static Collection<ColumnReference> collectElements(LanguageObject object) {
        return CollectorVisitor.collectObjects(ColumnReference.class, object);
    }

    public static Collection<NamedTable> collectGroups(LanguageObject object) {
        return CollectorVisitor.collectObjects(NamedTable.class, object);
    }

    public static Set<NamedTable> collectGroupsUsedByElements(LanguageObject object) {
        HashSet<NamedTable> groups = new HashSet<NamedTable>();
        for (ColumnReference element : CollectorVisitor.collectElements(object)) {
            if (element.getTable() == null) continue;
            groups.add(element.getTable());
        }
        return groups;
    }
}

