/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNSRange;
import org.mozilla.interfaces.nsIDOMNSUIEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMRange;
import org.mozilla.interfaces.nsISelection;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class VisualDomUtil {
    public static String JSF_CORE_URI = "http://java.sun.com/jsf/core";
    public static String JSF_HTML_URI = "http://java.sun.com/jsf/html";
    public static String RICH_FACES_URI = "http://richfaces.org/rich";
    public static String A4J_URI = "http://richfaces.org/a4j";
    public static String FACELETS_URI = "http://java.sun.com/jsf/facelets";
    public static String FACET_JSF_TAG = "FACET-JSF-TAG";
    public static String FACET_ODD_TAGS = "FACET-ODD-TAGS";
    public static String FACET_HTML_TAGS = "FACET-HTML-TAGS";
    private static final String ACCESSIBILITY_SERVICE_CONTRACT_ID = "@mozilla.org/accessibilityService;1";
    private static Set<String> escapedTags = new HashSet<String>();

    static {
        escapedTags.add("f:facet");
        escapedTags.add("f:selectItem");
        escapedTags.add("f:selectItems");
    }

    public static nsIDOMNode getAncestorNode(nsIDOMNode visualNode, String tagName) {
        if (tagName == null) {
            return null;
        }
        nsIDOMNode element = visualNode;
        do {
            if (!tagName.equalsIgnoreCase(element.getNodeName())) continue;
            return element;
        } while ((element = element.getParentNode()) != null);
        return null;
    }

    public static Point getMousePoint(nsIDOMMouseEvent mouseEvent) {
        nsIDOMNSUIEvent uiEvent = (nsIDOMNSUIEvent)XPCOM.queryInterface((nsISupports)mouseEvent, nsIDOMNSUIEvent.class);
        return new Point(uiEvent.getPageX(), uiEvent.getPageY());
    }

    public static long getChildCount(nsIDOMNode node) {
        long count = 0L;
        nsIDOMNodeList children = node.getChildNodes();
        if (children != null) {
            count = children.getLength();
        }
        return count;
    }

    public static nsIDOMNode getChildNode(nsIDOMNode node, long index) {
        nsIDOMNode child = null;
        nsIDOMNodeList children = node.getChildNodes();
        if (children != null && index >= 0L && index < children.getLength()) {
            child = children.item(index);
        }
        return child;
    }

    public static long getOffset(nsIDOMNode node) {
        long offset = 0L;
        nsIDOMNode previousSibling = node;
        while ((previousSibling = previousSibling.getPreviousSibling()) != null) {
            ++offset;
        }
        return offset;
    }

    public static nsIDOMNode getTargetNode(nsIDOMEvent event) {
        return (nsIDOMNode)XPCOM.queryInterface((nsISupports)event.getTarget(), nsIDOMNode.class);
    }

    public static boolean isSelectionContains(nsISelection selection, nsIDOMNode parent, int offset) {
        nsIDOMNode endContainer;
        if (selection.getIsCollapsed()) {
            return false;
        }
        nsIDOMRange range = selection.getRangeAt(0);
        boolean inSelection = VisualDomUtil.isRangeContains(range, parent, offset);
        if (inSelection && (endContainer = range.getEndContainer()).getNodeType() != 3) {
            int endOffset = range.getEndOffset();
            inSelection = !parent.equals(endContainer) || offset != endOffset;
        }
        return inSelection;
    }

    public static boolean isRangeContains(nsIDOMRange range, nsIDOMNode parent, int offset) {
        nsIDOMNSRange domNSRange = (nsIDOMNSRange)XPCOM.queryInterface((nsISupports)range, nsIDOMNSRange.class);
        boolean inRange = domNSRange.isPointInRange(parent, offset);
        return inRange;
    }

    public static void replaceNodeByItsChildren(nsIDOMNode node) {
        nsIDOMNodeList subTableContainerChildren = node.getChildNodes();
        nsIDOMNode containerParent = node.getParentNode();
        if (subTableContainerChildren != null) {
            int length = (int)subTableContainerChildren.getLength();
            int i = 0;
            while (i < length) {
                nsIDOMNode child = subTableContainerChildren.item((long)i);
                node.removeChild(child);
                containerParent.insertBefore(child, node);
                ++i;
            }
        }
        containerParent.removeChild(node);
    }

    public static void setSubAttribute(nsIDOMElement element, String attributeName, String subAttributeName, String subAttributeValue) {
        String attributeValue = element.getAttribute(attributeName);
        attributeValue = attributeValue == null ? "" : VpeStyleUtil.deleteFromString(attributeValue, subAttributeName, ";");
        if (attributeValue.length() > 0 && !attributeValue.endsWith(";")) {
            attributeValue = String.valueOf(attributeValue) + ";";
        }
        attributeValue = String.valueOf(attributeValue) + subAttributeName + ":" + subAttributeValue + ";";
        element.setAttribute(attributeName, attributeValue);
    }

    public static void copyAttributes(Node sourceNode, nsIDOMElement visualElement) {
        NamedNodeMap namedNodeMap = sourceNode.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            block3: {
                Node attribute = namedNodeMap.item(i);
                try {
                    visualElement.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
                }
                catch (XPCOMException ex) {
                    if (ex.errorcode == 2152923141L) break block3;
                    throw ex;
                }
            }
            ++i;
        }
    }

    public static void copyAttribute(Element sourceElement, String sourceAttrName, nsIDOMElement visualElement, String visualAttrName) {
        if (sourceElement.hasAttribute(sourceAttrName)) {
            String attrValue = sourceElement.getAttribute(sourceAttrName);
            visualElement.setAttribute(visualAttrName, attrValue);
        }
    }

    public static void copyAttributes(Element sourceElement, nsIDOMElement visualElement, List<String> attributes) {
        for (String attributeName : attributes) {
            VisualDomUtil.copyAttribute(sourceElement, attributeName, visualElement, attributeName);
        }
    }

    public static void copyAttributes(Element sourceElement, nsIDOMElement visualElement, Map<String, String> sourceToVisualMap) {
        for (Map.Entry<String, String> sourceToVisual : sourceToVisualMap.entrySet()) {
            String sourceAttrName = sourceToVisual.getKey();
            String visualAttrName = sourceToVisual.getValue();
            VisualDomUtil.copyAttribute(sourceElement, sourceAttrName, visualElement, visualAttrName);
        }
    }

    public static nsIDOMElement createBorderlessContainer(nsIDOMDocument visualDocument) {
        return VisualDomUtil.createBorderlessContainer(visualDocument, "span");
    }

    public static nsIDOMElement createBorderlessContainer(nsIDOMDocument visualDocument, String containerName) {
        nsIDOMElement element = visualDocument.createElement(containerName);
        element.setAttribute("class", "vpe-text");
        return element;
    }

    public static void appendChildrenInsertionPoint(Element source, nsIDOMElement target, VpeCreationData creationData, nsIDOMDocument visualDocument) {
        nsIDOMElement childrenContainer = VisualDomUtil.createBorderlessContainer(visualDocument);
        target.appendChild((nsIDOMNode)childrenContainer);
        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(childrenContainer);
        NodeList childNodes = source.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            childrenInfo.addSourceChild(childNodes.item(i));
            ++i;
        }
        creationData.addChildrenInfo(childrenInfo);
    }

    public static VpeCreationData createTemplateWithTextContainer(Element sourceElement, nsIDOMElement templateContainer, String borderlessContainerName, nsIDOMDocument visualDocument) {
        ArrayList<Node> children = new ArrayList<Node>();
        VpeCreationData creationData = null;
        NodeList nodeList = sourceElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            if (!escapedTags.contains(child.getNodeName())) {
                children.add(child);
            }
            ++i;
        }
        if (children != null && children.size() > 0) {
            nsIDOMElement topContainer = VisualDomUtil.createBorderlessContainer(visualDocument, borderlessContainerName);
            nsIDOMElement textContainer = VisualDomUtil.createBorderlessContainer(visualDocument, borderlessContainerName);
            topContainer.appendChild((nsIDOMNode)textContainer);
            topContainer.appendChild((nsIDOMNode)templateContainer);
            creationData = new VpeCreationData((nsIDOMNode)topContainer);
            VpeChildrenInfo textInfo = new VpeChildrenInfo(textContainer);
            creationData.addChildrenInfo(textInfo);
            for (Node child : children) {
                textInfo.addSourceChild(child);
            }
        } else {
            creationData = new VpeCreationData((nsIDOMNode)templateContainer);
        }
        return creationData;
    }

    public static nsIDOMElement findVisualTagWithFacetAttribute(nsIDOMNode facetsParentNode, String facetName) {
        nsIDOMElement tagForFacet = null;
        if (facetsParentNode != null) {
            nsIDOMNodeList nodeList = facetsParentNode.getChildNodes();
            int i = 0;
            while ((long)i < nodeList.getLength()) {
                String facetAttributeName;
                nsIDOMElement element = null;
                try {
                    element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)nodeList.item((long)i), nsIDOMElement.class);
                }
                catch (XPCOMException xPCOMException) {
                    return null;
                }
                if (element.hasAttribute("VPE-FACET") && (facetAttributeName = element.getAttribute("VPE-FACET")).indexOf(facetName) >= 0) {
                    return element;
                }
                tagForFacet = VisualDomUtil.findVisualTagWithFacetAttribute((nsIDOMNode)element, facetName);
                if (tagForFacet != null) {
                    return tagForFacet;
                }
                ++i;
            }
        }
        return tagForFacet;
    }

    public static Map<String, List<Node>> findFacetElements(Node facet, VpePageContext pageContext) {
        HashMap<String, List<Node>> facetChildren = new HashMap<String, List<Node>>();
        ArrayList<Node> jsfTag = new ArrayList<Node>(0);
        ArrayList<Node> oddTags = new ArrayList<Node>(0);
        ArrayList<Node> htmlTags = new ArrayList<Node>(0);
        facetChildren.put(FACET_JSF_TAG, jsfTag);
        facetChildren.put(FACET_ODD_TAGS, oddTags);
        facetChildren.put(FACET_HTML_TAGS, htmlTags);
        if (facet != null) {
            NodeList children = facet.getChildNodes();
            Node lastJSFComponent = null;
            int i = 0;
            while (i < children.getLength()) {
                List<TaglibData> taglibs;
                Node child = children.item(i);
                String sourcePrefix = child.getPrefix();
                TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourcePrefix, taglibs = XmlUtil.getTaglibsForNode(child, pageContext));
                if (sourceNodeTaglib != null) {
                    String sourceNodeUri = sourceNodeTaglib.getUri();
                    if (JSF_CORE_URI.equalsIgnoreCase(sourceNodeUri) || JSF_HTML_URI.equalsIgnoreCase(sourceNodeUri) || RICH_FACES_URI.equalsIgnoreCase(sourceNodeUri) || A4J_URI.equalsIgnoreCase(sourceNodeUri) || FACELETS_URI.equalsIgnoreCase(sourceNodeUri)) {
                        lastJSFComponent = child;
                        oddTags.add(child);
                    } else {
                        oddTags.add(child);
                    }
                } else if (child instanceof Text) {
                    Text textNode = (Text)child;
                    if (textNode.getNodeValue().trim().length() > 0) {
                        htmlTags.add(child);
                    }
                } else {
                    htmlTags.add(child);
                }
                ++i;
            }
            if (lastJSFComponent != null) {
                oddTags.remove(lastJSFComponent);
                jsfTag.add(lastJSFComponent);
            }
        }
        return facetChildren;
    }

    public static boolean isAscendant(nsIDOMNode potentialAscendant, nsIDOMNode potentialDescendant) {
        while (potentialDescendant != null) {
            if (!potentialAscendant.equals(potentialDescendant = potentialDescendant.getParentNode())) continue;
            return true;
        }
        return false;
    }
}

