/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.model.IReverseEngineeringDefinition;
import org.hibernate.eclipse.console.model.ITableFilter;
import org.hibernate.eclipse.console.wizards.TableFilterCellModifier;
import org.hibernate.eclipse.console.wizards.TableFilterContentProvider;
import org.hibernate.eclipse.console.wizards.TableFilterLabelProvider;
import org.hibernate.eclipse.console.wizards.TreeToTableComposite;
import org.hibernate.eclipse.console.workbench.DeferredContentProvider;
import org.hibernate.eclipse.console.workbench.LazyDatabaseSchema;
import org.hibernate.eclipse.console.workbench.TableContainer;
import org.hibernate.eclipse.console.workbench.xpl.AnyAdaptableLabelProvider;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.util.StringHelper;

public abstract class TableFilterView
extends TreeToTableComposite {
    protected TreeViewer viewer;
    private TableViewer tableViewer;
    protected IReverseEngineeringDefinition revEngDef;

    public TableFilterView(Composite parent, int style) {
        super(parent, style);
    }

    protected TreeViewer createTreeViewer() {
        TreeViewer viewer = new TreeViewer(this.tree);
        viewer.setLabelProvider((IBaseLabelProvider)new AnyAdaptableLabelProvider());
        viewer.setContentProvider((IContentProvider)new DeferredContentProvider());
        viewer.setInput(null);
        return viewer;
    }

    public void setModel(IReverseEngineeringDefinition revEngDef) {
        this.revEngDef = revEngDef;
        this.tableViewer.setInput((Object)revEngDef);
    }

    protected void initialize() {
        super.initialize();
        this.tableViewer = this.createTableFilterViewer();
        this.viewer = this.createTreeViewer();
    }

    private TableViewer createTableFilterViewer() {
        TableViewer result = new TableViewer(this.rightTable);
        result.setUseHashlookup(true);
        result.setColumnProperties(new String[]{"inclusion", "catalog", "schema", "name"});
        CellEditor[] editors = new CellEditor[result.getColumnProperties().length];
        editors[0] = new CheckboxCellEditor((Composite)result.getTable());
        editors[1] = new TextCellEditor((Composite)result.getTable());
        editors[2] = new TextCellEditor((Composite)result.getTable());
        editors[3] = new TextCellEditor((Composite)result.getTable());
        result.setCellEditors(editors);
        result.setCellModifier((ICellModifier)new TableFilterCellModifier(result));
        result.setLabelProvider((IBaseLabelProvider)new TableFilterLabelProvider());
        result.setContentProvider((IContentProvider)new TableFilterContentProvider(result));
        return result;
    }

    protected void doRefreshTree() {
        ConsoleConfiguration configuration = KnownConfigurations.getInstance().find(this.getConsoleConfigurationName());
        if (configuration != null) {
            this.viewer.setInput((Object)new LazyDatabaseSchema(configuration));
        }
    }

    protected abstract String getConsoleConfigurationName();

    protected void doInclusion() {
        this.toggle(false);
    }

    ITableFilter[] getTableFilterList() {
        return this.revEngDef.getTableFilters();
    }

    protected void toggle(boolean exclude) {
        ISelection selection = this.viewer.getSelection();
        if (!selection.isEmpty()) {
            StructuredSelection ss = (StructuredSelection)selection;
            for (Object sel : ss) {
                ITableFilter filter = null;
                if (sel instanceof Table) {
                    Table table = (Table)sel;
                    filter = this.revEngDef.createTableFilter();
                    if (StringHelper.isNotEmpty((String)table.getName())) {
                        filter.setMatchName(table.getName());
                    }
                    if (StringHelper.isNotEmpty((String)table.getCatalog())) {
                        filter.setMatchCatalog(table.getCatalog());
                    }
                    if (StringHelper.isNotEmpty((String)table.getSchema())) {
                        filter.setMatchSchema(table.getSchema());
                    }
                    filter.setExclude(exclude);
                } else if (sel instanceof TableContainer) {
                    TableContainer tc = (TableContainer)sel;
                    filter = this.revEngDef.createTableFilter();
                    String schema = tc.getName();
                    if (schema == null || "".equals(schema)) {
                        filter.setMatchCatalog(".*");
                        filter.setMatchSchema(".*");
                    } else {
                        String catalog = StringHelper.qualifier((String)schema);
                        schema = StringHelper.unqualify((String)schema);
                        filter.setMatchCatalog("".equals(catalog) ? ".*" : catalog);
                        filter.setMatchSchema("".equals(schema) ? ".*" : schema);
                    }
                    filter.setMatchName(".*");
                    filter.setExclude(exclude);
                } else {
                    if (sel instanceof Column) {
                        return;
                    }
                    filter = this.revEngDef.createTableFilter();
                    filter.setExclude(exclude);
                }
                this.revEngDef.addTableFilter(filter);
            }
        } else {
            ITableFilter filter = this.revEngDef.createTableFilter();
            filter.setMatchName(".*");
            filter.setExclude(exclude);
            this.revEngDef.addTableFilter(filter);
        }
    }

    protected void doExclusion() {
        this.toggle(true);
    }

    protected String[] getAddButtonLabels() {
        return new String[]{HibernateConsoleMessages.TableFilterView_include, HibernateConsoleMessages.TableFilterView_exclude};
    }

    protected void handleAddButtonPressed(int i) {
        switch (i) {
            case 0: {
                this.doInclusion();
                break;
            }
            case 1: {
                this.doExclusion();
                break;
            }
            default: {
                throw new IllegalArgumentException(NLS.bind((String)HibernateConsoleMessages.TableFilterView_not_known_button, (Object)i));
            }
        }
    }

    protected void doRemoveAll() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)HibernateConsoleMessages.TableFilterView_remove_all_filters, (String)HibernateConsoleMessages.TableFilterView_do_you_want_to_remove_all_filters)) {
            this.revEngDef.removeAllTableFilters();
        }
    }

    protected void doRemove() {
        int sel = this.rightTable.getSelectionIndex();
        TableItem[] selection = this.rightTable.getSelection();
        int i = 0;
        while (i < selection.length) {
            ITableFilter item = (ITableFilter)selection[i].getData();
            this.revEngDef.removeTableFilter(item);
            ++i;
        }
        this.rightTable.setSelection(Math.min(sel, this.rightTable.getItemCount() - 1));
    }

    protected void doMoveDown() {
        TableItem[] selection = this.rightTable.getSelection();
        int i = 0;
        while (i < selection.length) {
            ITableFilter item = (ITableFilter)selection[i].getData();
            this.revEngDef.moveTableFilterDown(item);
            ++i;
        }
    }

    protected void doMoveUp() {
        TableItem[] selection = this.rightTable.getSelection();
        int i = 0;
        while (i < selection.length) {
            ITableFilter item = (ITableFilter)selection[i].getData();
            this.revEngDef.moveTableFilterUp(item);
            ++i;
        }
    }

    protected void createTableColumns(org.eclipse.swt.widgets.Table table) {
        TableColumn column = new TableColumn(table, 0x1000000, 0);
        column.setText(HibernateConsoleMessages.TableFilterView_sign);
        column.setWidth(20);
        column = new TableColumn(table, 16384, 1);
        column.setText(HibernateConsoleMessages.TableFilterView_catalog);
        column.setWidth(100);
        column = new TableColumn(table, 16384, 2);
        column.setText(HibernateConsoleMessages.TableFilterView_schema);
        column.setWidth(100);
        column = new TableColumn(table, 16384, 3);
        column.setText(HibernateConsoleMessages.TableFilterView_table);
        column.setWidth(100);
    }

    public void dispose() {
        super.dispose();
    }
}

