/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.IoException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.AbstractValueFactory;
import org.modeshape.graph.property.basic.UuidReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class UuidValueFactory
extends AbstractValueFactory<UUID>
implements UuidFactory {
    public UuidValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.UUID, decoder, stringValueFactory);
    }

    @Override
    public UUID create() {
        return UUID.randomUUID();
    }

    @Override
    public UUID create(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException err) {
            throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), URI.class.getSimpleName(), value}), err);
        }
    }

    @Override
    public UUID create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public UUID create(int value) {
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Integer.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(long value) {
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Long.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(boolean value) {
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Boolean.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(float value) {
        throw new ValueFormatException((Object)Float.valueOf(value), PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Float.class.getSimpleName(), Float.valueOf(value)}));
    }

    @Override
    public UUID create(double value) {
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Double.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(BigDecimal value) {
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), BigDecimal.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Calendar value) {
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Calendar.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Date value) {
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(DateTime value) throws ValueFormatException {
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), DateTime.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Name value) {
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Path value) {
        if (value.isIdentifier()) {
            Path.Segment segment = value.getLastSegment();
            assert (segment.isIdentifier());
            try {
                String id = segment.getName().getLocalName();
                return UUID.fromString(id);
            }
            catch (IllegalArgumentException err) {
                throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
            }
        }
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Path.Segment value) {
        if (value.isIdentifier()) {
            try {
                String id = value.getName().getLocalName();
                return UUID.fromString(id);
            }
            catch (IllegalArgumentException err) {
                throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value}));
            }
        }
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Reference value) {
        if (value instanceof UuidReference) {
            UuidReference ref = (UuidReference)value;
            return ref.getUuid();
        }
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(URI value) {
        throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), URI.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(UUID value) {
        return value;
    }

    @Override
    public UUID create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public UUID create(Binary value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public UUID create(InputStream stream, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(stream, approximateLength));
    }

    @Override
    public UUID create(Reader reader, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(reader, approximateLength));
    }

    protected UUID[] createEmptyArray(int length) {
        return new UUID[length];
    }
}

