/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers;

import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.DeleteFileHandler;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.webprj.model.helpers.sync.StrutsWebHelper;

public class DeleteStrutsConfigHandler
extends DeleteFileHandler {
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        String uri = this.getURI(object);
        if (uri == null) {
            return;
        }
        boolean unregister = false;
        if (StrutsWebHelper.isConfigRegistered(object.getModel(), uri)) {
            ServiceDialog d = object.getModel().getService();
            Properties pd = new Properties();
            String message = NLS.bind((String)StrutsUIMessages.DELETE_STRUTS_CONFIGFILE_NAME, (Object)FileAnyImpl.toFileName((XProperty)object));
            pd.setProperty("message", message);
            pd.setProperty("checkboxMessage", StrutsUIMessages.DELETE_REFERENCE_FROM_WEBXML);
            pd.put("checked", new Boolean(true));
            if (!d.openConfirm(pd)) {
                return;
            }
            Boolean b = (Boolean)pd.get("checked");
            unregister = b;
        }
        super.executeHandler(object, p);
        if (object.isActive()) {
            return;
        }
        if (unregister) {
            StrutsWebHelper.unregisterConfig(object.getModel(), uri);
        }
    }

    private String getURI(XModelObject object) {
        String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
        if (path == null) {
            return null;
        }
        String uri = "/WEB-INF" + path;
        if (XModelImpl.getByRelativePath((XModel)object.getModel(), (String)path) != object) {
            uri = path;
        }
        return uri;
    }

    public boolean getSignificantFlag(XModelObject object) {
        String uri = this.getURI(object);
        return uri != null && !StrutsWebHelper.isConfigRegistered(object.getModel(), uri);
    }
}

