/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.MoveHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XOrderedObject;
import org.jboss.tools.common.model.undo.XMoveUndo;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.model.ReferenceObjectImpl;
import org.jboss.tools.struts.model.handlers.StrutsCopyHandler;

public class StrutsMoveHandler
extends MoveHandler
implements StrutsConstants {
    public boolean isEnabled(XModelObject object) {
        if (this.isMoveOfLink(object)) {
            return true;
        }
        if (object instanceof ReferenceObjectImpl) {
            XModelObject ref = ((ReferenceObjectImpl)object).getReference();
            if (ref == null) {
                String tp = object.getAttributeValue("type");
                if ("link".equals(tp)) {
                    return super.isEnabled(object);
                }
                return false;
            }
            object = ref;
        }
        return super.isEnabled(object);
    }

    private boolean isMoveOfLink(XModelObject object) {
        if (!(object instanceof ReferenceObjectImpl)) {
            return false;
        }
        String tp = object.getAttributeValue("type");
        return "link".equals(tp) && super.isEnabled(object);
    }

    public void executeHandler(XModelObject object, Properties prop) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        if (this.isMoveOfLink(object)) {
            super.executeHandler(object, prop);
            return;
        }
        XModelObject[] ps = this.getParticipants(object);
        if (ps != null) {
            this.executeTransaction(ps);
        }
    }

    private XModelObject findObjectByRef(XModelObject ref) {
        XModelObject f = ref;
        while (f != null && f.getFileType() < 1) {
            f = f.getParent();
        }
        return f == null ? null : this.findObjectByRef(f.getChildByPath("process"), ref);
    }

    private XModelObject findObjectByRef(XModelObject p, XModelObject ref) {
        ReferenceObjectImpl o;
        if (p instanceof ReferenceObjectImpl && (o = (ReferenceObjectImpl)p).getReference() == ref) {
            return p;
        }
        XModelObject[] cs = p.getChildren();
        int i = 0;
        while (i < cs.length) {
            XModelObject o2 = this.findObjectByRef(cs[i], ref);
            if (o2 != null) {
                return o2;
            }
            ++i;
        }
        return null;
    }

    public void executeTransaction(XModelObject[] ps) throws XModelException {
        XUndoManager undo = ps[0].getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo("move " + DefaultCreateHandler.title((XModelObject)ps[1], (boolean)false), 0);
        undo.addUndoable((XUndoable)u);
        try {
            try {
                this.transaction(ps);
            }
            catch (Exception e) {
                undo.rollbackTransactionInProgress();
                throw new XModelException((Throwable)e);
            }
        }
        finally {
            u.commit();
        }
    }

    private void transaction(XModelObject[] ps) throws Exception {
        XModelObject p = ps[0].getParent();
        XOrderedObject oo = (XOrderedObject)p;
        int to1 = oo.getIndexOfChild(ps[0]);
        int from1 = oo.getIndexOfChild(ps[1]);
        oo.move(from1, to1, true);
        ps[0].getModel().getUndoManager().addUndoable((XUndoable)new XMoveUndo(p, from1, to1));
        p = ps[2].getParent();
        oo = (XOrderedObject)p;
        int to2 = oo.getIndexOfChild(ps[2]);
        int from2 = oo.getIndexOfChild(ps[3]);
        if (from1 > to1 == from2 > to2) {
            oo.move(from2, to2, true);
            ps[0].getModel().getUndoManager().addUndoable((XUndoable)new XMoveUndo(p, from2, to2));
        }
    }

    private XModelObject[] getParticipants(XModelObject object) {
        XModelObject[] ps = new XModelObject[4];
        ps[0] = object;
        XModelObject xModelObject = ps[2] = ps[0] instanceof ReferenceObjectImpl ? ((ReferenceObjectImpl)ps[0]).getReference() : this.findObjectByRef(ps[0]);
        if (ps[2] == null) {
            return null;
        }
        ps[1] = this.getSource(object.getModel());
        XModelObject xModelObject2 = ps[3] = ps[1] instanceof ReferenceObjectImpl ? ((ReferenceObjectImpl)ps[1]).getReference() : this.findObjectByRef(ps[1]);
        if (ps[3] == null) {
            return null;
        }
        return ps;
    }

    private XModelObject getSource(XModel model) {
        XModelObject s = model.getModelBuffer().source();
        if (StrutsCopyHandler.referentBuffer == null) {
            return s;
        }
        XModelObject r = model.getByPath(StrutsCopyHandler.referentBuffer);
        if (!(r instanceof ReferenceObjectImpl)) {
            return s;
        }
        ReferenceObjectImpl ro = (ReferenceObjectImpl)r;
        return ro.getReference() == s ? ro : s;
    }
}

