/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.model.helpers.autolayout.AutoLayout;
import org.jboss.tools.jst.web.model.helpers.autolayout.AutoPlacement;
import org.jboss.tools.jst.web.model.helpers.autolayout.Items;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.model.ReferenceObjectImpl;
import org.jboss.tools.struts.model.StrutsProcessImpl;
import org.jboss.tools.struts.model.handlers.page.create.CreatePageSupport;
import org.jboss.tools.struts.model.helpers.StrutsBreakpointManager;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.model.helpers.TilesHelper;
import org.jboss.tools.struts.model.helpers.autolayout.StrutsItems;
import org.jboss.tools.struts.model.helpers.page.JSPLinksParser;
import org.jboss.tools.struts.model.helpers.page.PageUpdateManager;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsProcessHelper
implements StrutsConstants {
    private ArrayList<Task> tasks = new ArrayList();
    private int isRunning = 0;
    private XModelObject process;
    private XModelObject config;
    private Map<String, XModelObject> objects = new HashMap<String, XModelObject>();
    private Map<String, XModelObject> actions = new HashMap<String, XModelObject>();
    private Binds binds = new Binds();
    private Map<String, XModelObject> pages = new HashMap<String, XModelObject>();
    StrutsProcessStructureHelper h = new StrutsProcessStructureHelper();
    boolean is_10 = true;
    Set<String> tiles = new TreeSet<String>();
    String module = "";
    UrlPattern urlPattern = null;
    StrutsBreakpointManager breakpointManager = null;
    Map<String, XModelObject> osX = new HashMap<String, XModelObject>();
    Map<String, XModelObject> gsX = new HashMap<String, XModelObject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(Task task) {
        StrutsProcessHelper strutsProcessHelper = this;
        synchronized (strutsProcessHelper) {
            this.tasks.add(task);
        }
        this.runTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() {
        if (this.isRunning > 0) {
            return;
        }
        ++this.isRunning;
        while (true) {
            Task ts = null;
            StrutsProcessHelper strutsProcessHelper = this;
            synchronized (strutsProcessHelper) {
                if (this.tasks.size() == 0) {
                    break;
                }
                ts = this.tasks.remove(0);
            }
            try {
                ts.execute();
            }
            catch (Exception e) {
                StrutsModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        --this.isRunning;
    }

    public StrutsProcessHelper(XModelObject process) {
        this.process = process;
        this.breakpointManager = new StrutsBreakpointManager(process);
    }

    private void reset() {
        this.objects.clear();
        this.actions.clear();
        this.binds.clear();
        this.pages.clear();
        this.config = this.process.getParent();
    }

    public void build() {
        this.addTask(new BuildTask());
    }

    private void buildInternal() {
        this.reset();
        this.removeChildren(this.process);
        XModelObject globalForw = this.config.getChildByPath("global-forwards");
        XModelObject globalExc = this.config.getChildByPath("global-exceptions");
        XModelObject actionMap = this.config.getChildByPath("action-mappings");
        XModelObject[] children = globalForw.getChildren();
        int i = 0;
        while (i < children.length) {
            this.reloadForwardInternal(this.process, children[i], null);
            ++i;
        }
        if (globalExc != null) {
            children = globalExc.getChildren();
            i = 0;
            while (i < children.length) {
                this.reloadExceptionInternal(this.process, children[i], null);
                ++i;
            }
        }
        children = actionMap.getChildren();
        i = 0;
        while (i < children.length) {
            this.reloadActionInternal(this.process, children[i], null);
            ++i;
        }
        this.resolveInternal();
        this.updatePages();
        this.removeUnconfirmed();
    }

    public void updateProcess() {
        this.addTask(new UpdateProcessTask());
    }

    /*
     * WARNING - void declaration
     */
    private void updateProcessInternal() {
        void var9_10;
        StrutsBreakpointManager bpManager = this.getBreakpointManager();
        if (bpManager != null) {
            bpManager.update();
        }
        this.is_10 = this.process.getParent().getModelEntity().getName().endsWith("10");
        this.reset();
        XModelObject globalForw = this.config.getChildByPath("global-forwards");
        XModelObject globalExc = this.config.getChildByPath("global-exceptions");
        XModelObject actionMap = this.config.getChildByPath("action-mappings");
        Map<String, XModelObject> forwMap = this.getChildren(globalForw);
        Map<Object, Object> excMap = globalExc == null ? new HashMap() : this.getChildren(globalExc);
        Map<String, XModelObject> actMap = this.getChildren(actionMap);
        XModelObject[] children = this.process.getChildren();
        boolean bl = false;
        while (var9_10 < children.length) {
            ReferenceObjectImpl child;
            if (children[var9_10] instanceof ReferenceObjectImpl && (child = (ReferenceObjectImpl)children[var9_10]).isActive()) {
                XModelObject ref = child.getReference();
                if (ref != null && !ref.isActive()) {
                    ref = null;
                }
                String type = child.getAttributeValue("type");
                String id = child.getAttributeValue("id");
                if ("action".equals(type)) {
                    if (ref == null) {
                        ref = actMap.remove(id);
                    } else {
                        actMap.remove(ref.getPathPart());
                    }
                    this.reloadActionInternal(this.process, ref, (XModelObject)child);
                } else if ("forward".equals(type)) {
                    if (ref == null) {
                        ref = forwMap.remove(id);
                    } else {
                        forwMap.remove(ref.getPathPart());
                    }
                    this.reloadForwardInternal(this.process, ref, (XModelObject)child);
                } else if ("exception".equals(type)) {
                    if (ref == null) {
                        ref = (XModelObject)excMap.remove(id);
                    } else {
                        excMap.remove(ref.getPathPart());
                    }
                    this.reloadExceptionInternal(this.process, ref, (XModelObject)child);
                } else if ("page".equals(type)) {
                    this.pages.put(child.getAttributeValue("path"), (XModelObject)child);
                }
            }
            ++var9_10;
        }
        for (XModelObject xModelObject : forwMap.values()) {
            this.reloadForwardInternal(this.process, xModelObject, null);
        }
        for (XModelObject xModelObject : excMap.values()) {
            this.reloadExceptionInternal(this.process, xModelObject, null);
        }
        for (XModelObject xModelObject : actMap.values()) {
            this.reloadActionInternal(this.process, xModelObject, null);
        }
        this.cleanObjects();
        this.resolveInternal();
        this.updatePages();
        this.removeUnconfirmed();
    }

    public void reloadAction(XModelObject parent, XModelObject ref, XModelObject action) {
        this.addTask(new ReloadActionTask(parent, ref, action));
    }

    private void reloadActionInternal(XModelObject parent, XModelObject ref, XModelObject action) {
        if (action == null) {
            action = this.createAction(parent, ref);
            this.objects.put(this.getLocalPath(ref), action);
        } else {
            String path = this.getLocalPath2(action);
            XModelObject prev = this.objects.remove(path);
            if (prev != null && prev != action) {
                if (ref == null && prev.getParent() != null) {
                    action.removeFromParent();
                    this.objects.put(path, prev);
                    return;
                }
                prev.removeFromParent();
            }
            this.updateActionInternal(parent, ref, action);
            prev = this.objects.put(this.getLocalPath2(action), action);
            if (prev != null) {
                prev.removeFromParent();
            }
            List<XModelObject> list = StrutsProcessHelper.getReferers(parent, action.getPathPart());
            for (XModelObject o : list) {
                this.addBind(o);
            }
        }
    }

    public void removeAction(XModelObject action) {
        this.objects.remove(this.getLocalPath2(action));
        action.removeFromParent();
        this.updateProcess();
    }

    private void addBind(XModelObject o) {
        this.binds.add(o);
    }

    private XModelObject createAction(XModelObject parent, XModelObject ref) {
        Properties props = new Properties();
        props.setProperty("name", StrutsProcessHelper.createName(parent, "action"));
        props.setProperty("type", "action");
        String shape = ref.get("_shape");
        if (shape != null) {
            props.setProperty("shape", shape);
        }
        XModelObject action = ref.getModel().createModelObject("StrutsProcessItem", props);
        this.updateActionInternal(parent, ref, action);
        parent.addChild(action);
        return action;
    }

    public void updateAction(XModelObject parent, XModelObject ref, XModelObject action) {
        this.addTask(new UpdateActionTask(parent, ref, action));
    }

    private void updateActionInternal(XModelObject parent, XModelObject ref, XModelObject action) {
        this.actions.remove(action.getAttributeValue("path"));
        if (ref == null) {
            List<XModelObject> l;
            ((ReferenceObjectImpl)action).setReference(null);
            String subtype = action.getAttributeValue("subtype");
            if (!"unknown".equals(subtype) && (l = StrutsProcessHelper.getReferers(action.getParent(), action.getPathPart())).size() == 0) {
                action.removeFromParent();
                return;
            }
            action.setAttributeValue("subtype", "unknown");
            XModelObject[] children = action.getChildren();
            int i = 0;
            while (i < children.length) {
                ((ReferenceObjectImpl)children[i]).setReference(null);
                ++i;
            }
        } else {
            String path = ref.getAttributeValue("path");
            ((ReferenceObjectImpl)action).setReference(ref);
            action.setAttributeValue("id", path.replace('/', '#'));
            action.setAttributeValue("path", path);
            action.setAttributeValue("title", ref.getAttributeValue("name"));
            String frw = ref.getAttributeValue("forward").trim();
            String inc = ref.getAttributeValue("include").trim();
            String redirect = "";
            String jtype = ref.getAttributeValue("type");
            String subtype = "";
            if ("org.apache.struts.actions.SwitchAction".equals(jtype)) {
                subtype = "switch";
            } else if (frw.length() > 0) {
                redirect = frw;
                subtype = "forward";
            } else if (inc.length() > 0) {
                redirect = inc;
                subtype = "include";
            } else if ("org.apache.struts.actions.ForwardAction".equals(jtype)) {
                redirect = ref.getAttributeValue("parameter");
                subtype = "parameter";
            }
            if (!subtype.equals(action.getAttributeValue("subtype"))) {
                this.removeChildren(action);
            }
            if (!"switch".equals(subtype)) {
                if (subtype.length() > 0) {
                    XModelObject forward = action.getChildAt(0);
                    if (forward == null) {
                        Properties props2 = new Properties();
                        props2.setProperty("name", action.getAttributeValue("name"));
                        props2.setProperty("type", "forward");
                        forward = ref.getModel().createModelObject("StrutsProcessItemOutput", props2);
                        action.addChild(forward);
                    } else {
                        forward.setAttributeValue("name", action.getAttributeValue("name"));
                    }
                    forward.setAttributeValue("path", redirect);
                    forward.setAttributeValue("title", subtype);
                    ((ReferenceObjectImpl)forward).setReference(ref);
                    action.setAttributeValue("subtype", subtype);
                } else {
                    Map<String, XModelObject> refMap = this.getChildren(ref);
                    XModelObject[] localBinds = action.getChildren();
                    int j = 0;
                    while (j < localBinds.length) {
                        String type = localBinds[j].getAttributeValue("type");
                        XModelObject refBind = refMap.remove(localBinds[j].getAttributeValue("id"));
                        if (type.equals("forward")) {
                            this.reloadForwardInternal(action, refBind, localBinds[j]);
                        } else if (type.equals("exception")) {
                            this.reloadExceptionInternal(action, refBind, localBinds[j]);
                        }
                        ++j;
                    }
                    for (XModelObject refBind : refMap.values()) {
                        String entity = refBind.getModelEntity().getName();
                        if (entity.startsWith("StrutsForward")) {
                            this.reloadForwardInternal(action, refBind, null);
                            continue;
                        }
                        if (!entity.startsWith("StrutsException")) continue;
                        this.reloadExceptionInternal(action, refBind, null);
                    }
                }
            }
            action.setAttributeValue("subtype", subtype);
        }
        XModelObject[] children = action.getChildren();
        int i = 0;
        while (i < children.length) {
            this.addBind(children[i]);
            ++i;
        }
        this.actions.put(action.getAttributeValue("path"), action);
    }

    public XModelObject getAction(String path) {
        return this.actions.get(path);
    }

    public void registerAction(XModelObject action) {
        this.actions.put(action.getAttributeValue("path"), action);
    }

    public void reloadForward(XModelObject parent, XModelObject ref, XModelObject forward) {
        this.addTask(new ReloadForwardTask(parent, ref, forward));
    }

    private void reloadForwardInternal(XModelObject parent, XModelObject ref, XModelObject forward) {
        if (ref == null) {
            this.objects.remove(this.getLocalPath2(forward));
            forward.removeFromParent();
        } else if (forward == null) {
            forward = this.createForward(parent, ref, parent.getModelEntity().getChildren()[0].getName());
            this.objects.put(this.getLocalPath(ref), forward);
        } else {
            this.objects.remove(this.getLocalPath2(forward));
            this.updateForwardInternal(parent, ref, forward);
            this.objects.put(this.getLocalPath(ref), forward);
        }
    }

    private XModelObject createForward(XModelObject parent, XModelObject ref, String entity) {
        Properties props = new Properties();
        props.setProperty("name", StrutsProcessHelper.createName(parent, "forward"));
        props.setProperty("type", "forward");
        String shape = ref.get("_shape");
        if (shape != null) {
            props.setProperty("shape", shape);
        }
        XModelObject forward = ref.getModel().createModelObject(entity, props);
        this.updateForwardInternal(parent, ref, forward);
        parent.addChild(forward);
        return forward;
    }

    public void updateForward(XModelObject parent, XModelObject ref, XModelObject forward) {
        this.addTask(new UpdateForwardTask(parent, ref, forward));
    }

    private void updateForwardInternal(XModelObject parent, XModelObject ref, XModelObject forward) {
        String name = ref.getAttributeValue("name");
        forward.setAttributeValue("id", name);
        forward.setAttributeValue("path", ref.getAttributeValue("path"));
        forward.setAttributeValue("title", name);
        ((ReferenceObjectImpl)forward).setReference(ref);
        this.addBind(forward);
    }

    public void reloadException(XModelObject parent, XModelObject ref, XModelObject exception) {
        this.addTask(new ReloadExceptionTask(parent, ref, exception));
    }

    private void reloadExceptionInternal(XModelObject parent, XModelObject ref, XModelObject exception) {
        if (ref == null) {
            this.objects.remove(this.getLocalPath2(exception));
            exception.removeFromParent();
        } else if (exception == null) {
            exception = this.createException(parent, ref, parent.getModelEntity().getChildren()[0].getName());
            this.objects.put(this.getLocalPath(ref), exception);
        } else {
            this.objects.remove(this.getLocalPath2(exception));
            this.updateException(parent, ref, exception);
            this.objects.put(this.getLocalPath(ref), exception);
        }
    }

    private XModelObject createException(XModelObject parent, XModelObject ref, String entity) {
        Properties props = new Properties();
        props.setProperty("name", StrutsProcessHelper.createName(parent, "exception"));
        props.setProperty("type", "exception");
        String shape = ref.get("_shape");
        if (shape != null) {
            props.setProperty("shape", shape);
        }
        XModelObject exception = ref.getModel().createModelObject(entity, props);
        this.updateExceptionInternal(parent, ref, exception);
        parent.addChild(exception);
        return exception;
    }

    public void updateException(XModelObject parent, XModelObject ref, XModelObject exception) {
        this.addTask(new UpdateExceptionTask(parent, ref, exception));
    }

    private void updateExceptionInternal(XModelObject parent, XModelObject ref, XModelObject exception) {
        String name = ref.getAttributeValue("type");
        exception.setAttributeValue("id", name);
        exception.setAttributeValue("path", ref.getAttributeValue("path"));
        exception.setAttributeValue("title", name.substring(name.lastIndexOf(46) + 1));
        ((ReferenceObjectImpl)exception).setReference(ref);
        this.addBind(exception);
    }

    public void resolve() {
        this.addTask(new ResolveTask());
    }

    private void resolveInternal() {
        if (this.binds.size() == 0 && this.urlPattern != null) {
            return;
        }
        WebModulesHelper wmh = WebModulesHelper.getInstance(this.process.getModel());
        HashSet<String> modules = this.is_10 ? new HashSet() : wmh.getModules();
        String string = this.module = this.is_10 ? "" : WebModulesHelper.getInstance(this.process.getModel()).getModuleForConfig(this.process.getParent());
        if (this.module == null) {
            this.module = "";
        }
        this.urlPattern = wmh.getUrlPattern(this.module);
        Iterator<XModelObject> it = this.binds.list.iterator();
        while (it.hasNext()) {
            XModelObject page;
            XModelObject bind = it.next();
            if (!bind.isActive()) {
                it.remove();
                this.binds.set.remove(bind);
                continue;
            }
            String path = bind.getAttributeValue("path");
            if (path == null) continue;
            int ind = path.indexOf(63);
            if (ind > 0) {
                path = path.substring(0, ind);
            }
            if (path.length() == 0) {
                bind.setAttributeValue("target", "");
                continue;
            }
            if (path.startsWith("/") && this.urlPattern.isActionUrl(path)) {
                XModelObject action;
                String actionpath = path = this.urlPattern.getActionPath(path);
                boolean other = false;
                if (!this.is_10 && this.module.length() > 0) {
                    String othermodule;
                    String mrp = this.urlPattern.getModuleRelativePath(actionpath, this.module);
                    if (!actionpath.equals(mrp)) {
                        actionpath = mrp;
                    } else if (StrutsProcessHelper.isContextRelative(bind) && (othermodule = this.urlPattern.getModule(actionpath, modules, "")).length() == 0) {
                        actionpath = "/" + actionpath;
                        other = true;
                    }
                }
                if ((action = this.actions.get(actionpath)) == null) {
                    Properties props = new Properties();
                    props.setProperty("name", StrutsProcessHelper.createName(this.process, "action"));
                    props.setProperty("type", "action");
                    props.setProperty("subtype", "unknown");
                    if (!other) {
                        props.setProperty("id", path.replace('/', '#'));
                    }
                    props.setProperty("path", actionpath);
                    action = bind.getModel().createModelObject("StrutsProcessItem", props);
                    String shape = bind.getAttributeValue("shape");
                    if (shape != null && shape.length() > 0 && "StrutsProcessItemOutput".equals(bind.getModelEntity().getName())) {
                        action.setAttributeValue("shape", shape);
                        bind.setAttributeValue("shape", "");
                    } else {
                        new AutoPlacement().place(this.process, bind, action);
                    }
                    this.process.addChild(action);
                    this.updateAction(this.process, null, action);
                    this.objects.put("action-mappings/" + action.getAttributeValue("id"), action);
                }
                bind.setAttributeValue("target", action.getAttributeValue("name"));
                continue;
            }
            String pagepath = path;
            if (!(this.is_10 || this.module.length() <= 0 || this.isTile(path) || StrutsProcessHelper.isHttp(path))) {
                if (!pagepath.startsWith("/")) {
                    pagepath = "/" + pagepath;
                }
                if (pagepath.startsWith(String.valueOf(this.module) + "/")) {
                    pagepath = pagepath.substring(this.module.length());
                }
            }
            if ((page = this.getPage(pagepath)) == null) {
                page = StrutsProcessHelper.createPage(this.process, pagepath);
                this.process.addChild(page);
                new AutoPlacement().place(this.process, bind, page);
            }
            bind.setAttributeValue("target", page.getAttributeValue("name"));
        }
        this.binds.clear();
    }

    public void removeUnconfirmed() {
        Set<String> set = StrutsProcessHelper.getReferredTargets(this.process);
        XModelObject[] os = this.process.getChildren();
        int i = 0;
        while (i < os.length) {
            if (!set.contains(os[i].getPathPart())) {
                String type = os[i].getAttributeValue("type");
                String subtype = os[i].getAttributeValue("subtype");
                String objpath = os[i].getAttributeValue("path");
                if ("action".equals(type) && "unknown".equals(subtype)) {
                    this.actions.remove(objpath);
                    os[i].removeFromParent();
                } else if ("page".equals(type) && !this.h.isPageConfirmed(os[i])) {
                    PageUpdateManager pu = PageUpdateManager.getInstance(this.process.getModel());
                    pu.lock();
                    pu.updatePage(this, os[i]);
                    pu.unlock();
                    if (!this.h.isPageConfirmed(os[i])) {
                        this.pages.remove(objpath);
                        os[i].removeFromParent();
                    }
                }
            }
            ++i;
        }
    }

    private boolean isTile(String path) {
        if (path.startsWith("/")) {
            return false;
        }
        if (this.tiles.contains(path)) {
            return true;
        }
        int dot = path.indexOf(46);
        if (dot < 0) {
            return true;
        }
        String ext = path.substring(dot + 1);
        return !ext.equals("jsp") && !ext.equals("html") && !ext.equals("htm") && !ext.equals(CreatePageSupport.getExtension().substring(1));
    }

    public static boolean isHttp(String path) {
        return path.startsWith("http:");
    }

    private static boolean isContextRelative(XModelObject item) {
        if (!(item instanceof ReferenceObjectImpl)) {
            return false;
        }
        XModelObject r = ((ReferenceObjectImpl)item).getReference();
        if (r == null) {
            return false;
        }
        if ("true".equals(r.getAttributeValue("contextRelative"))) {
            return true;
        }
        String module = r.getAttributeValue("module");
        return module != null && module.startsWith("/");
    }

    public static StrutsProcessHelper getHelper(XModelObject process) {
        return ((StrutsProcessImpl)process).getHelper();
    }

    public static XModelObject createPage(XModelObject process, String path) {
        String name = path.substring(path.lastIndexOf(47) + 1);
        int dot = name.lastIndexOf(46);
        String ext = dot == -1 ? "" : name.substring(dot).toLowerCase();
        Properties props = new Properties();
        String subtype = StrutsProcessHelper.isHttp(path) ? "html" : (".jsp".equals(ext) || CreatePageSupport.getExtension().equals(ext) ? "jsp" : (ext.length() < 7 && ext.indexOf("htm") != -1 ? "html" : (!path.startsWith("/") ? "tile" : "other")));
        props.setProperty("name", StrutsProcessHelper.createName(process, "page"));
        props.setProperty("type", "page");
        props.setProperty("subtype", subtype);
        props.setProperty("path", path);
        props.setProperty("title", name);
        XModelObject page = process.getModel().createModelObject("StrutsProcessItem", props);
        StrutsProcessHelper.getHelper((XModelObject)process).pages.put(path, page);
        return page;
    }

    public void restoreRefs() {
        this.breakpointManager.activate();
        this.config = this.process.getParent();
        XModelObject globalForw = this.config.getChildByPath("global-forwards");
        XModelObject globalExc = this.config.getChildByPath("global-exceptions");
        XModelObject actionMap = this.config.getChildByPath("action-mappings");
        ((ReferenceObjectImpl)this.process).setReference(this.config);
        XModelObject[] children = this.process.getChildren();
        int i = 0;
        while (i < children.length) {
            String type = children[i].getAttributeValue("type");
            if ("exception".equals(type)) {
                this.restoreExcRef(globalExc, children[i]);
            } else if ("forward".equals(type)) {
                this.restoreForwRef(globalForw, children[i]);
            } else if ("action".equals(type)) {
                this.restoreActRef(actionMap, children[i]);
            }
            ++i;
        }
    }

    public void restoreActRef(XModelObject parentRef, XModelObject action) {
        block6: {
            XModelObject[] children;
            XModelObject ref;
            block7: {
                if (parentRef == null) {
                    return;
                }
                ref = parentRef.getChildByPath(action.getAttributeValue("id"));
                if (ref == null) break block6;
                ((ReferenceObjectImpl)action).setReference(ref);
                children = action.getChildren();
                if (action.getAttributeValue("subtype").length() != 0) break block7;
                int i = 0;
                while (i < children.length) {
                    String type = children[i].getAttributeValue("type");
                    if ("exception".equals(type)) {
                        this.restoreExcRef(ref, children[i]);
                    } else if ("forward".equals(type)) {
                        this.restoreForwRef(ref, children[i]);
                    }
                    ++i;
                }
                break block6;
            }
            if ("unknown".equals(action.getAttributeValue("subtype"))) break block6;
            int i = 0;
            while (i < children.length) {
                ((ReferenceObjectImpl)children[i]).setReference(ref);
                ++i;
            }
        }
    }

    public void restoreForwRef(XModelObject parentRef, XModelObject forward) {
        if (parentRef == null) {
            return;
        }
        XModelObject ref = parentRef.getChildByPath(forward.getAttributeValue("id"));
        if (ref != null) {
            ((ReferenceObjectImpl)forward).setReference(ref);
        }
    }

    public void restoreExcRef(XModelObject parentRef, XModelObject exception) {
        if (parentRef == null) {
            return;
        }
        XModelObject ref = parentRef.getChildByPath(exception.getAttributeValue("id"));
        if (ref != null) {
            ((ReferenceObjectImpl)exception).setReference(ref);
        }
    }

    private void cleanObjects() {
        if (!this.process.isActive()) {
            return;
        }
        Iterator<XModelObject> it = this.objects.values().iterator();
        while (it.hasNext()) {
            XModelObject o = it.next();
            if (o.isActive()) continue;
            it.remove();
        }
    }

    private Map<String, XModelObject> getChildren(XModelObject object) {
        HashMap<String, XModelObject> map = new HashMap<String, XModelObject>();
        XModelObject[] children = object.getChildren();
        int i = 0;
        while (i < children.length) {
            map.put(children[i].getPathPart(), children[i]);
            ++i;
        }
        return map;
    }

    private void removeChildren(XModelObject object) {
        XModelObject[] children = object.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].removeFromParent();
            ++i;
        }
    }

    public static String createName(XModelObject parent, String prefix) {
        int ind = 0;
        while (parent.getChildByPath(String.valueOf(prefix) + ind) != null) {
            ++ind;
        }
        return String.valueOf(prefix) + ind;
    }

    public XModelObject getObject(String path) {
        return this.objects.get(path);
    }

    public XModelObject getPage(String path) {
        XModelObject page = this.pages.get(path);
        if (page != null && page.getParent() == null) {
            this.pages.remove(path);
            return null;
        }
        return page;
    }

    public void resetPage(XModelObject page, String oldpath, String newpath) {
        this.pages.remove(oldpath);
        this.pages.put(newpath, page);
    }

    public String getLocalPath2(XModelObject object) {
        String type;
        if (object == null) {
            return null;
        }
        String path = object.getAttributeValue("id");
        XModelObject parent = object.getParent();
        if (parent != null && parent != this.process) {
            object = parent;
            path = String.valueOf(object.getAttributeValue("id")) + '/' + path;
        }
        if ("action".equals(type = object.getAttributeValue("type"))) {
            path = "action-mappings/" + path;
        } else if ("forward".equals(type)) {
            path = "global-forwards/" + path;
        } else if ("exception".equals(type)) {
            path = "global-exceptions/" + path;
        }
        return path;
    }

    public String getLocalPath(XModelObject object) {
        if (object == null) {
            return null;
        }
        String path = object.getPathPart();
        object = object.getParent();
        while (object != this.config) {
            if (object == null) {
                return null;
            }
            path = String.valueOf(object.getPathPart()) + "/" + path;
            object = object.getParent();
        }
        return path;
    }

    public static List<XModelObject> getReferers(XModelObject root, String target) {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        if (root != null) {
            StrutsProcessHelper.fillReferers(list, root, target);
        }
        return list;
    }

    private static void fillReferers(List<XModelObject> list, XModelObject obj, String target) {
        XModelObject[] children = obj.getChildren();
        int i = 0;
        while (i < children.length) {
            if (target.equals(children[i].getAttributeValue("target"))) {
                list.add(children[i]);
            }
            StrutsProcessHelper.fillReferers(list, children[i], target);
            ++i;
        }
    }

    private static Set<String> getReferredTargets(XModelObject object) {
        HashSet<String> set = new HashSet<String>();
        StrutsProcessHelper.fillReferers(set, object);
        return set;
    }

    private static void fillReferers(Set<String> set, XModelObject obj) {
        XModelObject[] children = obj.getChildren();
        int i = 0;
        while (i < children.length) {
            String target = children[i].getAttributeValue("target");
            if (target != null && target.length() > 0) {
                set.add(target);
            }
            StrutsProcessHelper.fillReferers(set, children[i]);
            ++i;
        }
    }

    public void updateTiles() {
        Set<String> ts = TilesHelper.getTiles(this.process).keySet();
        if (!ts.equals(this.tiles)) {
            this.updatePages();
        }
    }

    public Set<String> getTiles() {
        return this.tiles;
    }

    public void updatePages() {
        this.tiles = TilesHelper.getTiles(this.process).keySet();
        PageUpdateManager pu = PageUpdateManager.getInstance(this.process.getModel());
        pu.lock();
        this.prepareMaps();
        XModelObject[] items = this.process.getChildren();
        int i = 0;
        while (i < items.length) {
            pu.updatePage(this, items[i]);
            ++i;
        }
        pu.unlock();
    }

    private void prepareMaps() {
        HashMap<String, XModelObject> os = new HashMap<String, XModelObject>();
        HashMap<String, XModelObject> gs = new HashMap<String, XModelObject>();
        XModelObject[] cs = this.process.getChildren();
        int i = 0;
        while (i < cs.length) {
            block5: {
                String type;
                String path;
                block6: {
                    path = cs[i].getAttributeValue("path");
                    type = cs[i].getAttributeValue("type");
                    if ("exception".equals(type)) break block5;
                    if (!"forward".equals(type)) break block6;
                    XModelObject r = ((ReferenceObjectImpl)cs[i]).getReference();
                    if (r == null) break block5;
                    gs.put(r.getPathPart(), cs[i]);
                }
                if ("action".equals(type)) {
                    path = this.urlPattern.getActionUrl(path);
                }
                os.put(path, cs[i]);
            }
            ++i;
        }
        this.osX = os;
        this.gsX = gs;
    }

    public void updatePage(XModelObject page, JSPLinksParser p) {
        this.addTask(new UpdatePageTask(page, p));
    }

    private void updatePageInternal(XModelObject page, JSPLinksParser p) {
        if (this.urlPattern == null) {
            return;
        }
        Map<String, XModelObject> os = this.osX;
        Map<String, XModelObject> gs = this.gsX;
        Set<String> ls = p.getAllLinks();
        XModelObject[] links = page.getChildren();
        int i = 0;
        while (i < links.length) {
            String path = links[i].getAttributeValue("path");
            String trg = links[i].getAttributeValue("target");
            XModelObject trgobj = this.process.getChildByPath(trg);
            if (ls.contains(path)) {
                links[i].setAttributeValue("subtype", "confirmed");
                if (trg.length() > 0 && trgobj != null) {
                    ls.remove(path);
                } else {
                    links[i].removeFromParent();
                }
            } else if ("confirmed".equals(links[i].getAttributeValue("subtype"))) {
                links[i].removeFromParent();
                if (trgobj != null) {
                    String type = trgobj.getAttributeValue("type");
                    String subtype = trgobj.getAttributeValue("subtype");
                    String objpath = trgobj.getAttributeValue("path");
                    if ("action".equals(type) && "unknown".equals(subtype)) {
                        List<XModelObject> l = StrutsProcessHelper.getReferers(this.process, trgobj.getPathPart());
                        if (l.isEmpty()) {
                            this.actions.remove(objpath);
                            trgobj.removeFromParent();
                        }
                    } else if ("page".equals(type) && !this.h.isPageConfirmed(trgobj)) {
                        this.pages.remove(objpath);
                        trgobj.removeFromParent();
                    }
                }
            } else if (trg.length() == 0 || this.process.getChildByPath(trg) == null) {
                this.addBind(links[i]);
            }
            ++i;
        }
        for (String path : ls) {
            boolean isForward = p.isForward(path);
            XModelObject target = isForward ? gs.get(path) : os.get(path);
            XModelObject link = StrutsProcessHelper.addLink(page, target, path);
            if (target != null) continue;
            this.addBind(link);
        }
        if (this.binds.size() > 0) {
            this.resolveInternal();
            this.removeUnconfirmed();
        }
    }

    private static XModelObject addLink(XModelObject page, XModelObject target, String path) {
        Properties q = new Properties();
        q.setProperty("name", StrutsProcessHelper.createName(page, "link"));
        q.setProperty("type", "link");
        q.setProperty("subtype", "confirmed");
        q.setProperty("title", path);
        q.setProperty("path", path);
        if (target != null) {
            q.setProperty("target", target.getAttributeValue("name"));
            if ("forward".equals(target.getAttributeValue("type"))) {
                q.setProperty("shortcut", "yes");
            }
        }
        XModelObject link = page.getModel().createModelObject("StrutsProcessItemOutput", q);
        page.addChild(link);
        return link;
    }

    public void updateTile(XModelObject page) {
        String path = page.getAttributeValue("path");
        if (path.startsWith("/")) {
            return;
        }
        page.setAttributeValue("subtype", "tile");
        page.setAttributeValue("confirmed", "" + this.tiles.contains(path));
    }

    public void autolayout() {
        AutoLayout auto = new AutoLayout();
        auto.setItems((Items)new StrutsItems());
        auto.setProcess(this.process);
    }

    public StrutsBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    private class Binds {
        List<XModelObject> list = new ArrayList<XModelObject>();
        Set<XModelObject> set = new HashSet<XModelObject>();

        private Binds() {
        }

        public void add(XModelObject o) {
            if (this.set.contains(o)) {
                return;
            }
            this.set.add(o);
            this.list.add(o);
            if (this.set.size() != this.list.size()) {
                System.out.println("Panikk: " + this.set.size() + " " + this.list.size());
            }
        }

        public int size() {
            return this.list.size();
        }

        public void clear() {
            this.list.clear();
            this.set.clear();
        }
    }

    class BuildTask
    extends Task {
        BuildTask() {
        }

        public void execute() {
            StrutsProcessHelper.this.buildInternal();
        }
    }

    class ReloadActionTask
    extends Task {
        XModelObject parent;
        XModelObject ref;
        XModelObject action;

        ReloadActionTask(XModelObject parent, XModelObject ref, XModelObject action) {
            this.parent = parent;
            this.ref = ref;
            this.action = action;
        }

        public void execute() {
            StrutsProcessHelper.this.reloadActionInternal(this.parent, this.ref, this.action);
        }
    }

    class ReloadExceptionTask
    extends Task {
        XModelObject parent;
        XModelObject ref;
        XModelObject exception;

        ReloadExceptionTask(XModelObject parent, XModelObject ref, XModelObject exception) {
            this.parent = parent;
            this.ref = ref;
            this.exception = exception;
        }

        public void execute() {
            StrutsProcessHelper.this.reloadExceptionInternal(this.parent, this.ref, this.exception);
        }
    }

    class ReloadForwardTask
    extends Task {
        XModelObject parent;
        XModelObject ref;
        XModelObject forward;

        ReloadForwardTask(XModelObject parent, XModelObject ref, XModelObject forward) {
            this.parent = parent;
            this.ref = ref;
            this.forward = forward;
        }

        public void execute() {
            StrutsProcessHelper.this.reloadForwardInternal(this.parent, this.ref, this.forward);
        }
    }

    class ResolveTask
    extends Task {
        ResolveTask() {
        }

        public void execute() {
            StrutsProcessHelper.this.resolveInternal();
        }
    }

    class Task {
        Task() {
        }

        public void execute() {
        }
    }

    class UpdateActionTask
    extends Task {
        XModelObject parent;
        XModelObject ref;
        XModelObject action;

        UpdateActionTask(XModelObject parent, XModelObject ref, XModelObject action) {
            this.parent = parent;
            this.ref = ref;
            this.action = action;
        }

        public void execute() {
            StrutsProcessHelper.this.updateActionInternal(this.parent, this.ref, this.action);
        }
    }

    class UpdateExceptionTask
    extends Task {
        XModelObject parent;
        XModelObject ref;
        XModelObject exception;

        UpdateExceptionTask(XModelObject parent, XModelObject ref, XModelObject exception) {
            this.parent = parent;
            this.ref = ref;
            this.exception = exception;
        }

        public void execute() {
            StrutsProcessHelper.this.updateExceptionInternal(this.parent, this.ref, this.exception);
        }
    }

    class UpdateForwardTask
    extends Task {
        XModelObject parent;
        XModelObject ref;
        XModelObject forward;

        UpdateForwardTask(XModelObject parent, XModelObject ref, XModelObject forward) {
            this.parent = parent;
            this.ref = ref;
            this.forward = forward;
        }

        public void execute() {
            StrutsProcessHelper.this.updateForwardInternal(this.parent, this.ref, this.forward);
        }
    }

    class UpdatePageTask
    extends Task {
        XModelObject page;
        JSPLinksParser p;

        UpdatePageTask(XModelObject page, JSPLinksParser p) {
            this.page = page;
            this.p = p;
        }

        public void execute() {
            StrutsProcessHelper.this.updatePageInternal(this.page, this.p);
        }
    }

    class UpdateProcessTask
    extends Task {
        UpdateProcessTask() {
        }

        public void execute() {
            StrutsProcessHelper.this.updateProcessInternal();
        }
    }
}

