/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.markers.XMarkerManager;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.jst.web.model.helpers.WebProcessStructureHelper;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.model.ReferenceObjectImpl;
import org.jboss.tools.struts.model.helpers.StrutsBreakpointManager;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsProcessStructureHelper
extends WebProcessStructureHelper
implements StrutsConstants {
    public static final StrutsProcessStructureHelper instance = new StrutsProcessStructureHelper();
    static String GUI_PACKAGE = "org.jboss.tools.struts.ui.diagramview.";

    public XModelObject[] getProcessItems(XModelObject process) {
        if (!this.isProcessLoaded(process)) {
            return new XModelObject[0];
        }
        return process.getChildren();
    }

    public boolean isStruts10(XModelObject object) {
        XModelObject config = this.getParentFile(object);
        return config != null && config.getModelEntity().getName().equals("StrutsConfig10");
    }

    public XModelObject[] getItemOutput(XModelObject item) {
        return item.getChildren();
    }

    public String getItemGUIClass(XModelObject item) {
        String type = item.getAttributeValue("type");
        return type == null ? null : (type.equals("forward") ? String.valueOf(GUI_PACKAGE) + "GlobalForwardView" : (type.equals("exception") ? String.valueOf(GUI_PACKAGE) + "GlobalExceptionView" : (type.equals("action") ? String.valueOf(GUI_PACKAGE) + "ActionView" : (type.equals("page") ? String.valueOf(GUI_PACKAGE) + "PageView" : (type.equals("comment") ? String.valueOf(GUI_PACKAGE) + "CommentView" : null)))));
    }

    public XActionList getLinkActionList(XModelObject itemOutput) {
        String type = itemOutput.getAttributeValue("type");
        XModelMetaData meta = itemOutput.getModel().getMetaData();
        if ("link".equals(type)) {
            return meta.getEntity("StrutsProcessPageTransition").getActionList();
        }
        if ("exception".equals(type)) {
            return meta.getEntity("StrutsProcessExceptionTransition").getActionList();
        }
        return meta.getEntity("StrutsProcessTransition").getActionList();
    }

    public XModelObject getReference(XModelObject object) {
        if (!(object instanceof ReferenceObjectImpl)) {
            return null;
        }
        return ((ReferenceObjectImpl)object).getReference();
    }

    public XModelObject getReferencedObject(XModelObject object) {
        if (object == null) {
            return null;
        }
        String type = object.getAttributeValue("type");
        if ("page".equals(type)) {
            return this.findReferencedJSPInCurrentModule(object);
        }
        if (object instanceof ReferenceObjectImpl) {
            return ((ReferenceObjectImpl)object).getReference();
        }
        return null;
    }

    public XModelObject getElementTarget(XModelObject element) {
        return this.getParentProcess(element).getChildByPath(element.getAttributeValue("target"));
    }

    public XModelObject getItemOutputTarget(XModelObject itemOutput) {
        return itemOutput.getParent().getParent().getChildByPath(itemOutput.getAttributeValue("target"));
    }

    public XModelObject getItemTarget(XModelObject itemOutput) {
        return itemOutput.getParent().getChildByPath(itemOutput.getAttributeValue("target"));
    }

    public boolean isItemFromOtherModule(XModelObject item) {
        String type = item.getAttributeValue("type");
        if (!"action".equals(type) && !"page".equals(type)) {
            return false;
        }
        String path = item.getAttributeValue("path");
        if (path == null || !path.startsWith("/")) {
            return false;
        }
        if (path.startsWith("//")) {
            return true;
        }
        int i = path.indexOf("/", 1);
        if (i >= 0) {
            String m = path.substring(0, i);
            if (WebModulesHelper.getInstance(item.getModel()).getModules().contains(m)) {
                return true;
            }
        }
        return this.isActionFromOtherConfigOfTheSameModule(item);
    }

    public boolean isActionFromOtherConfigOfTheSameModule(XModelObject item) {
        XModelObject cfg;
        String type = item.getAttributeValue("type");
        if (!"action".equals(type) || !"unknown".equals(item.getAttributeValue("subtype"))) {
            return false;
        }
        String path = item.getAttributeValue("path");
        if (path == null || !path.startsWith("/")) {
            return false;
        }
        if (path.startsWith("//")) {
            return false;
        }
        int i = path.indexOf("/", 1);
        if (i >= 0) {
            String m = path.substring(0, i);
            if (WebModulesHelper.getInstance(item.getModel()).getModules().contains(m)) {
                return false;
            }
        }
        if ((cfg = this.getParentFile(item)) == null) {
            return false;
        }
        WebModulesHelper modules = WebModulesHelper.getInstance(item.getModel());
        String module = modules.getModuleForConfig(cfg);
        XModelObject[] cgs = modules.getConfigsForModule(cfg.getModel(), module);
        if (cgs.length < 2) {
            return false;
        }
        int k = 0;
        while (k < cgs.length) {
            XModelObject ti = this.findItem(cgs[k], path, type);
            if (ti != null && !"unknown".equals(ti.getAttributeValue("subtype"))) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public XModelObject findItemInOtherModule(XModelObject item) {
        String type;
        XModelObject cfg = this.getParentFile(item);
        if (cfg == null) {
            return null;
        }
        WebModulesHelper modules = WebModulesHelper.getInstance(item.getModel());
        String current = modules.getModuleForConfig(cfg);
        String path = item.getAttributeValue("path");
        String module = modules.getModuleForPath(path, current);
        if (module == null) {
            return null;
        }
        if ((cfg = modules.getConfigForModule(cfg.getModel(), module)) == null) {
            return null;
        }
        XModelObject targetItem = this.findItem(cfg, path = path.startsWith("//") ? path.substring(1) : this.getUrlPattern(cfg).getModuleRelativePath(path, module), type = item.getAttributeValue("type"));
        if (targetItem != null && !"unknown".equals(targetItem.getAttributeValue("subtype"))) {
            return targetItem;
        }
        XModelObject[] cgs = modules.getConfigsForModule(cfg.getModel(), module);
        int i = 0;
        while (i < cgs.length) {
            XModelObject ti = this.findItem(cgs[i], path, type);
            if (ti != null) {
                if (!"unknown".equals(ti.getAttributeValue("subtype"))) {
                    return ti;
                }
                targetItem = ti;
            }
            ++i;
        }
        return targetItem;
    }

    private XModelObject findItem(XModelObject config, String path, String type) {
        XModelObject process;
        XModelObject xModelObject = process = config == null ? null : config.getChildByPath("process");
        if (process == null) {
            return null;
        }
        XModelObject[] items = process.getChildren();
        int i = 0;
        while (i < items.length) {
            if (path.equals(items[i].getAttributeValue("path")) && type.equals(items[i].getAttributeValue("type"))) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public XModelObject getParentProcess(XModelObject element) {
        XModelObject p = element;
        while (p != null && p.getFileType() == 0 && !"StrutsProcess".equals(p.getModelEntity().getName())) {
            p = p.getParent();
        }
        return p;
    }

    public String getProcessModule(XModelObject object) {
        XModelObject file = this.getParentFile(object);
        String module = file == null ? null : WebModulesHelper.getInstance(object.getModel()).getModuleForConfig(file);
        return module == null ? "" : module;
    }

    public UrlPattern getUrlPattern(XModelObject object) {
        return WebModulesHelper.getInstance(object.getModel()).getUrlPattern(this.getProcessModule(object));
    }

    public Set<String> getTiles(XModelObject object) {
        XModelObject process = this.getProcess(object);
        if (process == null) {
            return new TreeSet<String>();
        }
        StrutsProcessHelper h = StrutsProcessHelper.getHelper(process);
        h.updateTiles();
        return h.getTiles();
    }

    public String getModuleRelativePath(XModelObject forward) {
        return this.getModuleRelativePath(forward, this.getProcess(forward));
    }

    public String getModuleRelativePath(XModelObject forward, XModelObject process) {
        String path = forward.getAttributeValue("path");
        if (path != null && path.startsWith("//")) {
            return path.substring(1);
        }
        if (process == null) {
            return path;
        }
        String contextRelative = forward.getAttributeValue("contextRelative");
        if (contextRelative == null || "false".equals(contextRelative) || "no".equals(contextRelative)) {
            return path;
        }
        String module = this.getProcessModule(process);
        if (module == null || module.length() == 0) {
            return path;
        }
        return this.getUrlPattern(process).getModuleRelativePath(path, module);
    }

    public String getContextRelativePath(XModelObject page) {
        String path = page.getAttributeValue("path");
        if (path != null && path.startsWith("//")) {
            return path.substring(1);
        }
        XModelObject process = this.getParentProcess(page);
        if (process == null) {
            return path;
        }
        String module = this.getProcessModule(process);
        if (module == null || module.length() == 0) {
            return path;
        }
        return this.getUrlPattern(process).getContextRelativePath(path, module);
    }

    public String getValidForwardPath(XModelObject forward, String path) {
        XModelObject process = this.getProcess(forward);
        if (process == null) {
            return path;
        }
        String contextRelative = forward.getAttributeValue("contextRelative");
        if (contextRelative == null) {
            return path;
        }
        String module = this.getProcessModule(process);
        boolean cR = "true".equals(contextRelative) || "yes".equals(contextRelative);
        String attmodule = forward.getAttributeValue("module");
        if (attmodule != null && attmodule.length() > 0) {
            module = attmodule;
            cR = true;
        }
        UrlPattern up = this.getUrlPattern(process);
        return cR ? up.getContextRelativePath(path, module) : up.getModuleRelativePath(path, module);
    }

    public String getRunTimeForwardPath(XModelObject forward, String path) {
        XModelObject process = this.getProcess(forward);
        if (process == null) {
            return path;
        }
        String contextRelative = forward.getAttributeValue("contextRelative");
        if (contextRelative == null) {
            return path;
        }
        String module = this.getProcessModule(process);
        boolean cR = "true".equals(contextRelative) || "yes".equals(contextRelative);
        String attmodule = forward.getAttributeValue("module");
        if (attmodule != null && attmodule.length() > 0) {
            module = attmodule;
            cR = true;
        }
        return !cR ? this.getUrlPattern(forward).getContextRelativePath(path, module) : path;
    }

    public String getModulePagePath(XModelObject page) {
        return this.getPagePath0(page);
    }

    public XModelObject getPhysicalPage(XModelObject page) {
        XModelObject o;
        String path = this.getModulePagePath(page);
        if (path != null) {
            return page.getModel().getByPath(path);
        }
        path = page.getAttributeValue("path");
        if (path.length() < 2) {
            return null;
        }
        int i = path.indexOf(47, 1);
        if (i >= 0 && (o = page.getModel().getByPath(path.substring(i + 1))) != null) {
            return o;
        }
        return page.getModel().getByPath(path);
    }

    public XModelObject getPhysicalPage(XModelObject process, String path) {
        XModel model = process.getModel();
        String thismodule = this.getProcessModule(process);
        String module = WebModulesHelper.getInstance(model).getModuleForPath(path, thismodule);
        if (module == null) {
            module = "";
        }
        XModelObject fs = WebModulesHelper.getInstance(model).getFileSystem(module);
        String rpath = this.getUrlPattern(process).getModuleRelativePath(path, module);
        if (rpath.startsWith("/")) {
            rpath = rpath.substring(1);
        }
        if (fs != null) {
            return fs.getChildByPath(rpath);
        }
        return process.getModel().getByPath(path);
    }

    String getPagePath0(XModelObject page) {
        if (!page.isActive()) {
            return null;
        }
        String path = page.getAttributeValue("path");
        if (StrutsProcessHelper.isHttp(path)) {
            return path;
        }
        XModelObject process = page.getParent();
        String module = this.getProcessModule(process);
        boolean is10 = process.getParent().getModelEntity().getName().endsWith("10");
        if (is10 || module == null || module.length() == 0) {
            return path;
        }
        return this.getUrlPattern(page).getModuleRelativePath(path, module);
    }

    boolean is10(XModelObject process) {
        return process.getParent().getModelEntity().getName().endsWith("10");
    }

    public XModelObject findReferencedJSPInCurrentModule(XModelObject page) {
        String path = page.getAttributeValue("path");
        if (path == null || !path.startsWith("/")) {
            return null;
        }
        XModelObject o = page.getModel().getByPath(path);
        if (o == null || this.is10(page.getParent())) {
            return o;
        }
        Map<String, XModelObject> modules = WebModulesHelper.getInstance(page.getModel()).getWebFileSystems();
        if (modules.size() < 2) {
            return o;
        }
        if (path.startsWith("//")) {
            return null;
        }
        String xmodule = this.getUrlPattern(page).getModule(path, modules.keySet(), null);
        if (xmodule != null && xmodule.length() > 0) {
            return null;
        }
        String module = this.getProcessModule(page);
        XModelObject fs = module == null ? null : modules.get(module);
        return fs == null ? null : fs.getChildByPath(path.substring(1));
    }

    public StrutsBreakpointManager getBreakpointManager(XModelObject process) {
        StrutsProcessHelper helper = StrutsProcessHelper.getHelper(process);
        return helper != null ? helper.getBreakpointManager() : null;
    }

    public boolean hasErrors(XModelObject diagramObject) {
        if (diagramObject instanceof ReferenceObject) {
            XModelObject reference = ((ReferenceObject)diagramObject).getReference();
            return XMarkerManager.getInstance().hasErrors(reference);
        }
        return XMarkerManager.getInstance().hasErrors(diagramObject);
    }
}

