/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal.xb;

import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbAction;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbFileSet;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbFolder;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbLibFileSet;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackage;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackageNode;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackageNodeWithProperties;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackages;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbProperties;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbProperty;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.MarshallingContext;

public class XbPackagesObjectProvider
implements GenericObjectModelProvider {
    public Object getRoot(Object o, MarshallingContext context, String namespaceURI, String localName) {
        return o;
    }

    protected Object getNodeChildren(XbPackageNode node, String name) {
        if ("package".equals(name)) {
            return node.getChildren(XbPackage.class);
        }
        if ("folder".equals(name)) {
            return node.getChildren(XbFolder.class);
        }
        if ("fileset".equals(name)) {
            return node.getChildren(XbFileSet.class);
        }
        if ("lib-fileset".equals(name)) {
            return node.getChildren(XbLibFileSet.class);
        }
        if ("properties".equals(name) && node instanceof XbPackageNodeWithProperties) {
            return ((XbPackageNodeWithProperties)node).getProperties();
        }
        if ("property".equals(name) && node instanceof XbProperties) {
            return ((XbProperties)node).getProperties().getPropertyElements();
        }
        if ("buildAction".equals(name) && node instanceof XbPackage) {
            return ((XbPackage)node).getActions();
        }
        return null;
    }

    public Object getChildren(Object object, MarshallingContext context, String namespaceURI, String localName) {
        if (object instanceof XbPackageNode) {
            Object ret = this.getNodeChildren((XbPackageNode)object, localName);
            return ret;
        }
        return null;
    }

    public Object getAttributeValue(Object object, MarshallingContext context, String namespaceURI, String localName) {
        if (object instanceof XbPackages) {
            if ("version".equals(localName)) {
                return ((XbPackages)object).getVersion();
            }
        } else if (object instanceof XbPackage) {
            XbPackage pkg = (XbPackage)object;
            if ("id".equals(localName)) {
                return pkg.getId();
            }
            if ("type".equals(localName)) {
                return pkg.getPackageType();
            }
            if ("name".equals(localName)) {
                return pkg.getName();
            }
            if ("exploded".equals(localName)) {
                return pkg.isExploded();
            }
            if ("todir".equals(localName)) {
                return pkg.getToDir();
            }
            if ("inWorkspace".equals(localName)) {
                return "" + pkg.isInWorkspace();
            }
        } else if (object instanceof XbFolder) {
            XbFolder folder = (XbFolder)object;
            if ("name".equals(localName)) {
                return folder.getName();
            }
        } else if (object instanceof XbFileSet) {
            XbFileSet fileset = (XbFileSet)object;
            if ("dir".equals(localName)) {
                return fileset.getDir();
            }
            if ("includes".equals(localName)) {
                return fileset.getIncludes();
            }
            if ("excludes".equals(localName)) {
                return fileset.getExcludes();
            }
            if ("inWorkspace".equals(localName)) {
                return "" + fileset.isInWorkspace();
            }
            if ("flatten".equals(localName)) {
                return new Boolean(fileset.isFlattened()).toString();
            }
        } else if (object instanceof XbLibFileSet) {
            XbLibFileSet fs = (XbLibFileSet)object;
            if ("id".equals(localName)) {
                return fs.getId();
            }
        } else if (object instanceof XbProperty) {
            XbProperty prop = (XbProperty)object;
            if ("name".equals(localName)) {
                return prop.getName();
            }
            if ("value".equals(localName)) {
                return prop.getValue();
            }
        } else if (object instanceof XbAction) {
            XbAction action = (XbAction)object;
            if ("time".equals(localName)) {
                return action.getTime();
            }
            if ("type".equals(localName)) {
                return action.getType();
            }
        }
        return null;
    }

    public Object getElementValue(Object object, MarshallingContext context, String namespaceURI, String localName) {
        return null;
    }
}

