/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.lang.reflect.InvocationTargetException;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class ReviewResourceAction
extends Action {
    private IProgressMonitor monitor;
    private IResource resource;

    public ReviewResourceAction(IResource iResource) {
        this.setImageDescriptor(PMDPlugin.getImageDescriptor("icons/btn_refresh.gif"));
        this.setToolTipText(this.getString("view.tooltip.refresh_resource"));
        this.resource = iResource;
    }

    public void setResource(IResource iResource) {
        this.resource = iResource;
    }

    public void run() {
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    ReviewResourceAction.this.setMonitor(iProgressMonitor);
                    iProgressMonitor.beginTask(ReviewResourceAction.this.getString("monitor.review"), 5);
                    ReviewCodeCmd reviewCodeCmd = new ReviewCodeCmd();
                    reviewCodeCmd.addResource(ReviewResourceAction.this.resource);
                    reviewCodeCmd.setStepsCount(1);
                    reviewCodeCmd.setTaskMarker(true);
                    reviewCodeCmd.setUserInitiated(true);
                    try {
                        reviewCodeCmd.performExecute();
                    }
                    catch (CommandException commandException) {
                        PMDPlugin.getDefault().logError(ReviewResourceAction.this.getString("message.error.core_exception"), commandException);
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            PMDPlugin.getDefault().logError(this.getString("message.error.invocationtarget_exception"), invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            PMDPlugin.getDefault().logError(this.getString("message.error.interrupted_exception"), interruptedException);
        }
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected void setMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

