/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleDialog;
import net.sourceforge.pmd.eclipse.ui.views.actions.ViolationSelectionAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;

public class ShowRuleAction
extends ViolationSelectionAction {
    private Shell shell;

    public ShowRuleAction(TableViewer tableViewer, Shell shell) {
        super(tableViewer);
        this.setText(PMDPlugin.getDefault().getStringTable().getString("view.action.show_rule"));
        this.setToolTipText(PMDPlugin.getDefault().getStringTable().getString("view.tooltip.show_rule"));
    }

    public void run() {
        Rule rule = this.getSelectedViolationRule();
        if (rule != null) {
            RuleDialog ruleDialog = new RuleDialog(this.shell, rule, false);
            ruleDialog.open();
        }
    }

    public Rule getSelectedViolationRule() {
        Rule rule = null;
        try {
            IMarker[] iMarkerArray = this.getSelectedViolations();
            if (iMarkerArray != null) {
                rule = PMDPlugin.getDefault().getPreferencesManager().getRuleSet().getRuleByName(iMarkerArray[0].getAttribute("rulename", ""));
            }
        }
        catch (RuntimeException runtimeException) {
            PMDPlugin.getDefault().logError("message.error.runtime_exception", runtimeException);
        }
        return rule;
    }
}

