/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.jboss.tools.common.model.XModelObject;

public abstract class AbstractSelectionProvider
implements ISelectionProvider,
IPostSelectionProvider {
    private ArrayList<ISelectionChangedListener> listeners = new ArrayList();

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        XModelObject o = this.getSelectedModelObject();
        return o == null ? new StructuredSelection() : new StructuredSelection((Object)o);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection ss = (StructuredSelection)selection;
        if (!ss.isEmpty() && ss.getFirstElement() instanceof XModelObject) {
            this.setSelectedModelObject((XModelObject)ss.getFirstElement());
        }
    }

    public void fireSelectionChanged() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ISelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Iterator<ISelectionChangedListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().selectionChanged(newEvent);
        }
    }

    protected abstract XModelObject getSelectedModelObject();

    protected abstract void setSelectedModelObject(XModelObject var1);

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
    }
}

