/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.Assert;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.util.extension.ExtensionPointUtil;

public class AdapterFactory {
    public static final String ATTRIBUTE_ADAPTER_EXT_POINT = "org.jboss.tools.common.model.ui.attributeAdapter";
    private static Map<String, Class> classes = new HashMap<String, Class>();

    public static IModelPropertyEditorAdapter getAdapter(XAttribute attribute, XModelObject modelObject, XModel model) {
        return AdapterFactory.getAdapter(attribute, modelObject, null, model);
    }

    public static IModelPropertyEditorAdapter getAdapter(XAttribute attribute, XAttributeData attributeData, XModel model) {
        Assert.isTrue((model != null ? 1 : 0) != 0, (String)"AdapterFactory.getAdapter(XAttribute, XAttributeData, XModel) model cannot be null!");
        return AdapterFactory.getAdapter(attribute, null, attributeData, model);
    }

    public static IModelPropertyEditorAdapter getAdapter(XAttribute attribute, XModelObject modelObject, XAttributeData attributeData, XModel model) {
        IModelPropertyEditorAdapter adapter = new DefaultValueAdapter();
        try {
            adapter = (IModelPropertyEditorAdapter)AdapterFactory.getAdapterClass(attribute).newInstance();
        }
        catch (InstantiationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        if (model == null && modelObject != null) {
            model = modelObject.getModel();
        }
        adapter.setModel(model);
        adapter.setAttribute(attribute);
        if (modelObject != null) {
            adapter.setModelObject(modelObject);
        }
        if (attributeData != null) {
            adapter.setAttributeData(attributeData);
        }
        adapter.load();
        return adapter;
    }

    private static Class getAdapterClass(XAttribute attribute) {
        return AdapterFactory.getAdapterClass(attribute.getEditor().getName());
    }

    private static Class getAdapterClass(String id) {
        Class<Object> c = classes.get(id);
        if (c != null) {
            return c;
        }
        try {
            c = ExtensionPointUtil.findClassByElementId((String)ATTRIBUTE_ADAPTER_EXT_POINT, (String)id).getClass();
        }
        catch (CoreException coreException) {
            if (ModelUIPlugin.getDefault().isDebugging()) {
                ModelUIPlugin.getPluginLog().logInfo("Default adapter for " + id);
            }
            c = DefaultValueAdapter.class;
        }
        classes.put(id, c);
        return c;
    }
}

