/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.tools.common.model.ui.IListEditor;
import org.jboss.tools.common.model.ui.IStructuredChangeListener;
import org.jboss.tools.common.model.ui.IStructuredEditor;
import org.jboss.tools.common.model.ui.StructuredChangedEvent;
import org.jboss.tools.common.model.ui.actions.IActionProvider;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.ITableAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.StructuredListAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ActionButtonControl;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.BorderedControl;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.ScrolledComposite;
import org.jboss.tools.common.model.ui.widgets.border.Border;

public class TableStructuredFieldEditor
extends ExtendedFieldEditor
implements IPropertyFieldEditor,
IStructuredEditor,
IListEditor,
IFieldEditor,
PropertyChangeListener,
IStructuredChangeListener,
ISelectionChangedListener {
    private TableViewer tableViewer;
    private Control tableControl;
    private Table tableField;
    private IPropertyEditor propertyEditor;
    IStructuredContentProvider structuredContentProvider;
    IStructuredChangeListener structuredChangeListener;
    StructuredListAdapter.INewValueProvider newValueProvider;
    ILabelProvider labelProvider;
    IListContentProvider listContentProvider;
    ITableAdapter tableAdapter;
    Composite composite;
    Composite tableButtonsControl;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private IActionProvider actionProvider;
    private ActionButtonControl actionButtonControl;

    public TableStructuredFieldEditor() {
    }

    public TableStructuredFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        this.initialize();
    }

    public void setStructuredContentProvider(IStructuredContentProvider structuredContentProvider) {
        this.structuredContentProvider = structuredContentProvider;
    }

    public void setStructuredChangeListener(IStructuredChangeListener structuredChangeListener) {
        this.structuredChangeListener = structuredChangeListener;
    }

    public void setNewStructuredElementProvider(StructuredListAdapter.INewValueProvider newValueProvider) {
        this.newValueProvider = newValueProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setListContentProvider(IListContentProvider listContentProvider) {
        this.listContentProvider = listContentProvider;
    }

    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.createTableButtonsComponent(parent)};
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected void applyButtonSkin(Control button) {
        if (button != null) {
            Color bg = this.getSettings().getColor("Button.Background");
            Color fg = this.getSettings().getColor("Button.Foreground");
            Font font = this.getSettings().getFont("Button.Font");
            button.setBackground(bg);
            button.setForeground(fg);
            button.setFont(font);
        }
    }

    public Control createButtonsControl(Composite parent) {
        return this.actionButtonControl.createControl(parent);
    }

    private ActionButtonControl createActionButtonControl() {
        ActionButtonControl actionButtonControl = new ActionButtonControl();
        actionButtonControl.setPropertyEditor(this.propertyEditor);
        return actionButtonControl;
    }

    public Control getTableControl() {
        return this.tableControl;
    }

    public Control createTableControl(Composite parent) {
        if (this.tableField == null) {
            TableColumn[] cs;
            int style = this.getSettings().getStyle("Table.Style");
            Color bg = this.getSettings().getColor("Table.Background");
            Color fg = this.getSettings().getColor("Table.Foreground");
            Font font = this.getSettings().getFont("Table.Font");
            Border border = this.getSettings().getBorder("Table.Border");
            if (style == -1) {
                style = 0;
            }
            if (border != null) {
                BorderedControl borderedControl = new BorderedControl(parent, 0, border);
                this.tableField = new Table((Composite)borderedControl, style | 0x10000);
                this.tableControl = borderedControl;
            } else {
                this.tableField = new Table(parent, 67584);
                this.tableControl = this.tableField;
            }
            this.tableField.setFont(font);
            this.tableField.setBackground(bg);
            this.tableField.setForeground(fg);
            this.tableField.setHeaderVisible(true);
            this.tableField.setLinesVisible(true);
            this.tableField.setLayout((Layout)new TableLayout());
            this.tableField.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (TableStructuredFieldEditor.this.getActionProvider() == null) {
                        return;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            IAction action = TableStructuredFieldEditor.this.getActionProvider().getAction("DOUBLE_CLICK__ACTION");
                            if (action != null) {
                                action.run();
                            }
                        }
                    });
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            if (this.tableAdapter != null && (cs = this.tableAdapter.createTableColumn(this.tableField, 0)) != null && cs.length == 1) {
                this.tableField.setLinesVisible(false);
                this.tableField.setHeaderVisible(false);
                GridData g = new GridData(1808);
                g.horizontalSpan = 2;
            }
            if (this.tableViewer == null) {
                this.tableViewer = new TableViewer(this.tableField);
            }
            if (this.tableAdapter != null) {
                this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableAdapter.getTableLabelProvider());
            }
            if (this.tableAdapter != null) {
                this.tableViewer.setContentProvider((IContentProvider)this.tableAdapter);
            }
            if (this.tableAdapter != null) {
                this.tableViewer.setInput((Object)this);
            }
            if (this.tableAdapter != null) {
                this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this.tableAdapter);
                this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (TableStructuredFieldEditor.this.tableField == null || TableStructuredFieldEditor.this.tableField.isDisposed() || !TableStructuredFieldEditor.this.tableField.isFocusControl()) {
                            return;
                        }
                        TableItem[] items = TableStructuredFieldEditor.this.tableField.getSelection();
                        if (items == null || items.length == 0) {
                            return;
                        }
                        Rectangle r = items[0].getBounds(0);
                        ScrolledComposite.scrollToVisible((Control)TableStructuredFieldEditor.this.tableField, r);
                    }
                });
                this.tableField.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (TableStructuredFieldEditor.this.tableField == null || TableStructuredFieldEditor.this.tableField.isDisposed() || !TableStructuredFieldEditor.this.tableField.isFocusControl()) {
                            return;
                        }
                        TableItem[] items = TableStructuredFieldEditor.this.tableField.getSelection();
                        if (items != null && items.length > 0) {
                            Rectangle r = items[0].getBounds(0);
                            ScrolledComposite.scrollToVisible((Control)TableStructuredFieldEditor.this.tableField, r);
                        } else {
                            ScrolledComposite.scrollToVisible((Control)TableStructuredFieldEditor.this.tableField, new Rectangle(0, 0, 100, 10));
                        }
                    }

                    public void focusLost(FocusEvent e) {
                    }
                });
            }
            this.structureChanged(null);
        }
        return this.tableControl;
    }

    public Control createTableButtonsComponent(Composite parent) {
        if (this.tableButtonsControl == null) {
            this.tableButtonsControl = new Composite(parent, 0);
            this.tableButtonsControl.setBackground(parent.getBackground());
            GridLayout layout = new GridLayout(3, Boolean.FALSE.booleanValue());
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.tableButtonsControl.setLayout((Layout)layout);
            Label l = new Label(this.tableButtonsControl, 0);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 3;
            l.setLayoutData((Object)gd);
            Control control = this.createTableControl(this.tableButtonsControl);
            if (this.tableField.getColumnCount() == 1) {
                l.setText(this.tableField.getColumn(0).getText());
            } else {
                l.dispose();
            }
            gd = new GridData(1808);
            control.setLayoutData((Object)gd);
            if (this.tableAdapter.getActionProvider() != null && this.tableAdapter.getActionProvider().getActions() != null && this.tableAdapter.getActionProvider().getActions().length > 0) {
                control = new Composite(this.tableButtonsControl, 0);
                control.setBackground(this.tableButtonsControl.getBackground());
                gd = new GridData();
                gd.widthHint = 5;
                control.setLayoutData((Object)gd);
                control = this.createButtonsControl(this.tableButtonsControl);
                if (control != null) {
                    gd = new GridData();
                    gd.verticalAlignment = 128;
                    control.setLayoutData((Object)gd);
                }
            }
            this.updateTableLayoutData();
        }
        return this.tableButtonsControl;
    }

    public boolean updateTableLayoutData() {
        if (this.tableField == null || this.tableField.isDisposed()) {
            return false;
        }
        boolean isNew = false;
        boolean changed = false;
        GridData data = null;
        if (this.tableButtonsControl.getLayoutData() instanceof GridData) {
            data = (GridData)this.tableButtonsControl.getLayoutData();
        } else {
            data = new GridData(1808);
            data.horizontalSpan = 2;
            isNew = true;
            changed = true;
        }
        int itemCount = this.tableField.getItemCount();
        if (itemCount > 10) {
            if (data.heightHint != 250 || data.verticalAlignment != 1) {
                changed = true;
                data.verticalAlignment = 1;
                data.heightHint = 250;
            }
        } else if (data.heightHint != -1 || data.verticalAlignment != 4) {
            changed = true;
            data.verticalAlignment = 4;
            data.heightHint = -1;
        }
        if (changed) {
            this.tableButtonsControl.setLayoutData((Object)data);
        }
        return !isNew && changed;
    }

    public Control getControl() {
        return this.tableControl;
    }

    private void initialize() {
        if (this.propertyEditor != null) {
            this.tableAdapter = (ITableAdapter)this.propertyEditor.getAdapter(ITableAdapter.class);
        }
        if (this.tableAdapter != null) {
            this.tableAdapter.addStructureChangeListener(this);
            this.tableAdapter.addSelectionChangedListener(this);
            this.actionProvider = (IActionProvider)this.propertyEditor.getAdapter(IActionProvider.class);
            this.actionButtonControl = this.createActionButtonControl();
            this.actionButtonControl.setPropertyEditor(this.propertyEditor);
            this.actionButtonControl.setSettings(this.getSettings());
        }
    }

    public void structureChanged(StructuredChangedEvent event) {
        if (this.tableViewer == null) {
            return;
        }
        Table table = this.tableViewer.getTable();
        if (table == null || table.isDisposed()) {
            return;
        }
        int i = table.getSelectionIndex();
        if (i < 0) {
            i = 0;
        }
        this.tableViewer.refresh();
        int c = this.tableViewer.getTable().getItemCount();
        if (this.updateTableLayoutData()) {
            this.tableButtonsControl.layout();
            this.tableButtonsControl.getParent().layout();
            this.tableButtonsControl.getParent().getParent().layout();
        }
        while (i >= c) {
            --i;
        }
        if (i >= 0) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(this.tableViewer.getTable().getItem(i).getData()));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.tableAdapter.removeSelectionChangedListener(this);
        this.tableViewer.setSelection(event.getSelection());
        this.tableAdapter.addSelectionChangedListener(this);
        if (this.actionProvider != null) {
            this.actionProvider.update(event.getSelection());
        }
    }

    protected IActionProvider getActionProvider() {
        return this.actionProvider;
    }

    protected void setActionProvider(IActionProvider provider) {
        this.actionProvider = provider;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }

    public void delete() {
    }
}

