/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.navigator.decorator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.navigator.decorator.AttributeDecoratorPart;
import org.jboss.tools.common.model.ui.navigator.decorator.DecoratorConstants;
import org.jboss.tools.common.model.ui.navigator.decorator.DecoratorPart;
import org.jboss.tools.common.model.ui.navigator.decorator.Example;
import org.jboss.tools.common.model.ui.navigator.decorator.IDecoratorPart;
import org.jboss.tools.common.model.ui.navigator.decorator.NameDecoratorPart;
import org.jboss.tools.common.model.ui.navigator.decorator.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XModelObjectDecorator
implements DecoratorConstants {
    String name;
    String partition;
    Set<String> entities = new HashSet<String>();
    Variable[] variables = new Variable[0];
    Map<String, Variable> variableByName = new HashMap<String, Variable>();
    String defaultValue;
    String value;
    List<IDecoratorPart> parts = null;
    XModelObject[] examples = new XModelObject[0];

    public String getName() {
        return this.name;
    }

    public String getPartition() {
        return this.partition;
    }

    public Set<String> getEntities() {
        return this.entities;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public Variable getVariableByName(String name) {
        return this.variableByName.get(name);
    }

    public XModelObject[] getExamples() {
        return this.examples;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value != null && value.equals(this.value)) {
            return;
        }
        this.value = value;
        if (value == null || value.length() == 0) {
            value = Variable.NAME.getRuleText();
        }
        this.parts = null;
    }

    void load(IConfigurationElement element) {
        this.name = element.getAttribute("name");
        this.partition = element.getAttribute("partition");
        this.defaultValue = element.getAttribute("defaultValue");
        this.setValue(this.defaultValue);
        this.value = this.defaultValue;
        String s = element.getAttribute("entities");
        if (s != null) {
            String[] es = s.split(",");
            int i = 0;
            while (i < es.length) {
                this.entities.add(es[i]);
                ++i;
            }
        }
        IConfigurationElement[] cs = element.getChildren("variable");
        ArrayList<Variable> vs = new ArrayList<Variable>();
        vs.add(Variable.NAME);
        this.variableByName.put(Variable.NAME.getName(), Variable.NAME);
        int i = 0;
        while (i < cs.length) {
            Variable v = new Variable();
            v.load(cs[i]);
            vs.add(v);
            this.variableByName.put(v.getName(), v);
            ++i;
        }
        this.variables = vs.toArray(new Variable[0]);
        ArrayList<XModelObject> es = new ArrayList<XModelObject>();
        cs = element.getChildren("example");
        int i2 = 0;
        while (i2 < cs.length) {
            XModelObject o = Example.load(cs[i2]);
            if (o != null) {
                es.add(o);
            }
            ++i2;
        }
        this.examples = es.toArray(new XModelObject[0]);
    }

    List<IDecoratorPart> compile() {
        if (this.parts != null) {
            return this.parts;
        }
        ArrayList<IDecoratorPart> parts = new ArrayList<IDecoratorPart>();
        String v = this.value;
        if (this.value == null || this.value.length() == 0) {
            v = this.defaultValue;
        }
        if (v == null) {
            v = "";
        }
        if (v.indexOf("{") < 0) {
            if (v.length() > 0) {
                v = " " + v;
            }
            v = String.valueOf(Variable.NAME.getRuleText()) + v;
        }
        StringTokenizer s = new StringTokenizer(v, "{}", true);
        boolean inVariable = false;
        while (s.hasMoreTokens()) {
            String t = s.nextToken();
            if (t.equals("{")) {
                inVariable = true;
                continue;
            }
            if (t.equals("}")) {
                inVariable = false;
                continue;
            }
            if (inVariable) {
                Variable variable;
                String n = t;
                String p = "";
                int i = t.indexOf(40);
                int j = t.indexOf(41);
                if (i >= 0 && j > i) {
                    n = t.substring(0, i);
                    p = t.substring(i + 1, j);
                }
                if ((variable = this.getVariableByName(n)) == Variable.NAME) {
                    parts.add(NameDecoratorPart.INSTANCE);
                    continue;
                }
                if (variable != null) {
                    AttributeDecoratorPart part = new AttributeDecoratorPart(variable);
                    part.setParameters(p);
                    parts.add(part);
                    continue;
                }
                parts.add(new DecoratorPart("{" + t + "}"));
                continue;
            }
            parts.add(new DecoratorPart(t));
        }
        boolean hasSignificantPart = false;
        for (IDecoratorPart p : parts) {
            if (p != NameDecoratorPart.INSTANCE && !(p instanceof AttributeDecoratorPart)) continue;
            hasSignificantPart = true;
            break;
        }
        if (!hasSignificantPart) {
            parts.add(NameDecoratorPart.INSTANCE);
        }
        this.parts = parts;
        return this.parts;
    }

    public String getLabel(XModelObject object) {
        List<IDecoratorPart> parts = this.compile();
        StringBuffer sb = new StringBuffer();
        for (IDecoratorPart d : parts) {
            sb.append(d.getLabelPart(object));
        }
        String s = sb.toString().trim();
        if (s.length() == 0) {
            s = object.getPresentationString();
        }
        return s;
    }

    public XModelObjectDecorator getWorkingCopy() {
        XModelObjectDecorator copy = new XModelObjectDecorator();
        copy.name = this.name;
        copy.partition = this.partition;
        copy.defaultValue = this.defaultValue;
        copy.value = this.value;
        copy.entities = this.entities;
        copy.variables = this.variables;
        copy.variableByName = this.variableByName;
        return copy;
    }
}

