/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.select;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.jboss.tools.common.model.XModelObject;

public class XModelObjectSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    private List<ISelectionChangedListener> listeners;
    private ISelectionProvider host = null;
    private Map<String, ISelectionProvider> hostsMap = new HashMap<String, ISelectionProvider>();
    private ISelectionProvider[] hosts = new ISelectionProvider[0];
    boolean isFiringSelection = false;

    public XModelObjectSelectionProvider() {
        this.listeners = new ArrayList<ISelectionChangedListener>();
    }

    public boolean isFiringSelection() {
        return this.isFiringSelection;
    }

    public void dispose() {
        this.setHost(null);
        this.listeners.clear();
        this.hosts = new ISelectionProvider[0];
        this.hostsMap.clear();
    }

    public void addHost(String name, ISelectionProvider host) {
        this.addHost(name, host, false);
    }

    public void addHost(String name, ISelectionProvider host, boolean select) {
        if (host == null) {
            this.hostsMap.remove(name);
        } else {
            this.hostsMap.put(name, host);
        }
        this.hosts = this.hostsMap.values().toArray(new ISelectionProvider[0]);
        if (host != null && select) {
            this.setHost(host);
        }
    }

    public void setHost(ISelectionProvider host) {
        if (this.host == host) {
            return;
        }
        if (this.host != null) {
            this.host.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.host = host;
        if (host != null) {
            host.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.host == null ? null : this.convertSelectionToAdapter(this.host.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (this.host == null) {
            return;
        }
        if (this.isFiringSelection) {
            return;
        }
        ISelection s = this.convertSelectionFromAdapter(selection);
        int i = 0;
        while (i < this.hosts.length) {
            this.hosts[i].setSelection(s);
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isFiringSelection) {
            return;
        }
        this.isFiringSelection = true;
        try {
            if (!this.listeners.isEmpty()) {
                SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, this.convertSelectionToAdapter(event.getSelection()));
                Iterator<ISelectionChangedListener> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().selectionChanged(newEvent);
                }
            }
        }
        finally {
            this.isFiringSelection = false;
        }
    }

    public void postSelectionChanged(SelectionChangedEvent event) {
        if (this.isFiringSelection) {
            return;
        }
        this.isFiringSelection = true;
        try {
            if (!this.listeners.isEmpty()) {
                Iterator<ISelectionChangedListener> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().selectionChanged(event);
                }
            }
        }
        finally {
            this.isFiringSelection = false;
        }
    }

    private ISelection convertSelectionToAdapter(ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return selection;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        List objects = structuredSelection.toList();
        ArrayList<Object> adaptedObjects = new ArrayList<Object>();
        for (Object object : objects) {
            if (object instanceof XModelObject) {
                XModelObject xmo = (XModelObject)object;
                if ("FileJAVA".equals(xmo.getModelEntity().getName())) {
                    Object adapter = xmo.getAdapter(ICompilationUnit.class);
                    if (adapter == null) continue;
                    adaptedObjects.add(adapter);
                    continue;
                }
                adaptedObjects.add(xmo);
                continue;
            }
            if (!(object instanceof IAdaptable)) continue;
            adaptedObjects.add(object);
        }
        return new StructuredSelection(adaptedObjects);
    }

    private ISelection convertSelectionFromAdapter(ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return selection;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        List objects = structuredSelection.toList();
        ArrayList<XModelObject> modelObjects = new ArrayList<XModelObject>();
        for (Object object : objects) {
            if (!(object instanceof XModelObject)) continue;
            modelObjects.add((XModelObject)object);
        }
        return new StructuredSelection(modelObjects);
    }
}

