/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BestGuessConsoleConfigurationVisitor
implements IResourceProxyVisitor {
    private IPath propertyFile;
    private IPath configFile;
    private IPath persistencexml;
    private IJavaProject javaProject;
    private List<IPath> classpath = new ArrayList<IPath>();
    private List<IPath> mappings = new ArrayList<IPath>();

    public IPath getPropertyFile() {
        return this.propertyFile;
    }

    public IPath getConfigFile() {
        return this.configFile;
    }

    public IPath getPersistencexml() {
        return this.persistencexml;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public List<IPath> getClasspath() {
        return this.classpath;
    }

    public List<IPath> getMappings() {
        return this.mappings;
    }

    public boolean visit(IResourceProxy proxy) throws CoreException {
        IPath fullPath = proxy.requestFullPath();
        if (proxy.getType() == 1) {
            if ("hibernate.properties".equals(proxy.getName())) {
                this.propertyFile = fullPath;
                return false;
            }
            if ("hibernate.cfg.xml".equals(proxy.getName())) {
                this.configFile = fullPath;
                this.mappings.clear();
                return false;
            }
            if ("persistence.xml".equals(proxy.getName()) && this.javaProject != null && this.javaProject.isOnClasspath(proxy.requestResource())) {
                this.persistencexml = fullPath;
                this.mappings.clear();
                return false;
            }
            if ((this.configFile == null || this.persistencexml == null) && proxy.getName().endsWith(".hbm.xml")) {
                this.mappings.add(fullPath);
                return false;
            }
        } else if (proxy.getType() == 2 && this.javaProject != null && this.javaProject.getOutputLocation().isPrefixOf(fullPath)) {
            return false;
        }
        return true;
    }

    public void setJavaProject(IJavaProject project) {
        this.javaProject = project;
    }
}

