/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.layout;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.hibernate.eclipse.graph.layout.GraphLayoutManager;
import org.hibernate.eclipse.graph.layout.GraphXYLayout;
import org.hibernate.eclipse.graph.parts.ConfigurationEditPart;
import org.hibernate.eclipse.graph.policy.ConfigurationLayoutEditPolicy;

public class DelegatingLayoutManager
implements LayoutManager {
    private ConfigurationEditPart diagram;
    private LayoutManager activeLayoutManager;
    private GraphLayoutManager graphLayoutManager;
    private GraphXYLayout xyLayoutManager;

    public DelegatingLayoutManager(ConfigurationEditPart diagram) {
        this.diagram = diagram;
        this.graphLayoutManager = new GraphLayoutManager(diagram);
        this.xyLayoutManager = new GraphXYLayout(diagram);
        this.activeLayoutManager = diagram.isManualLayoutActive() ? this.xyLayoutManager : this.graphLayoutManager;
    }

    public void layout(IFigure container) {
        if (this.diagram.isManualLayoutActive()) {
            this.setLayoutManager(container, (LayoutManager)this.xyLayoutManager);
            this.activeLayoutManager.layout(container);
        } else {
            this.setLayoutManager(container, (LayoutManager)this.graphLayoutManager);
            this.activeLayoutManager.layout(container);
        }
    }

    public Object getConstraint(IFigure child) {
        return this.activeLayoutManager.getConstraint(child);
    }

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return this.activeLayoutManager.getMinimumSize(container, wHint, hHint);
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        return this.activeLayoutManager.getPreferredSize(container, wHint, hHint);
    }

    public void invalidate() {
        this.activeLayoutManager.invalidate();
    }

    public void remove(IFigure child) {
        this.activeLayoutManager.remove(child);
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.activeLayoutManager.setConstraint(child, constraint);
    }

    public void setXYLayoutConstraint(IFigure child, Rectangle constraint) {
        this.xyLayoutManager.setConstraint(child, constraint);
    }

    private void setLayoutManager(IFigure container, LayoutManager layoutManager) {
        container.setLayoutManager(layoutManager);
        this.activeLayoutManager = layoutManager;
        if (layoutManager == this.xyLayoutManager) {
            this.diagram.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ConfigurationLayoutEditPolicy());
        } else {
            this.diagram.installEditPolicy("LayoutEditPolicy", null);
        }
    }

    public LayoutManager getActiveLayoutManager() {
        return this.activeLayoutManager;
    }
}

