/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.osgi.util.NLS;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.QueryEditor;
import org.hibernate.eclipse.hqleditor.DisplayStringProposalComparator;
import org.hibernate.eclipse.hqleditor.EclipseHQLCompletionRequestor;
import org.hibernate.eclipse.hqleditor.MinimalDiffContextInformationValidator;
import org.hibernate.tool.ide.completion.HQLCodeAssist;
import org.hibernate.tool.ide.completion.IHQLCompletionRequestor;

public class HQLCompletionProcessor
implements IContentAssistProcessor {
    private char[] autoActivationChars = new char[]{'.'};
    protected IContextInformationValidator validator = new MinimalDiffContextInformationValidator(5);
    private final Comparator<ICompletionProposal> completionComparator;
    private QueryEditor hqlEditor;
    private String errorMessage;

    public HQLCompletionProcessor(QueryEditor editor) {
        this.hqlEditor = editor;
        this.completionComparator = DisplayStringProposalComparator.INSTANCE;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IDocument doc = viewer.getDocument();
        return this.computeCompletionProposals(doc, documentOffset);
    }

    public ICompletionProposal[] computeCompletionProposals(IDocument doc, int documentOffset) {
        ICompletionProposal[] result = new ICompletionProposal[]{};
        try {
            ITypedRegion partition = null;
            partition = documentOffset > 0 ? doc.getPartition(documentOffset - 1) : doc.getPartition(documentOffset);
            if (partition != null) {
                result = this.computeProposals(doc, partition.getOffset(), documentOffset, this.hqlEditor.getConsoleConfiguration());
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (RuntimeException re) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.HQLCompletionProcessor_error_while_performing_hql_completion, re);
        }
        if (result != null) {
            result = this.sort(result);
        }
        return result;
    }

    ICompletionProposal[] computeProposals(IDocument doc, int lineStart, int currentOffset, final ConsoleConfiguration consoleConfiguration) {
        ICompletionProposal[] result = null;
        this.errorMessage = null;
        if (doc != null && currentOffset >= 0) {
            int wordLength;
            ArrayList<ICompletionProposal> proposalList = new ArrayList<ICompletionProposal>();
            String startWord = null;
            int startOffset = this.findNearestWhiteSpace(doc, currentOffset, lineStart);
            startWord = this.getWord(doc, startOffset, wordLength = currentOffset - startOffset);
            if (startWord != null) {
                try {
                    doc.get(0, doc.getLength()).toCharArray();
                }
                catch (BadLocationException badLocationException) {
                    this.errorMessage = HibernateConsoleMessages.HQLCompletionProcessor_could_not_get_document_contents;
                    return result;
                }
                if (consoleConfiguration != null && consoleConfiguration.getConfiguration() == null) {
                    try {
                        consoleConfiguration.build();
                        consoleConfiguration.execute(new ExecutionContext.Command(){

                            public Object execute() {
                                if (consoleConfiguration.hasConfiguration()) {
                                    consoleConfiguration.getConfiguration().buildMappings();
                                }
                                return consoleConfiguration;
                            }
                        });
                    }
                    catch (HibernateException e) {
                        String mess = NLS.bind((String)HibernateConsoleMessages.CompletionHelper_error_could_not_build_cc, (Object)consoleConfiguration.getName());
                        HibernateConsolePlugin.getDefault().logErrorMessage(mess, e);
                    }
                }
                Configuration configuration = consoleConfiguration != null ? consoleConfiguration.getConfiguration() : null;
                HQLCodeAssist hqlEval = new HQLCodeAssist(configuration);
                EclipseHQLCompletionRequestor eclipseHQLCompletionCollector = new EclipseHQLCompletionRequestor();
                String query = doc.get();
                query = query.replace('\t', ' ');
                hqlEval.codeComplete(query, currentOffset, (IHQLCompletionRequestor)eclipseHQLCompletionCollector);
                proposalList.addAll(eclipseHQLCompletionCollector.getCompletionProposals());
                this.errorMessage = eclipseHQLCompletionCollector.getLastErrorMessage();
                result = proposalList.toArray(new ICompletionProposal[proposalList.size()]);
                if (result.length == 0 && this.errorMessage == null) {
                    this.errorMessage = HibernateConsoleMessages.HQLCompletionProcessor_no_hql_completions_available;
                }
            } else {
                this.errorMessage = HibernateConsoleMessages.HQLCompletionProcessor_no_start_word_found;
            }
        }
        return result;
    }

    private String getWord(IDocument doc, int startOffset, int wordLength) {
        try {
            return doc.get(startOffset, wordLength);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.validator;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private ICompletionProposal[] sort(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, this.completionComparator);
        return proposals;
    }

    public int findNearestWhiteSpace(IDocument doc, int documentOffset, int offset) {
        boolean loop = true;
        int tmpOffset = documentOffset - 1;
        try {
            while (loop && offset <= tmpOffset) {
                char c = doc.getChar(tmpOffset);
                if (c == '\"' || Character.isWhitespace(c)) {
                    loop = false;
                    continue;
                }
                --tmpOffset;
            }
        }
        catch (BadLocationException badLocationException) {}
        offset = tmpOffset + 1;
        return offset;
    }
}

