/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeController;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.jboss.tools.vpe.handlers.VisualPartAbstractHandler;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.resref.core.VpeResourcesDialog;

public class PageDesignOptionsHandler
extends VisualPartAbstractHandler {
    public static final String COMMAND_ID = "org.jboss.tools.vpe.commands.pageDesignOptionsCommand";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ILocationProvider provider;
        IPath path;
        IEditorPart activeEditor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        IEditorInput input = activeEditor.getEditorInput();
        IFile fileLocation = null;
        if (input instanceof IFileEditorInput) {
            IFile file;
            fileLocation = file = ((IFileEditorInput)input).getFile();
        } else if (input instanceof ILocationProvider && (path = (provider = (ILocationProvider)input).getPath((Object)input)) != null) {
            fileLocation = path;
        }
        if (fileLocation != null) {
            VpeResourcesDialog dialogNew = new VpeResourcesDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (Object)fileLocation);
            dialogNew.open();
        } else {
            VpePlugin.getDefault().logError(VpeUIMessages.COULD_NOT_OPEN_VPE_RESOURCES_DIALOG);
        }
        return null;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        boolean enabled;
        IEvaluationContext context;
        Object editor;
        IEditorPart activeEditor = null;
        if (evaluationContext instanceof IEvaluationContext && (editor = (context = (IEvaluationContext)evaluationContext).getVariable("activeEditor")) instanceof IEditorPart) {
            activeEditor = (IEditorPart)editor;
        }
        boolean isVisualPartVisible = false;
        boolean isFileExists = false;
        if (activeEditor != null) {
            JSPMultiPageEditor jspEditor;
            ILocationProvider provider;
            IPath path;
            IEditorInput input = activeEditor.getEditorInput();
            IFile file = null;
            if (input instanceof IFileEditorInput) {
                file = ((IFileEditorInput)input).getFile();
            } else if (input instanceof ILocationProvider && (path = (provider = (ILocationProvider)input).getPath((Object)input)) != null) {
                file = FileUtil.getFile(input, path.lastSegment());
                isFileExists = file != null && file.exists();
            }
            boolean bl = isFileExists = file != null && file.exists();
            if (activeEditor instanceof JSPMultiPageEditor && (jspEditor = (JSPMultiPageEditor)activeEditor).getVisualEditor().getController() != null) {
                isVisualPartVisible = ((VpeController)jspEditor.getVisualEditor().getController()).isVisualEditorVisible();
            }
        }
        boolean bl = enabled = isFileExists && isVisualPartVisible;
        if (this.isEnabled() != enabled) {
            this.setBaseEnabled(enabled);
        }
    }
}

