/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.explorer.DeltaInfo;
import de.tobject.findbugs.view.explorer.IViewerRefreshJob;
import de.tobject.findbugs.view.explorer.ResourceChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RefreshJob
extends Job
implements IViewerRefreshJob {
    private final RemovedFirstComparator deltaComparator;
    private final List<DeltaInfo> deltaToRefresh;
    private volatile CommonViewer viewer;
    private final BugContentProvider contentProvider;
    private final ResourceChangeListener resourceListener;

    public RefreshJob(String name, BugContentProvider provider) {
        super(name);
        this.setSystem(true);
        this.setPriority(50);
        this.contentProvider = provider;
        this.deltaComparator = new RemovedFirstComparator();
        this.deltaToRefresh = new ArrayList<DeltaInfo>();
        this.resourceListener = new ResourceChangeListener(this);
    }

    public boolean belongsTo(Object family) {
        return FindbugsPlugin.class == family;
    }

    private void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
    }

    private void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
    }

    public void dispose() {
        this.cancel();
        this.setViewer(null);
    }

    protected IStatus run(final IProgressMonitor monitor) {
        List<DeltaInfo> deltas = this.fetchDeltas();
        int totalWork = deltas.size();
        monitor.beginTask("Updating bug markers", totalWork);
        if (this.viewer != null && !monitor.isCanceled() && !deltas.isEmpty()) {
            final Set<BugGroup> changedParents = this.contentProvider.updateContent(deltas);
            final boolean fullRefreshNeeded = changedParents.isEmpty();
            Display.getDefault().syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block12: {
                        if (RefreshJob.this.viewer == null || monitor.isCanceled() || RefreshJob.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        RefreshJob.this.viewer.getControl().setRedraw(false);
                        try {
                            if (fullRefreshNeeded) {
                                RefreshJob.this.viewer.refresh();
                                if (BugContentProvider.DEBUG) {
                                    System.out.println("Refreshing ROOT!!!");
                                }
                                break block12;
                            }
                            for (BugGroup parent : changedParents) {
                                boolean isRoot;
                                boolean bl = isRoot = parent.getParent() == null;
                                if (BugContentProvider.DEBUG) {
                                    if (isRoot) {
                                        System.out.println("Refreshing ROOT: " + parent);
                                    } else {
                                        System.out.println("Refreshing: " + parent);
                                    }
                                }
                                if (isRoot) {
                                    RefreshJob.this.viewer.refresh();
                                } else {
                                    RefreshJob.this.viewer.refresh((Object)parent, true);
                                }
                                if (!monitor.isCanceled()) continue;
                                break;
                            }
                        }
                        finally {
                            RefreshJob.this.viewer.getControl().setRedraw(true);
                        }
                    }
                }
            });
        }
        monitor.worked(totalWork);
        monitor.done();
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DeltaInfo> fetchDeltas() {
        ArrayList<DeltaInfo> deltas = new ArrayList<DeltaInfo>();
        List<DeltaInfo> list = this.deltaToRefresh;
        synchronized (list) {
            if (this.deltaToRefresh.isEmpty()) {
                return deltas;
            }
            deltas.addAll(this.deltaToRefresh);
            this.deltaToRefresh.clear();
        }
        Collections.sort(deltas, this.deltaComparator);
        if (BugContentProvider.DEBUG) {
            System.out.println("Job: going to update markers:\n" + deltas);
        }
        return deltas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addToQueue(DeltaInfo res) {
        switch (res.changeKind) {
            case 4: {
                return false;
            }
        }
        List<DeltaInfo> list = this.deltaToRefresh;
        synchronized (list) {
            if (!this.deltaToRefresh.contains(res)) {
                this.deltaToRefresh.add(res);
                return true;
            }
        }
        return false;
    }

    public void setViewer(CommonViewer newViewer) {
        if (newViewer != null) {
            this.viewer = newViewer;
            this.startListening();
        } else {
            this.stopListening();
            this.viewer = null;
        }
    }

    CommonViewer getViewer() {
        return this.viewer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RemovedFirstComparator
    implements Comparator<DeltaInfo> {
        private RemovedFirstComparator() {
        }

        @Override
        public int compare(DeltaInfo o1, DeltaInfo o2) {
            if (o1.changeKind == o2.changeKind) {
                return 0;
            }
            if (o1.changeKind == 2) {
                return -1;
            }
            return 1;
        }
    }
}

