/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import org.apache.bcel.classfile.Code;

public class TestingGround
extends OpcodeStackDetector {
    BugReporter bugReporter;
    int state;
    int target;
    int startPC;
    boolean sawNew;
    XField f;

    public TestingGround(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code code) {
        boolean interesting;
        boolean bl = interesting = !this.getMethod().isSynchronized() && this.getMethod().isStatic() && !this.getMethodName().equals("<clinit>");
        if (interesting) {
            this.resetStateMachine();
            super.visit(code);
        }
    }

    boolean interestingQuick(XField xField) {
        if (xField.isFinal() || xField.isVolatile() || xField.isSynthetic() || !xField.isStatic()) {
            return false;
        }
        if (xField.getName().indexOf(36) >= 0) {
            return false;
        }
        String sig = xField.getSignature();
        char c = sig.charAt(0);
        if (c != 'L' && c != '[') {
            return false;
        }
        return !sig.startsWith("Ljava/lang/");
    }

    boolean interestingDeep(XField xField) {
        String sig = xField.getSignature();
        if (sig.charAt(0) == 'L') {
            ClassDescriptor fieldType = DescriptorFactory.createClassDescriptorFromFieldSignature(sig);
            while (fieldType != null) {
                XClass fieldClass;
                try {
                    fieldClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, fieldType);
                }
                catch (CheckedAnalysisException e) {
                    break;
                }
                String name = fieldClass.getClassDescriptor().getClassName();
                if (name.startsWith("java/awt") || name.startsWith("javax/swing")) {
                    return false;
                }
                if (name.equals("java/lang/Object")) break;
                fieldType = fieldClass.getSuperclassDescriptor();
            }
        }
        return true;
    }

    public void sawBranchTo(int pc) {
        if (this.state == 999) {
            this.state = 2;
        } else if (this.state != 10) {
            this.resetStateMachine();
        }
    }

    public void sawOpcode(int seen) {
        if (this.isReturn(seen) && this.state != 11 && this.target != -42) {
            this.resetStateMachine();
            return;
        }
        if (this.state > 1 && (this.getPC() >= this.target && this.target >= 0 || this.isReturn(seen) && this.target == -42)) {
            if ((this.state == 4 || this.state == 3 && !this.f.isVolatile()) && this.interestingDeep(this.f)) {
                boolean isDefaultAccess;
                int priority = 3;
                boolean bl = isDefaultAccess = (this.getMethod().getAccessFlags() & 7) == 0;
                if (this.getMethod().isPublic()) {
                    priority = 2;
                } else if (this.getMethod().isProtected() || isDefaultAccess) {
                    priority = 2;
                }
                String signature = this.f.getSignature();
                if (signature.startsWith("[") || signature.startsWith("Ljava/util/")) {
                    --priority;
                }
                if (!this.sawNew) {
                    ++priority;
                }
                if (this.state == 3 && priority < 3) {
                    priority = 3;
                }
                if (this.getXClass().usesConcurrency()) {
                    --priority;
                }
                this.bugReporter.reportBug(new BugInstance(this, this.state == 4 ? "LI_LAZY_INIT_UPDATE_STATIC" : "LI_LAZY_INIT_STATIC", priority).addClassAndMethod(this).addField(this.f).describe("FIELD_ON").addSourceLineRange(this.getClassContext(), this, this.startPC, this.getPC()));
            }
            this.resetStateMachine();
        }
        switch (this.state) {
            case 0: {
                if (seen != 178) break;
                XField xField = this.getXFieldOperand();
                if (xField == null) {
                    return;
                }
                if (!this.interestingQuick(xField)) break;
                this.state = 1;
                this.f = this.getXFieldOperand();
                this.sawNew = false;
                this.startPC = this.getPC();
                break;
            }
            case 1: {
                if (seen == 199) {
                    this.state = 999;
                    this.target = this.getBranchTarget();
                    break;
                }
                if (seen == 198) {
                    this.state = 10;
                    this.target = this.getBranchTarget();
                    break;
                }
                this.resetStateMachine();
                break;
            }
            case 2: {
                if (seen == 179) {
                    if (this.f.equals(this.getXFieldOperand())) {
                        this.state = 3;
                        break;
                    }
                    this.resetStateMachine();
                    break;
                }
                switch (seen) {
                    case 187: 
                    case 188: 
                    case 189: 
                    case 197: {
                        this.sawNew = true;
                        break;
                    }
                    case 184: {
                        if (!this.getNameConstantOperand().startsWith("new")) break;
                        this.sawNew = true;
                    }
                }
                break;
            }
            case 3: {
                if (seen != 178 || !this.f.equals(this.getXFieldOperand())) break;
                this.state = 4;
                break;
            }
            case 10: {
                if (seen != 178 || !this.f.equals(this.getXFieldOperand())) break;
                this.state = 11;
                break;
            }
            case 11: {
                if (this.isReturn(seen) && this.target == this.getPC() + 1) {
                    this.state = 2;
                    this.target = -42;
                    break;
                }
                this.resetStateMachine();
            }
        }
    }

    private void resetStateMachine() {
        this.state = 0;
        this.target = -1;
    }
}

