/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.text.MessageFormat;
import java.util.Properties;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;

public class PasteEnterNewNameSupport
extends SpecialWizardSupport {
    int returnCode = -1;
    XModelObject source;
    XModelObject copy;
    PasteValidator pasteValidator = new PasteValidator();

    public static int run(XModelObject parent, XModelObject source, XModelObject copy, XEntityData data) {
        PasteEnterNewNameSupport support = new PasteEnterNewNameSupport();
        Properties p = new Properties();
        p.put("source", source);
        p.put("copy", copy);
        support.setActionData(null, new XEntityData[]{data}, parent, p);
        parent.getModel().getService().showDialog(support);
        return support.getReturnCode();
    }

    public void reset() {
        this.returnCode = -1;
        this.source = (XModelObject)this.getProperties().get("source");
        this.copy = (XModelObject)this.getProperties().get("copy");
    }

    public String getTitle() {
        return MessageFormat.format("Paste {0} to {1}", PasteEnterNewNameSupport.getCapitalizedName(this.copy), PasteEnterNewNameSupport.getCapitalizedName(this.getTarget()));
    }

    public String getSubtitle() {
        return PasteEnterNewNameSupport.getCapitalizedName(this.copy);
    }

    static String getCapitalizedName(XModelObject o) {
        String n = o.getAttributeValue("element type");
        if (n == null || n.length() == 0) {
            n = o.getModelEntity().getXMLSubPath();
        }
        if (n == null || n.length() == 0) {
            n = o.getPathPart();
        }
        return WizardKeys.toDisplayName(n);
    }

    public String getMessage(int stepId) {
        String displayName = WizardKeys.getAttributeDisplayName(this.getEntityData()[0].getAttributeData()[0].getAttribute(), true);
        return MessageFormat.format("Please enter new {0}.", displayName);
    }

    public String[] getActionNames(int stepId) {
        return new String[]{OK, CANCEL};
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.returnCode = 0;
            this.setFinished(true);
        } else if (name.equals(CANCEL)) {
            this.returnCode = 1;
            this.setFinished(true);
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public WizardDataValidator getValidator(int step) {
        this.pasteValidator.setSupport(this, step);
        return this.pasteValidator;
    }

    class PasteValidator
    extends DefaultWizardDataValidator {
        PasteValidator() {
        }

        public void validate(Properties data) {
            super.validate(data);
            if (this.message != null) {
                return;
            }
            XAttributeData[] ad = PasteEnterNewNameSupport.this.getEntityData()[this.step].getAttributeData();
            int i = 0;
            while (i < ad.length) {
                String n = ad[i].getAttribute().getName();
                String v = data.getProperty(n);
                if (v != null) {
                    if (ad[i].getAttribute().isTrimmable()) {
                        v = v.trim();
                    }
                    PasteEnterNewNameSupport.this.copy.setAttributeValue(n, v);
                }
                ++i;
            }
            this.message = PasteEnterNewNameSupport.this.source.getPathPart().equals(PasteEnterNewNameSupport.this.copy.getPathPart()) ? this.support.getMessage(this.step) : DefaultCreateHandler.getContainsMessage(this.support.getTarget(), PasteEnterNewNameSupport.this.copy);
        }
    }
}

