/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaResourceLoader {
    public static Map<String, URL> getMetaResources() {
        HashMap<String, URL> resources = new HashMap<String, URL>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.jboss.tools.common.model.meta");
        IExtension[] es = point.getExtensions();
        int i = 0;
        while (i < es.length) {
            Bundle bundle = Platform.getBundle((String)es[i].getNamespaceIdentifier());
            IConfigurationElement[] elements = es[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String path = elements[j].getAttribute("path");
                if (path != null) {
                    if (resources.containsKey(path) && ModelPlugin.isDebugEnabled()) {
                        ModelPlugin.getPluginLog().logInfo("Warning: duplicate meta resource " + path + " ignored.");
                    }
                    try {
                        URL url = bundle.getResource(path);
                        if (url != null) {
                            resources.put(path, url);
                        } else if (ModelPlugin.isDebugEnabled()) {
                            ModelPlugin.getPluginLog().logInfo("Warning: meta resource " + path + " not found.");
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        ModelPlugin.getPluginLog().logError("MetaResourceLoader warning: meta resource " + path + " not found.");
                    }
                }
                ++j;
            }
            ++i;
        }
        return resources;
    }
}

