/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ForwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReturnInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockAnalysis
extends ForwardDataflowAnalysis<LockSet> {
    private static final boolean DEBUG = SystemProperties.getBoolean("la.debug");
    private MethodGen methodGen;
    private ValueNumberDataflow vnaDataflow;
    private ValueNumberAnalysis vna;
    private boolean isSynchronized;
    private boolean isStatic;

    public LockAnalysis(MethodGen methodGen, ValueNumberDataflow vnaDataflow, DepthFirstSearch dfs) {
        super(dfs);
        this.methodGen = methodGen;
        this.vnaDataflow = vnaDataflow;
        this.vna = (ValueNumberAnalysis)vnaDataflow.getAnalysis();
        this.isSynchronized = methodGen.isSynchronized();
        this.isStatic = methodGen.isStatic();
        if (DEBUG) {
            System.out.println("Analyzing Locks in " + methodGen.getClassName() + "." + methodGen.getName());
        }
    }

    @Override
    public LockSet createFact() {
        return new LockSet();
    }

    @Override
    public void copy(LockSet source, LockSet dest) {
        dest.copyFrom(source);
    }

    @Override
    public void initEntryFact(LockSet result) {
        result.clear();
        result.setDefaultLockCount(0);
        if (this.isSynchronized && !this.isStatic) {
            ValueNumber thisValue = this.vna.getThisValue();
            result.setLockCount(thisValue.getNumber(), 1);
        } else if (this.isSynchronized && this.isStatic) {
            ValueNumber thisValue = this.vna.getClassObjectValue(this.methodGen.getClassName());
            result.setLockCount(thisValue.getNumber(), 1);
        }
    }

    @Override
    public void makeFactTop(LockSet fact) {
        fact.clear();
        fact.setDefaultLockCount(-1);
    }

    @Override
    public boolean isTop(LockSet fact) {
        return fact.isTop();
    }

    @Override
    public boolean same(LockSet fact1, LockSet fact2) {
        return fact1.sameAs(fact2);
    }

    @Override
    public void meetInto(LockSet fact, Edge edge, LockSet result) throws DataflowAnalysisException {
        result.meetWith(fact);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, LockSet fact) throws DataflowAnalysisException {
        Instruction ins = handle.getInstruction();
        short opcode = ins.getOpcode();
        if (opcode == 194 || opcode == 195) {
            ValueNumberFrame frame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(new Location(handle, basicBlock));
            if (frame.isValid()) {
                int lockNumber = ((ValueNumber)frame.getTopValue()).getNumber();
                this.lockOp(fact, lockNumber, opcode == 194 ? 1 : -1);
            }
        } else if (ins instanceof ReturnInstruction && this.isSynchronized && !this.isStatic) {
            this.lockOp(fact, this.vna.getThisValue().getNumber(), -1);
        }
    }

    private void lockOp(LockSet fact, int lockNumber, int delta) {
        int value = fact.getLockCount(lockNumber);
        if (value < 0) {
            return;
        }
        if ((value += delta) < 0) {
            value = -2;
        }
        if (DEBUG) {
            System.out.println("Setting " + lockNumber + " to " + value + " in " + this.methodGen.getClassName() + "." + this.methodGen.getName());
        }
        fact.setLockCount(lockNumber, value);
    }

    @Override
    public boolean isFactValid(LockSet fact) {
        return true;
    }
}

