/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;

public class UseValueOfResolution
extends BugResolution {
    private static final String VALUE_OF_METHOD_NAME = "valueOf";
    private boolean staticImport = false;

    public UseValueOfResolution() {
    }

    public UseValueOfResolution(boolean staticImport) {
        this();
        this.staticImport = staticImport;
    }

    public boolean isStaticImport() {
        return this.staticImport;
    }

    public void setStaticImport(boolean staticImport) {
        this.staticImport = staticImport;
    }

    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        assert (rewrite != null);
        assert (workingUnit != null);
        ClassInstanceCreation primitiveTypeCreation = this.findPrimitiveTypeCreation(ASTUtil.getASTNode(workingUnit, bug.getPrimarySourceLineAnnotation()));
        if (primitiveTypeCreation == null) {
            throw new BugResolutionException("Primitive type creation not found.");
        }
        MethodInvocation valueOfInvocation = this.createValueOfInvocation(rewrite, workingUnit, primitiveTypeCreation);
        rewrite.replace((ASTNode)primitiveTypeCreation, (ASTNode)valueOfInvocation, null);
    }

    @CheckForNull
    protected ClassInstanceCreation findPrimitiveTypeCreation(ASTNode node) {
        PrimitiveTypeCreationFinder visitor = new PrimitiveTypeCreationFinder();
        node.accept((ASTVisitor)visitor);
        return visitor.getPrimitiveTypeCreation();
    }

    protected MethodInvocation createValueOfInvocation(ASTRewrite rewrite, CompilationUnit compilationUnit, ClassInstanceCreation primitiveTypeCreation) {
        assert (rewrite != null);
        assert (primitiveTypeCreation != null);
        AST ast = rewrite.getAST();
        MethodInvocation valueOfInvocation = ast.newMethodInvocation();
        valueOfInvocation.setName(ast.newSimpleName(VALUE_OF_METHOD_NAME));
        ITypeBinding binding = primitiveTypeCreation.getType().resolveBinding();
        if (this.isStaticImport()) {
            ASTUtil.addStaticImports(rewrite, compilationUnit, binding.getQualifiedName() + "." + VALUE_OF_METHOD_NAME);
        } else {
            valueOfInvocation.setExpression((Expression)ast.newSimpleName(binding.getName()));
        }
        List arguments = primitiveTypeCreation.arguments();
        List newArguments = valueOfInvocation.arguments();
        for (Object argument : arguments) {
            Expression expression = (Expression)rewrite.createCopyTarget((ASTNode)argument);
            newArguments.add(expression);
        }
        return valueOfInvocation;
    }

    protected boolean resolveBindings() {
        return true;
    }

    protected static class PrimitiveTypeCreationFinder
    extends ASTVisitor {
        private ClassInstanceCreation primitiveTypeCreation = null;

        protected PrimitiveTypeCreationFinder() {
        }

        public boolean visit(ClassInstanceCreation node) {
            if (this.primitiveTypeCreation == null) {
                if (!this.isPrimitiveTypeCreation(node)) {
                    return true;
                }
                this.primitiveTypeCreation = node;
            }
            return false;
        }

        public ClassInstanceCreation getPrimitiveTypeCreation() {
            return this.primitiveTypeCreation;
        }

        private boolean isPrimitiveTypeCreation(ClassInstanceCreation primitiveTypeCreation) {
            return true;
        }
    }
}

