/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers.refactoring;

import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.refactoring.RefactoringHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.handlers.page.RenamePageHandler;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;

public class StrutsRenamePageStrutsConfigChange
extends CompositeChange {
    XModelObject object;
    String newName;
    XModelObject[] fs;
    String oldPath;
    String newPath;
    Properties replacements = new Properties();

    public StrutsRenamePageStrutsConfigChange(XModelObject object, String newName) {
        super(StrutsUIMessages.STRUTS_CONFIG_CHANGES);
        this.object = object;
        this.newName = newName;
        this.replacements.clear();
        this.oldPath = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
        int i = this.oldPath.lastIndexOf("/");
        this.newPath = String.valueOf(this.oldPath.substring(0, i + 1)) + newName;
        String oldText = "\"" + this.oldPath + "\"";
        String newText = "\"" + this.newPath + "\"";
        this.replacements.setProperty(oldText, newText);
        try {
            this.addChanges();
        }
        catch (Exception e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private void addChanges() throws Exception {
        if (this.object == null) {
            return;
        }
        this.fs = WebModulesHelper.getInstance(this.object.getModel()).getAllConfigs();
        this.addChanges(this.fs);
    }

    private void addChanges(XModelObject[] objects) {
        int i = 0;
        while (i < objects.length) {
            RefactoringHelper.addChanges((XModelObject)objects[i], (Properties)this.replacements, (CompositeChange)this);
            ++i;
        }
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.fs == null) {
            return null;
        }
        XModelObject parent = this.object.getParent();
        if (parent instanceof FolderImpl) {
            ((FolderImpl)parent).update();
        }
        int i = 0;
        while (i < this.fs.length) {
            try {
                StrutsRenamePageStrutsConfigChange.onPageRename(this.fs[i], this.oldPath, this.newPath);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.struts", 0, e.getMessage(), (Throwable)e));
            }
            ++i;
        }
        i = 0;
        while (i < this.fs.length) {
            if (this.fs[i].isModified()) {
                XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)this.fs[i], null);
            }
            ++i;
        }
        return null;
    }

    static void onPageRename(XModelObject config, String oldpath, String path) throws Exception {
        XModelObject process = StrutsProcessStructureHelper.instance.getProcess(config);
        if (process == null) {
            return;
        }
        XModelObject page = StrutsRenamePageStrutsConfigChange.findPage(process, oldpath);
        if (page != null) {
            StrutsProcessHelper.getHelper(page.getParent()).resetPage(page, oldpath, path);
            page.getModel().changeObjectAttribute(page, "path", path);
        }
        RenamePageHandler.changeMatchingAttributesInHierarhy(config, oldpath, path);
    }

    static XModelObject findPage(XModelObject process, String oldpath) {
        XModelObject[] items = process.getChildren();
        int i = 0;
        while (i < items.length) {
            if (!"forward".equals(items[i].getAttributeValue("type")) && oldpath.equals(items[i].getAttributeValue("path"))) {
                return items[i];
            }
            ++i;
        }
        return null;
    }
}

