/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers;

import java.util.HashSet;
import java.util.Set;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.jst.web.tiles.model.helpers.ITilesDefinitionSetContributor;
import org.jboss.tools.struts.model.helpers.TilesHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesContributor
implements ITilesDefinitionSetContributor {
    public Set<XModelObject> getTileFiles(XModel model) {
        XModelObject[] cs = WebModulesHelper.getInstance(model).getAllConfigs();
        HashSet<XModelObject> set = new HashSet<XModelObject>();
        int i = 0;
        while (i < cs.length) {
            this.collectTileFiles(set, cs[i]);
            ++i;
        }
        return set;
    }

    private void collectTileFiles(Set<XModelObject> set, XModelObject strutsconfig) {
        XModelObject plugin = TilesHelper.getTilesPlugin(strutsconfig);
        XModelObject dc = TilesHelper.getDefinitionsConfig(plugin);
        TilesContributor.collectTileFilesFromTilesConfig(set, dc);
    }

    private static void collectTileFilesFromTilesConfig(Set<XModelObject> set, XModelObject cg) {
        String[] fs = TilesHelper.getTileFileNames(cg);
        if (cg != null) {
            int i = 0;
            while (i < fs.length) {
                XModelObject tilesdef = TilesHelper.findTilesFile(cg.getModel(), fs[i]);
                if (tilesdef != null) {
                    set.add(tilesdef);
                }
                ++i;
            }
        }
    }

    public boolean isRelevant(XModelTreeEvent event) {
        XModelObject source = event.getModelObject();
        String sourceEntity = source.getModelEntity().getName();
        if (sourceEntity.startsWith("WebApp")) {
            return true;
        }
        if (event.kind() == 1) {
            XModelObject a = (XModelObject)event.getInfo();
            String addedEntity = a.getModelEntity().getName();
            if (addedEntity.equals("TilesDefinition")) {
                return true;
            }
            if (addedEntity.startsWith("StrutsConfig")) {
                return true;
            }
            if (addedEntity.equals("FileTiles")) {
                return true;
            }
        } else if (event.kind() == 2) {
            if (sourceEntity.equals("FileTiles")) {
                return true;
            }
        } else if (event.kind() == 0) {
            if (sourceEntity.startsWith("StrutsPlugin")) {
                return true;
            }
            if (sourceEntity.equals("TilesDefinition")) {
                return true;
            }
        }
        return false;
    }
}

