/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.pattern;

import java.util.Set;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostfixUrlPattern
implements UrlPattern {
    protected String postfix = ".do";

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    @Override
    public boolean isActionUrl(String path) {
        return path.endsWith(this.postfix) || path.indexOf(".") < 0;
    }

    @Override
    public String getActionPath(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        return url.endsWith(this.postfix) ? url.substring(0, url.length() - this.postfix.length()) : url;
    }

    @Override
    public String getActionUrl(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (!path.endsWith(this.postfix)) {
            path = String.valueOf(path) + this.postfix;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    @Override
    public String getModule(String path, Set<String> modules, String thisModule) {
        if (path == null || path.length() < 2 || path.startsWith("//")) {
            return "";
        }
        int i = path.indexOf("/", 1);
        if (i < 0) {
            return thisModule;
        }
        String m = path.substring(0, i);
        return modules.contains(m) ? m : thisModule;
    }

    @Override
    public String getContextRelativePath(String path, String module) {
        return path == null || module.length() == 0 || path.startsWith(module) ? path : String.valueOf(module) + path;
    }

    @Override
    public String getModuleRelativePath(String path, String module) {
        return path == null || module.length() == 0 || !path.startsWith(String.valueOf(module) + "/") ? path : path.substring(module.length());
    }

    public String toString() {
        return "PostfixUrlPattern:" + this.postfix;
    }
}

