/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.osgi.util.NLS;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public class LaunchHelper {
    public static ILaunchConfiguration findHibernateLaunchConfig(String name) throws CoreException {
        return LaunchHelper.findLaunchConfigurationByName("org.hibernate.eclipse.launch.ConsoleConfigurationLaunchConfigurationType", name);
    }

    public static ILaunchConfiguration[] findFilteredHibernateLaunchConfigs() throws CoreException {
        ILaunchConfiguration[] allHibernateLaunchConfigurations = LaunchHelper.findHibernateLaunchConfigs();
        ArrayList<ILaunchConfiguration> launchConfigurations = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = allHibernateLaunchConfigurations;
        int n = allHibernateLaunchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (DebugUIPlugin.doLaunchConfigurationFiltering((ILaunchConfiguration)config)) {
                launchConfigurations.add(config);
            }
            ++n2;
        }
        return launchConfigurations.toArray(new ILaunchConfiguration[launchConfigurations.size()]);
    }

    public static ConsoleConfiguration[] findFilteredSortedConsoleConfigs() {
        ConsoleConfiguration[] ccs = KnownConfigurations.getInstance().getConfigurationsSortedByName();
        ArrayList<ConsoleConfiguration> consoleConfigurations = new ArrayList<ConsoleConfiguration>();
        ConsoleConfiguration[] consoleConfigurationArray = ccs;
        int n = ccs.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleConfiguration cc = consoleConfigurationArray[n2];
            boolean isAccepted = true;
            try {
                ILaunchConfiguration config = LaunchHelper.findHibernateLaunchConfig(cc.getName());
                if (config != null) {
                    isAccepted = DebugUIPlugin.doLaunchConfigurationFiltering((ILaunchConfiguration)config);
                }
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().showError(null, e.getLocalizedMessage(), e);
            }
            if (isAccepted) {
                consoleConfigurations.add(cc);
            }
            ++n2;
        }
        return consoleConfigurations.toArray(new ConsoleConfiguration[consoleConfigurations.size()]);
    }

    public static ILaunchConfigurationType getHibernateLaunchConfigsType() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager.getLaunchConfigurationType("org.hibernate.eclipse.launch.ConsoleConfigurationLaunchConfigurationType");
    }

    public static ILaunchConfiguration[] findHibernateLaunchConfigs() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager.getLaunchConfigurations(LaunchHelper.getHibernateLaunchConfigsType());
    }

    public static ILaunchConfiguration findLaunchConfigurationByName(String launchConfigurationTypeId, String name) throws CoreException {
        Assert.isNotNull((Object)launchConfigurationTypeId, (String)HibernateConsoleMessages.LaunchHelper_launch_cfg_type_cannot_be_null);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(launchConfigurationTypeId);
        ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(launchConfigurationType);
        int i = 0;
        while (i < launchConfigurations.length) {
            ILaunchConfiguration launchConfiguration = launchConfigurations[i];
            if (launchConfiguration.getName().equals(name)) {
                return launchConfiguration;
            }
            ++i;
        }
        return null;
    }

    public static ILaunchConfiguration[] findProjectRelatedHibernateLaunchConfigs(String projectName) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(LaunchHelper.getHibernateLaunchConfigsType());
        ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
        int i = 0;
        while (i < configs.length && configs[i].exists()) {
            String project = configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (projectName.equals(project)) {
                list.add(configs[i]);
            }
            ++i;
        }
        return list.toArray(new ILaunchConfiguration[list.size()]);
    }

    public static String verifyConfigurationName(String currentName) {
        int i;
        if (currentName == null || currentName.length() < 1) {
            return HibernateConsoleMessages.ConsoleConfigurationWizardPage_name_must_specified;
        }
        if ("win32".equals(Platform.getOS())) {
            String[] badnames = new String[]{"aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
            i = 0;
            while (i < badnames.length) {
                if (currentName.equals(badnames[i])) {
                    return NLS.bind((String)HibernateConsoleMessages.ConsoleConfigurationWizardPage_bad_name, (Object)currentName);
                }
                ++i;
            }
        }
        char[] cArray = new char[12];
        cArray[0] = 64;
        cArray[1] = 38;
        cArray[2] = 92;
        cArray[3] = 47;
        cArray[4] = 58;
        cArray[5] = 42;
        cArray[6] = 63;
        cArray[7] = 34;
        cArray[8] = 60;
        cArray[9] = 62;
        cArray[10] = 124;
        char[] disallowedChars = cArray;
        i = 0;
        while (i < disallowedChars.length) {
            char c = disallowedChars[i];
            if (currentName.indexOf(c) > -1) {
                return NLS.bind((String)HibernateConsoleMessages.ConsoleConfigurationWizardPage_bad_char, (Object)Character.valueOf(c));
            }
            ++i;
        }
        if (LaunchHelper.existingLaunchConfiguration(currentName)) {
            return HibernateConsoleMessages.ConsoleConfigurationWizardPage_config_name_already_exist;
        }
        return null;
    }

    public static boolean existingLaunchConfiguration(String name) {
        try {
            ILaunchConfiguration config = LaunchHelper.findHibernateLaunchConfig(name);
            if (config != null && !config.getAttribute("_TEMPORARY_CONFIG_", false) && name.equalsIgnoreCase(config.getName())) {
                return true;
            }
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage(e.getMessage(), e);
        }
        return false;
    }

    public static ILaunchConfiguration[] filterCodeGenerationConfigs(ILaunchConfiguration[] launchConfigs) throws CoreException {
        ArrayList<ILaunchConfiguration> res = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigs;
        int n = launchConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (DebugUIPlugin.doLaunchConfigurationFiltering((ILaunchConfiguration)config)) {
                res.add(config);
            }
            ++n2;
        }
        return res.toArray(new ILaunchConfiguration[res.size()]);
    }

    public static ILaunchConfiguration[] findFilteredCodeGenerationConfigs() throws CoreException {
        return LaunchHelper.filterCodeGenerationConfigs(LaunchHelper.findCodeGenerationConfigs());
    }

    public static ILaunchConfiguration[] findFilteredCodeGenerationConfigsSorted() throws CoreException {
        return LaunchHelper.filterCodeGenerationConfigs(LaunchHelper.findCodeGenerationConfigsSortedByName());
    }

    public static ILaunchConfiguration[] findCodeGenerationConfigs() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager.getLaunchConfigurations(LaunchHelper.getCodeGenerationType());
    }

    public static ILaunchConfiguration[] findCodeGenerationConfigsSortedByName() throws CoreException {
        ILaunchConfiguration[] launchConfigs = LaunchHelper.findCodeGenerationConfigs();
        Comparator<ILaunchConfiguration> comparator = new Comparator<ILaunchConfiguration>(){

            @Override
            public int compare(ILaunchConfiguration o1, ILaunchConfiguration o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Arrays.sort(launchConfigs, comparator);
        return launchConfigs;
    }

    public static ILaunchConfigurationType getCodeGenerationType() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager.getLaunchConfigurationType("org.hibernate.eclipse.launch.CodeGenerationLaunchConfigurationType");
    }
}

