/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.hibernate.eclipse.graph.layout.GraphAnimation;
import org.hibernate.eclipse.graph.layout.NodeJoiningDirectedGraphLayout;
import org.hibernate.eclipse.graph.parts.AssociationEditPart;
import org.hibernate.eclipse.graph.parts.ConfigurationEditPart;
import org.hibernate.eclipse.graph.parts.PersistentClassEditPart;

public class DirectedGraphLayoutVisitor {
    Map<AbstractGraphicalEditPart, Object> partToNodesMap;
    Set<AssociationEditPart> addedAssociations;
    DirectedGraph graph;
    private ConfigurationEditPart diagram;

    public void layoutDiagram(ConfigurationEditPart diagram) {
        this.partToNodesMap = new HashMap<AbstractGraphicalEditPart, Object>();
        this.addedAssociations = new HashSet<AssociationEditPart>();
        this.diagram = diagram;
        this.graph = new DirectedGraph();
        this.addNodes(diagram);
        if (this.graph.nodes.size() > 0) {
            this.addEdges(diagram);
            new NodeJoiningDirectedGraphLayout().visit(this.graph);
            this.applyResults(diagram);
        }
    }

    protected void addNodes(ConfigurationEditPart diagram) {
        GraphAnimation.recordInitialState(diagram.getFigure());
        diagram.getFigure();
        int i = 0;
        while (i < diagram.getChildren().size()) {
            PersistentClassEditPart tp = (PersistentClassEditPart)diagram.getChildren().get(i);
            this.addNodes(tp);
            ++i;
        }
    }

    protected void addNodes(PersistentClassEditPart pClassPart) {
        Node n = new Node((Object)pClassPart);
        n.width = pClassPart.getFigure().getPreferredSize((int)400, (int)300).width;
        n.height = pClassPart.getFigure().getPreferredSize((int)400, (int)300).height;
        n.setPadding(new Insets(50));
        this.partToNodesMap.put(pClassPart, n);
        this.graph.nodes.add((Object)n);
    }

    protected void addEdges(ConfigurationEditPart diagram) {
        int i = 0;
        while (i < diagram.getChildren().size()) {
            PersistentClassEditPart classPart = (PersistentClassEditPart)diagram.getChildren().get(i);
            this.addEdges(classPart);
            ++i;
        }
    }

    protected void addEdges(PersistentClassEditPart classPart) {
        List outgoing = classPart.getSourceConnections();
        for (AssociationEditPart relationshipPart : outgoing) {
            this.addEdges(relationshipPart);
        }
    }

    protected void addEdges(AssociationEditPart relationshipPart) {
        GraphAnimation.recordInitialState((Connection)relationshipPart.getFigure());
        Node source = (Node)this.partToNodesMap.get(relationshipPart.getSource());
        Node target = (Node)this.partToNodesMap.get(relationshipPart.getTarget());
        if (source == target) {
            return;
        }
        if (source == null || target == null) {
            return;
        }
        Edge e = new Edge((Object)relationshipPart, source, target);
        e.weight = 2;
        this.graph.edges.add((Object)e);
        this.partToNodesMap.put((AbstractGraphicalEditPart)relationshipPart, e);
    }

    protected void applyResults(ConfigurationEditPart diagram) {
        this.applyChildrenResults(diagram);
    }

    protected void applyChildrenResults(ConfigurationEditPart diagram) {
        int i = 0;
        while (i < diagram.getChildren().size()) {
            PersistentClassEditPart pClassPart = (PersistentClassEditPart)diagram.getChildren().get(i);
            this.applyResults(pClassPart);
            ++i;
        }
    }

    protected void applyOwnResults(ConfigurationEditPart diagram) {
    }

    public void applyResults(PersistentClassEditPart pClassPart) {
        Node n = (Node)this.partToNodesMap.get(pClassPart);
        Figure classFigure = (Figure)pClassPart.getFigure();
        Rectangle bounds = new Rectangle(n.y, n.x, classFigure.getPreferredSize().width, classFigure.getPreferredSize().height);
        classFigure.setBounds(bounds);
        int i = 0;
        while (i < pClassPart.getSourceConnections().size()) {
            AssociationEditPart relationship = (AssociationEditPart)((Object)pClassPart.getSourceConnections().get(i));
            this.applyResults(relationship);
            ++i;
        }
    }

    protected void applyResults(AssociationEditPart relationshipPart) {
        Edge e = (Edge)this.partToNodesMap.get((Object)relationshipPart);
        PolylineConnection conn = (PolylineConnection)relationshipPart.getConnectionFigure();
        if (e == null) {
            return;
        }
        NodeList nodes = e.vNodes;
        if (nodes != null) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < nodes.size()) {
                Node vn = nodes.getNode(i);
                int x = vn.x;
                int y = vn.y;
                if (e.isFeedback) {
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                    bends.add(new AbsoluteBendpoint(x, y));
                } else {
                    bends.add(new AbsoluteBendpoint(x, y));
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                }
                ++i;
            }
            conn.setRoutingConstraint(bends);
        } else {
            conn.setRoutingConstraint((Object)Collections.EMPTY_LIST);
        }
    }
}

