/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.actions.ViolationSelectionAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.MarkerResolutionSelectionDialog;
import org.eclipse.ui.ide.IDE;

public class QuickFixAction
extends ViolationSelectionAction {
    public QuickFixAction(TableViewer tableViewer) {
        super(tableViewer);
        this.setImageDescriptor(PMDPlugin.getImageDescriptor("icons/btn_quickfix.gif"));
        this.setText(PMDPlugin.getDefault().getStringTable().getString("view.action.quickfix"));
        this.setToolTipText(PMDPlugin.getDefault().getStringTable().getString("view.tooltip.quickfix"));
    }

    public boolean hasQuickFix() {
        boolean bl = false;
        IMarker[] iMarkerArray = this.getSelectedViolations();
        if (iMarkerArray != null && iMarkerArray.length == 1) {
            bl = IDE.getMarkerHelpRegistry().hasResolutions(iMarkerArray[0]);
        }
        return bl;
    }

    public void run() {
        Object[] objectArray;
        MarkerResolutionSelectionDialog markerResolutionSelectionDialog;
        IMarker[] iMarkerArray = this.getSelectedViolations();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IMarkerResolution[] iMarkerResolutionArray = IDE.getMarkerHelpRegistry().getResolutions(iMarkerArray[0]);
        if (iMarkerResolutionArray.length != 0 && (markerResolutionSelectionDialog = new MarkerResolutionSelectionDialog(iWorkbench.getActiveWorkbenchWindow().getShell(), iMarkerResolutionArray)).open() == 0 && (objectArray = markerResolutionSelectionDialog.getResult()) != null && objectArray.length > 0) {
            IMarkerResolution iMarkerResolution = (IMarkerResolution)objectArray[0];
            iMarkerResolution.run(iMarkerArray[0]);
        }
    }
}

