/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.eclipse.console.model.IRevEngColumn;
import org.hibernate.eclipse.console.model.IRevEngGenerator;
import org.hibernate.eclipse.console.model.IRevEngParameter;
import org.hibernate.eclipse.console.model.IRevEngPrimaryKey;
import org.hibernate.eclipse.console.model.IRevEngTable;
import org.hibernate.eclipse.console.model.IReverseEngineeringDefinition;
import org.hibernate.eclipse.console.workbench.DeferredContentProvider;
import org.hibernate.eclipse.console.workbench.LazyDatabaseSchema;
import org.hibernate.eclipse.console.workbench.xpl.AnyAdaptableLabelProvider;
import org.hibernate.eclipse.mapper.MapperMessages;
import org.hibernate.eclipse.mapper.editors.ReverseEngineeringEditor;
import org.hibernate.eclipse.mapper.editors.reveng.ColumnDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.GeneratorDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.ParamDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.PrimaryKeyDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.TableDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.TablePropertiesContentProvider;
import org.hibernate.eclipse.mapper.editors.reveng.TablePropertiesLabelProvider;
import org.hibernate.eclipse.mapper.editors.reveng.xpl.CheckedTreeSelectionDialog;
import org.hibernate.eclipse.mapper.model.RevEngColumnAdapter;
import org.hibernate.eclipse.mapper.model.RevEngGeneratorAdapter;
import org.hibernate.eclipse.mapper.model.RevEngParamAdapter;
import org.hibernate.eclipse.mapper.model.RevEngPrimaryKeyAdapter;
import org.hibernate.eclipse.mapper.model.RevEngTableAdapter;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;

public class TablePropertiesBlock
extends MasterDetailsBlock {
    private TreeViewer viewer;
    private final ReverseEngineeringEditor editor;

    public TablePropertiesBlock(ReverseEngineeringEditor editor) {
        this.editor = editor;
    }

    public SashForm getComposite() {
        return this.sashForm;
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 202);
        section.setText(MapperMessages.TablePropertiesBlock_tables_columns);
        section.setDescription(MapperMessages.TablePropertiesBlock_explicitly_control_settings_for_table_columns);
        section.marginWidth = 10;
        section.marginHeight = 5;
        toolkit.createCompositeSeparator((Composite)section);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        client.setLayout((Layout)layout);
        Tree t = toolkit.createTree(client, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        gd.verticalSpan = 2;
        t.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        Button btnAdd = toolkit.createButton(client, MapperMessages.TablePropertiesBlock_add, 8);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TablePropertiesBlock.this.doAdd();
            }
        });
        gd = new GridData(2);
        btnAdd.setLayoutData((Object)gd);
        Button btnDel = toolkit.createButton(client, MapperMessages.TablePropertiesBlock_delete, 8);
        btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TablePropertiesBlock.this.doDelete();
            }
        });
        gd = new GridData(2);
        btnDel.setLayoutData((Object)gd);
        section.setClient((Control)client);
        final SectionPart spart = new SectionPart(section){

            public boolean setFormInput(Object input) {
                if (input instanceof IReverseEngineeringDefinition) {
                    TablePropertiesBlock.this.viewer.setInput(input);
                    return true;
                }
                return false;
            }
        };
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TreeViewer(t);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new TablePropertiesLabelProvider());
        TablePropertiesContentProvider tablePropertiesContentProvider = new TablePropertiesContentProvider();
        this.viewer.setContentProvider((IContentProvider)tablePropertiesContentProvider);
    }

    protected void doAdd() {
        CheckedTreeSelectionDialog dialog = this.createTreeSelectionDialog();
        LazyDatabaseSchema lds = this.editor.getLazyDatabaseSchema();
        HashMap<TableIdentifier, Object> tables = new HashMap<TableIdentifier, Object>();
        HashMap<TableIdentifier, ArrayList<Object>> columns = new HashMap<TableIdentifier, ArrayList<Object>>();
        if (lds == null) {
            String tableName = "";
            String namePrefix = "TABLE_";
            IRevEngTable retable = this.editor.getReverseEngineeringDefinition().createTable();
            retable.setCatalog("");
            retable.setSchema("");
            TreeSet<String> ts = new TreeSet<String>();
            IRevEngTable[] retables = this.editor.getReverseEngineeringDefinition().getTables();
            char separartor = '%';
            int i = 0;
            while (i < retables.length) {
                ts.add(String.valueOf(retables[i].getCatalog()) + separartor + retables[i].getSchema() + separartor + retables[i].getName());
                ++i;
            }
            String strCatalogSchema = String.valueOf(retable.getCatalog()) + separartor + retable.getSchema() + separartor;
            int i2 = 0;
            do {
                tableName = String.valueOf(namePrefix) + i2++;
            } while (ts.contains(String.valueOf(strCatalogSchema) + tableName));
            retable.setName(tableName);
            this.editor.getReverseEngineeringDefinition().addTable(retable);
        } else {
            Table table;
            dialog.setTitle(MapperMessages.TablePropertiesBlock_add_tables_columns);
            dialog.setMessage(MapperMessages.TablePropertiesBlock_select_tables_columns);
            dialog.setInput(lds);
            dialog.setContainerMode(true);
            dialog.open();
            Object[] result = dialog.getResult();
            TableIdentifier lastTable = null;
            if (result != null) {
                int i = 0;
                while (i < result.length) {
                    List<Object> existing;
                    Object object = result[i];
                    if (object instanceof Table) {
                        table = (Table)object;
                        tables.put(TableIdentifier.create((Table)table), object);
                        lastTable = TableIdentifier.create((Table)table);
                    } else if (object instanceof Column) {
                        existing = (ArrayList<Object>)columns.get(lastTable);
                        if (existing == null) {
                            existing = new ArrayList<Object>();
                            columns.put(lastTable, (ArrayList<Object>)existing);
                        }
                        existing.add(object);
                    } else if (object instanceof PrimaryKey) {
                        existing = (List)columns.get(lastTable);
                        if (existing == null) {
                            existing = new ArrayList();
                            columns.put(lastTable, (ArrayList<Object>)existing);
                        }
                        existing.addAll(((PrimaryKey)object).getColumns());
                    }
                    ++i;
                }
            }
            for (Map.Entry element : tables.entrySet()) {
                table = (Table)element.getValue();
                IRevEngTable retable = null;
                retable = this.editor.getReverseEngineeringDefinition().createTable();
                retable.setCatalog(table.getCatalog());
                retable.setSchema(table.getSchema());
                retable.setName(table.getName());
                this.editor.getReverseEngineeringDefinition().addTable(retable);
                List columnList = (List)columns.get(element.getKey());
                if (columnList == null) continue;
                for (Column column : columnList) {
                    IRevEngColumn revCol = this.editor.getReverseEngineeringDefinition().createColumn();
                    revCol.setName(column.getName());
                    if (column.getSqlType() != null) {
                        revCol.setJDBCType(column.getSqlType());
                    }
                    retable.addColumn(revCol);
                }
            }
        }
    }

    protected void doDelete() {
        TreeItem[] treeItems;
        ISelection sel = this.viewer.getSelection();
        if (sel.isEmpty() || !(sel instanceof TreeSelection)) {
            return;
        }
        boolean updateSelection = false;
        TreeSelection ts = (TreeSelection)sel;
        List list = ts.toList();
        for (Object obj : list) {
            if (obj instanceof IRevEngTable) {
                IRevEngTable retable = (IRevEngTable)obj;
                if (retable instanceof RevEngTableAdapter) {
                    updateSelection = true;
                }
                this.editor.getReverseEngineeringDefinition().removeTable(retable);
                continue;
            }
            if (obj instanceof IRevEngColumn) {
                IRevEngColumn recolumn = (IRevEngColumn)obj;
                if (recolumn instanceof RevEngColumnAdapter) {
                    updateSelection = true;
                }
                this.editor.getReverseEngineeringDefinition().removeColumn(recolumn);
                continue;
            }
            if (obj instanceof IRevEngPrimaryKey) {
                IRevEngPrimaryKey reprimaryKey = (IRevEngPrimaryKey)obj;
                if (reprimaryKey instanceof RevEngPrimaryKeyAdapter) {
                    updateSelection = true;
                }
                this.editor.getReverseEngineeringDefinition().removePrimaryKey(reprimaryKey);
                continue;
            }
            if (obj instanceof IRevEngGenerator) {
                IRevEngGenerator regenerator = (IRevEngGenerator)obj;
                if (regenerator instanceof RevEngGeneratorAdapter) {
                    updateSelection = true;
                }
                this.editor.getReverseEngineeringDefinition().removeGenerator(regenerator);
                continue;
            }
            if (!(obj instanceof IRevEngParameter)) continue;
            IRevEngParameter reparam = (IRevEngParameter)obj;
            if (reparam instanceof RevEngParamAdapter) {
                updateSelection = true;
            }
            this.editor.getReverseEngineeringDefinition().removeParameter(reparam);
        }
        if (updateSelection && (treeItems = this.viewer.getTree().getItems()).length > 0) {
            this.viewer.getTree().setSelection(treeItems[0]);
        }
    }

    private CheckedTreeSelectionDialog createTreeSelectionDialog() {
        return new CheckedTreeSelectionDialog(this.getComposite().getShell(), (ILabelProvider)new AnyAdaptableLabelProvider(), (ITreeContentProvider)new DeferredContentProvider()){

            protected Composite createSelectionButtons(Composite composite) {
                Composite buttonComposite = new Composite(composite, 131072);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                buttonComposite.setLayout((Layout)layout);
                buttonComposite.setFont(composite.getFont());
                GridData data = new GridData(640);
                data.grabExcessHorizontalSpace = true;
                composite.setData((Object)data);
                Button selectButton = this.createButton(buttonComposite, 18, MapperMessages.TablePropertiesBlock_select_all_children, false);
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IStructuredSelection viewerElements = (IStructuredSelection)this.getTreeViewer().getSelection();
                        Iterator iterator = viewerElements.iterator();
                        while (iterator.hasNext()) {
                            this.getTreeViewer().setSubtreeChecked(iterator.next(), true);
                        }
                        this.updateOKStatus();
                    }
                };
                selectButton.addSelectionListener((SelectionListener)listener);
                Button deselectButton = this.createButton(buttonComposite, 19, MapperMessages.TablePropertiesBlock_deselect_all, false);
                listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.getTreeViewer().setCheckedElements(new Object[0]);
                        this.updateOKStatus();
                    }
                };
                deselectButton.addSelectionListener((SelectionListener)listener);
                return buttonComposite;
            }

            protected boolean evaluateIfTreeEmpty(Object input) {
                return false;
            }
        };
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        Action haction = new Action("hor", 8){

            public void run() {
                TablePropertiesBlock.this.sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        haction.setChecked(true);
        haction.setToolTipText(MapperMessages.TablePropertiesBlock_horizontal_orientation);
        Action vaction = new Action("ver", 8){

            public void run() {
                TablePropertiesBlock.this.sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        vaction.setChecked(false);
        vaction.setToolTipText(MapperMessages.TablePropertiesBlock_vertical_orientation);
        form.getToolBarManager().add((IAction)haction);
        form.getToolBarManager().add((IAction)vaction);
    }

    protected void registerPages(DetailsPart dp) {
        dp.registerPage(RevEngColumnAdapter.class, (IDetailsPage)new ColumnDetailsPage());
        dp.registerPage(RevEngTableAdapter.class, (IDetailsPage)new TableDetailsPage());
        dp.registerPage(RevEngGeneratorAdapter.class, (IDetailsPage)new GeneratorDetailsPage());
        dp.registerPage(RevEngParamAdapter.class, (IDetailsPage)new ParamDetailsPage());
        dp.registerPage(RevEngPrimaryKeyAdapter.class, (IDetailsPage)new PrimaryKeyDetailsPage());
    }
}

