/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.extractor;

import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.hibernate.eclipse.hqleditor.CompletionHelper;
import org.hibernate.eclipse.hqleditor.HibernateResultCollector;
import org.hibernate.eclipse.mapper.extractor.HBMInfoExtractor;
import org.hibernate.eclipse.mapper.extractor.HBMInfoHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

class FieldPropertyHandler
implements HBMInfoHandler {
    private final HBMInfoExtractor extractor;

    FieldPropertyHandler(HBMInfoExtractor extractor) {
        this.extractor = extractor;
    }

    public ICompletionProposal[] attributeCompletionProposals(IJavaProject project, Node node, String attributeName, String start, int offset) {
        if (project != null) {
            Node parentNode = node.getParentNode();
            String typename = null;
            typename = this.extractor.getNearestType(project, parentNode);
            if (typename == null) {
                return new IJavaCompletionProposal[0];
            }
            HibernateResultCollector rc = null;
            try {
                IType type = project.findType(typename);
                if (type == null) {
                    return new ICompletionProposal[0];
                }
                rc = new HibernateResultCollector(project);
                rc.acceptContext(new CompletionContext());
                rc.setAccepts(false, false, false, false, true, false);
                type.codeComplete(start.toCharArray(), -1, start.length(), new char[0][0], new char[0][0], new int[0], false, (CompletionRequestor)rc);
            }
            catch (JavaModelException javaModelException) {}
            IJavaCompletionProposal[] results = rc.getJavaCompletionProposals();
            CompletionHelper.transpose((String)start, (int)offset, (IJavaCompletionProposal[])results);
            return results;
        }
        return new ICompletionProposal[0];
    }

    public IJavaElement getJavaElement(IJavaProject project, Node currentNode, Attr currentAttrNode) {
        IType type = this.extractor.getNearestTypeJavaElement(project, currentNode.getParentNode());
        if (type != null) {
            IField field = type.getField(currentAttrNode.getValue());
            return field;
        }
        return null;
    }
}

