/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.undo.XRemoveUndo;
import org.jboss.tools.common.model.undo.XUndoManager;

public class DefaultRemoveHandler
extends AbstractHandler {
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        if (!this.isUniqueRequiredChild(object)) {
            DefaultRemoveHandler.removeFromParent(object);
        } else {
            this.cleanUniqueRequiredChild(object);
        }
    }

    public boolean getSignificantFlag(XModelObject object) {
        return true;
    }

    public boolean isEnabled(XModelObject object) {
        if (object == null || !object.isObjectEditable()) {
            return false;
        }
        if ("yes".equals(object.getAttributeValue("issystem"))) {
            return false;
        }
        if (object.getParent() == null) {
            return false;
        }
        if (this.isUniqueRequiredChild(object)) {
            return this.isUniqueRequiredChildSet(object);
        }
        return true;
    }

    public void setDefaultData(XModelObject object) {
    }

    public static void removeFromParent(XModelObject object) {
        if (object == null) {
            return;
        }
        XModelObject parent = object.getParent();
        if (parent == null) {
            return;
        }
        object.removeFromParent();
        XUndoManager undo = DefaultCreateHandler.getUndoManager(parent);
        if (undo != null) {
            parent.getModel().getUndoManager().addUndoable(new XRemoveUndo(parent, object));
        }
        parent.setModified(true);
    }

    private boolean isUniqueRequiredChild(XModelObject object) {
        XModelObject p = object.getParent();
        if (p == null) {
            return false;
        }
        XChild c = p.getModelEntity().getChild(object.getModelEntity().getName());
        return c != null && c.isRequired() && c.getMaxCount() == 1;
    }

    private boolean isUniqueRequiredChildSet(XModelObject object) {
        XAttribute[] as = object.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String xml = as[i].getXMLName();
            if (xml != null && xml.length() != 0) {
                String v;
                String n = as[i].getName();
                String dv = as[i].getDefaultValue();
                if (dv == null) {
                    dv = "";
                }
                if (!dv.equals(v = object.getAttributeValue(n))) {
                    return true;
                }
            }
            ++i;
        }
        XModelObject[] cs = object.getChildren();
        int i2 = 0;
        while (i2 < cs.length) {
            if (this.isEnabled(cs[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private void cleanUniqueRequiredChild(XModelObject object) throws XModelException {
        XAttribute[] as = object.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String xml = as[i].getXMLName();
            if (xml != null && xml.length() != 0) {
                String n = as[i].getName();
                String v = as[i].getDefaultValue();
                if (v == null) {
                    v = "";
                }
                object.getModel().changeObjectAttribute(object, n, v);
            }
            ++i;
        }
        XModelObject[] cs = object.getChildren();
        int i2 = 0;
        while (i2 < cs.length) {
            this.executeHandler(cs[i2], null);
            ++i2;
        }
    }
}

