/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl.documentation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import org.jboss.tools.common.meta.impl.documentation.ContentGenerator;
import org.jboss.tools.common.meta.impl.documentation.StyleGenerator;
import org.jboss.tools.common.meta.impl.documentation.XMLUtil2;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.w3c.dom.Element;

public class DocumentGenerator {
    private XModelObject meta = null;
    private String filename = null;
    private Parents parents = null;

    public void setModel(XModel model) {
        this.meta = model.getRoot().getChildByPath("MetaModel");
    }

    public void generate(String filename) {
        if (this.meta == null) {
            throw new IllegalStateException("Meta root is not set.");
        }
        this.filename = filename;
        Element g = XMLUtil.createDocumentElement("html");
        this.generateTitle(g);
        this.generateHead(g);
        this.generateBody(g);
        try {
            XModelObjectLoaderUtil.serialize(g, filename);
            this.replace();
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected void generateTitle(Element e) {
        Element t = XMLUtil.createElement(e, "title");
        XMLUtil2.createText(t, "Entity list");
    }

    protected void generateHead(Element e) {
        Element h = XMLUtil.createElement(e, "head");
        Element s = XMLUtil.createElement(h, "style");
        XMLUtil2.createText(s, new StyleGenerator().getStyle());
    }

    protected void generateBody(Element e) {
        Element b = XMLUtil.createElement(e, "body");
        XModelObject entities = this.meta.getChildren("MetaEntities")[0];
        this.parents = new Parents();
        this.parents.set(entities);
        this.parents.compile();
        new ContentGenerator().generate(b, entities);
        this.processGroup(b, entities);
    }

    protected void processGroup(Element e, XModelObject o) {
        XModelObject[] es = o.getChildren("MetaEntity");
        int i = 0;
        while (i < es.length) {
            this.processEntity(e, es[i]);
            ++i;
        }
        XModelObject[] gs = o.getChildren("MetaEntityGroup");
        int i2 = 0;
        while (i2 < gs.length) {
            this.processGroup(e, gs[i2]);
            ++i2;
        }
    }

    protected void processEntity(Element e, XModelObject o) {
        XMLUtil2.hr(e);
        Element t = XMLUtil.createElement(e, "table");
        XMLUtil2.entityRow(t, "Name:", o.getAttributeValue("name"));
        XMLUtil2.simpleRow(t, "Editor:", o.getAttributeValue("editor"));
        this.processHierarchy(e, o);
        this.processAttributeList(e, o.getChildren("MetaAttributes")[0]);
        this.processActionList(e, o.getChildren("MetaActionList")[0]);
    }

    protected void processHierarchy(Element e, XModelObject o) {
        Element t = XMLUtil.createElement(e, "table");
        t.setAttribute("width", "600");
        Element tr = XMLUtil.createElement(t, "tr");
        int i = 0;
        while (i < 2) {
            Element td = XMLUtil.createElement(tr, "td");
            td.setAttribute("width", "300");
            ++i;
        }
        tr = XMLUtil.createElement(t, "tr");
        Element td = XMLUtil.createElement(tr, "td");
        td.setAttribute("valign", "top");
        this.processParents(td, o);
        td = XMLUtil.createElement(tr, "td");
        td.setAttribute("valign", "top");
        this.processChildren(td, o.getChildren("MetaChildren")[0]);
    }

    protected void processParents(Element e, XModelObject o) {
        Element lt = XMLUtil2.createSubTitle(e, "Can be inside:");
        ArrayList<String> v = this.parents.get(o);
        if (v.size() == 0) {
            XMLUtil2.createText(lt, "None");
            XMLUtil.createElement(lt, "br");
        } else {
            int i = 0;
            while (i < v.size()) {
                Element s = XMLUtil.createElement(lt, "span");
                s.setAttribute("class", "value");
                XMLUtil2.createEntityReference(s, v.get(i));
                XMLUtil.createElement(lt, "br");
                ++i;
            }
        }
    }

    protected void processChildren(Element e, XModelObject o) {
        Element lt = XMLUtil2.createSubTitle(e, "Possible children:");
        XModelObject[] as = o.getChildren();
        if (as.length == 0) {
            XMLUtil2.createText(lt, "None");
            return;
        }
        Element t = this.createTable(lt);
        Element tr = XMLUtil.createElement(t, "tr");
        this.createHeaderCell(tr, "Name", 0);
        this.createHeaderCell(tr, "Required", 0);
        int i = 0;
        while (i < as.length) {
            tr = XMLUtil.createElement(tr, "tr");
            Element td = XMLUtil.createElement(tr, "td");
            td.setAttribute("class", "value");
            XMLUtil2.createEntityReference(td, as[i].getAttributeValue("name"));
            this.createValueCell(tr, as[i].getAttributeValue("required"));
            ++i;
        }
    }

    protected void processAttributeList(Element e, XModelObject o) {
        Element lt = XMLUtil2.createSubTitle(e, "Attribute List:");
        Element t = this.createTable(lt);
        Element tr = XMLUtil.createElement(t, "tr");
        this.createHeaderCell(tr, "Name", 130);
        this.createHeaderCell(tr, "Visible", 50);
        this.createHeaderCell(tr, "Editor", 0);
        this.createHeaderCell(tr, "Default Value", 0);
        this.createHeaderCell(tr, "Possible Values", 0);
        XModelObject[] as = o.getChildren("MetaAttribute");
        int i = 0;
        while (i < as.length) {
            tr = XMLUtil.createElement(tr, "tr");
            this.createValueCell(tr, as[i].getAttributeValue("name"));
            this.createValueCell(tr, as[i].getAttributeValue("visibility"));
            XModelObject oe = as[i].getChildren("MetaAttributeEditor")[0];
            String ed = oe.getAttributeValue("name");
            this.createValueCell(tr, ed);
            String dv = as[i].getAttributeValue("default value");
            this.createValueCell(tr, dv);
            XModelObject oc = as[i].getChildren("MetaAttributeConstraint")[0];
            String cl = oc.getAttributeValue("loader");
            if (cl.startsWith("List")) {
                this.processListConstraint(tr, oc);
            } else if (cl.length() == 0 && "Uneditable".equals(ed)) {
                this.createValueCell(tr, dv);
            } else if (cl.length() == 0 && "Int".equals(ed)) {
                this.createValueCell(tr, "integer");
            } else {
                this.createValueCell(tr, "any");
            }
            ++i;
        }
    }

    Element createTable(Element e) {
        Element t = XMLUtil.createElement(e, "table");
        t.setAttribute("border", "1");
        t.setAttribute("cellspacing", "0");
        t.setAttribute("cellpadding", "2");
        return t;
    }

    void createHeaderCell(Element e, String name, int width) {
        Element td = XMLUtil.createElement(e, "td");
        td.setAttribute("class", "name");
        if (width > 0) {
            td.setAttribute("width", "" + width);
        }
        XMLUtil2.createText(td, name);
    }

    void createValueCell(Element e, String value) {
        Element td = XMLUtil.createElement(e, "td");
        if (value.length() == 0) {
            value = "&nbsp;";
        }
        td.setAttribute("class", "value");
        XMLUtil2.createText(td, value);
    }

    void processListConstraint(Element e, XModelObject o) {
        Element td = XMLUtil.createElement(e, "td");
        XModelObject[] vs = o.getChildren();
        int i = 0;
        while (i < vs.length) {
            Element s = XMLUtil.createElement(td, "span");
            s.setAttribute("class", "value");
            XMLUtil2.createText(s, vs[i].getAttributeValue("name"));
            XMLUtil.createElement(td, "br");
            ++i;
        }
    }

    protected void processActionList(Element e, XModelObject o) {
        Element lt = XMLUtil2.createSubTitle(e, "Action List:");
        int i = o.getChildren().length;
        if (i > 0) {
            Element ul = XMLUtil.createElement(lt, "ul");
            this.processAction(ul, o);
        } else {
            XMLUtil2.createText(lt, "Empty");
        }
    }

    protected void processAction(Element e, XModelObject o) {
        XModelObject[] os = o.getChildren();
        int i = 0;
        while (i < os.length) {
            Element li;
            if ("MetaActionList".equals(os[i].getModelEntity().getName())) {
                if ("0".equals(os[i].getAttributeValue("group"))) {
                    this.processAction(e, os[i]);
                    XMLUtil2.hr(e, 100);
                } else {
                    li = XMLUtil.createElement(e, "li");
                    XMLUtil2.createText(li, os[i].getAttributeValue("display name"));
                    Element ul = XMLUtil.createElement(e, "ul");
                    this.processAction(ul, os[i]);
                }
            } else {
                li = XMLUtil.createElement(e, "li");
                XMLUtil2.createText(li, os[i].getAttributeValue("display name"));
            }
            ++i;
        }
    }

    protected void replace() {
        StringBuffer sb;
        block19: {
            sb = new StringBuffer();
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(new File(this.filename)));
                    char[] b = new char[256];
                    int i = 0;
                    while ((i = br.read(b, 0, 256)) > 0) {
                        sb.append(b, 0, i);
                    }
                }
                catch (IOException e) {
                    ModelPlugin.getPluginLog().logError((Throwable)e);
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException) {}
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '&') {
                sb.replace(i + 1, i + 5, "");
            }
            ++i;
        }
        try {
            PrintWriter bw = new PrintWriter(new FileWriter(new File(this.filename)));
            bw.print(sb.toString());
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Parents {
        private Hashtable<String, XModelObject> ent = new Hashtable();
        private Hashtable<String, ArrayList<String>> par = new Hashtable();

        Parents() {
        }

        public void set(XModelObject o) {
            XModelObject[] cs = o.getChildren("MetaEntityGroup");
            int i = 0;
            while (i < cs.length) {
                this.set(cs[i]);
                ++i;
            }
            cs = o.getChildren("MetaEntity");
            i = 0;
            while (i < cs.length) {
                String n = cs[i].getAttributeValue("name");
                this.ent.put(n, cs[i]);
                this.par.put(n, new ArrayList());
                ++i;
            }
        }

        public void compile() {
            for (XModelObject o : this.ent.values()) {
                String p = o.getAttributeValue("name");
                XModelObject[] os = o.getChildren("MetaChildren")[0].getChildren();
                int i = 0;
                while (i < os.length) {
                    String n = os[i].getAttributeValue("name");
                    ArrayList<String> v = this.par.get(n);
                    if (v != null) {
                        v.add(p);
                    }
                    ++i;
                }
            }
        }

        public ArrayList<String> get(XModelObject o) {
            return this.par.get(o.getAttributeValue("name"));
        }
    }
}

