/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsLoader;
import org.jboss.tools.common.model.filesystems.impl.LibsListener;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Libs
implements IElementChangedListener {
    protected FileSystemsImpl object;
    protected List<String> paths = null;
    Map<IPath, String> paths2 = new HashMap<IPath, String>();
    List<LibsListener> listeners = new ArrayList<LibsListener>();
    static String LIB_PREFIX = "lib-";
    int classpathpVersion = 0;
    int pathsVersion = -1;
    int fsVersion = -1;

    public Libs(FileSystemsImpl object) {
        this.object = object;
    }

    public void init() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    private IProject getProjectResource() {
        try {
            EclipseResourceUtil.getProject(this.object);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return EclipseResourceUtil.getProject(this.object);
    }

    public boolean update() {
        boolean result = this.updatePaths();
        if (result) {
            this.fire();
        }
        if (this.paths == null && result) {
            return true;
        }
        this.updateFileSystems(this.paths);
        this.fsVersion = this.pathsVersion;
        return result;
    }

    synchronized boolean updatePaths() {
        if (this.classpathpVersion <= this.pathsVersion) {
            return false;
        }
        this.pathsVersion = this.classpathpVersion;
        List<String> newPaths = null;
        try {
            newPaths = EclipseResourceUtil.getClassPath(this.getProjectResource());
            List<String> jre = EclipseResourceUtil.getJREClassPath(this.getProjectResource());
            if (jre != null) {
                newPaths.removeAll(jre);
            }
        }
        catch (CoreException e) {
            ModelPlugin.getDefault().logError(e);
        }
        catch (IOException e) {
            ModelPlugin.getDefault().logError(e);
        }
        if (this.paths == null && newPaths == null) {
            return false;
        }
        if (newPaths != null && this.paths != null && this.paths.size() == newPaths.size()) {
            boolean b = false;
            int i = 0;
            while (i < this.paths.size() && !b) {
                if (!this.paths.get(i).equals(newPaths.get(i))) {
                    b = true;
                }
                ++i;
            }
            if (!b) {
                return false;
            }
        }
        this.paths = newPaths;
        this.createMap();
        return true;
    }

    void updateFileSystems(List<String> paths) {
        if (this.fsVersion >= this.pathsVersion) {
            return;
        }
        XModelObject[] fs = this.object.getChildren();
        HashSet<XModelObject> fss = new HashSet<XModelObject>();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].getAttributeValue("name").startsWith(LIB_PREFIX)) {
                fss.add(fs[i]);
            }
            ++i;
        }
        if (paths != null) {
            i = 0;
            while (i < paths.size()) {
                String path = paths.get(i);
                boolean isJar = EclipseResourceUtil.isJar(path);
                String libEntity = isJar ? "FileSystemJar" : "FileSystemFolder";
                String fileName = new File(path).getName();
                if (!isJar || !EclipseResourceUtil.SYSTEM_JAR_SET.contains(fileName)) {
                    String jsname = String.valueOf(LIB_PREFIX) + fileName;
                    XModelObject o = this.object.getChildByPath(jsname);
                    if (o != null) {
                        fss.remove(o);
                    } else {
                        o = this.object.getModel().createModelObject(libEntity, null);
                        o.setAttributeValue("name", jsname);
                        o.setAttributeValue("location", path);
                        o.set(FileSystemsLoader.IS_ADDED_TO_CLASSPATH, "true");
                        this.object.addChild(o);
                    }
                }
                ++i;
            }
        }
        for (XModelObject o : fss) {
            String path = XModelObjectUtil.expand(o.getAttributeValue("location"), o.getModel(), null);
            if ("true".equals(o.get(FileSystemsLoader.IS_ADDED_TO_CLASSPATH))) {
                o.removeFromParent();
                continue;
            }
            if (new File(path).exists()) continue;
            o.removeFromParent();
        }
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Map<IPath, String> getPathsAsMap() {
        return this.paths2;
    }

    private void createMap() {
        this.paths2.clear();
        if (this.paths != null) {
            for (String p : this.paths) {
                this.paths2.put((IPath)new Path(p), p);
            }
        }
    }

    public synchronized void addListener(LibsListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(LibsListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fire() {
        LibsListener[] ls = null;
        Libs libs = this;
        synchronized (libs) {
            ls = this.listeners.toArray(new LibsListener[0]);
        }
        if (ls != null) {
            LibsListener[] libsListenerArray = ls;
            int n = ls.length;
            int n2 = 0;
            while (n2 < n) {
                LibsListener listener = libsListenerArray[n2];
                listener.pathsChanged(this.paths);
                ++n2;
            }
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        IProject project = this.getProjectResource();
        if (project == null || !project.exists()) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            return;
        }
        IJavaElementDelta d = event.getDelta();
        IJavaElementDelta[] ds = d.getAffectedChildren();
        IJavaElementDelta p = null;
        IJavaElementDelta[] iJavaElementDeltaArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta dc = iJavaElementDeltaArray[n2];
            if (dc.getElement() instanceof IJavaProject && ((IJavaProject)dc.getElement()).getProject() == project) {
                p = dc;
            }
            ++n2;
        }
        if (p == null) {
            return;
        }
        int f = p.getFlags();
        if ((f & 0x220000) != 0) {
            ++this.classpathpVersion;
        } else {
            IJavaElementDelta[] ds1;
            IJavaElementDelta[] iJavaElementDeltaArray2 = ds1 = p.getAffectedChildren();
            int n3 = ds1.length;
            int n4 = 0;
            while (n4 < n3) {
                IJavaElementDelta d1 = iJavaElementDeltaArray2[n4];
                d1.getElement();
                if (d1.getKind() == 1) {
                    ++this.classpathpVersion;
                    break;
                }
                ++n4;
            }
        }
    }
}

