/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.jboss.tools.common.model.XModelObject;

public abstract class ModelRenameProcessor
extends RenameProcessor
implements INameUpdating,
IReferenceUpdating {
    protected XModelObject object;
    protected String fNewElementName;

    public void setModelObject(XModelObject object) {
        this.object = object;
        if (object != null) {
            this.setNewElementName(object);
        }
    }

    protected void setNewElementName(XModelObject object) {
        if (object != null) {
            this.setNewElementName(object.getAttributeValue(this.getProcessorName()));
        }
    }

    protected abstract String getPropertyName();

    public void setNewElementName(String newName) {
        this.fNewElementName = newName;
    }

    public String getNewElementName() {
        return this.fNewElementName;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public String getProcessorName() {
        String message = MessageFormat.format("Rename {0} to {1}", this.getCurrentElementName(), this.getNewElementName());
        return message;
    }

    public Object[] getElements() {
        return new Object[]{this.object};
    }

    public String getCurrentElementName() {
        return this.object.getAttributeValue(this.getPropertyName());
    }

    public String[] getAffectedProjectNatures() throws CoreException {
        return new String[0];
    }

    public Object getNewElement() {
        return this.object;
    }

    public boolean getUpdateReferences() {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        Object[] elements = this.getElements();
        String[] natures = this.getAffectedProjectNatures();
        ArrayList<RenameParticipant> result = new ArrayList<RenameParticipant>();
        RenameArguments arguments = new RenameArguments(this.getNewElementName(), this.getUpdateReferences());
        int i = 0;
        while (i < elements.length) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)elements[i], (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        XModelObject c = this.object.getParent();
        if (c == null) {
            return RefactoringStatus.createFatalErrorStatus((String)"Object is removed from model.");
        }
        if (c.getChildByPath(newName) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Object {0} already exists.", newName));
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        return null;
    }
}

