/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ACComparator;
import org.jboss.tools.common.model.util.AccessibleJava;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.ISimpleTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibleClasses
implements ISimpleTree {
    private static final int JAVA = 1;
    private static final int PROJECT = 2;
    private int mode = 2;
    private XModel model;
    IJavaProject javaProject;
    private Map<String, SortedSet<String>> map = null;
    private static SortedSet<String> EMPTY = new TreeSet<String>();
    private Comparator<String> comparator = new ACComparator<String>();
    private static String exts = ".class.bo.java.cls.";

    public AccessibleClasses(XModel model, boolean useproject) {
        this(model, useproject && model != null ? 3 : 1);
    }

    protected XModel getModel() {
        return this.model;
    }

    public AccessibleClasses(XModel model, int mode) {
        this.model = model;
        this.javaProject = EclipseResourceUtil.getJavaProject((IProject)EclipseResourceUtil.getProject(model.getRoot()));
        this.mode = mode;
        this.map = (mode & 2) != 0 ? new HashMap() : null;
    }

    @Override
    public String[] getContent(String packagename) {
        if (this.map == null) {
            return AccessibleJava.getInstance().getContent(packagename);
        }
        SortedSet<String> o = this.map.get(packagename);
        if (o == null) {
            this.load(packagename);
            o = this.map.get(packagename);
        }
        if (o == EMPTY) {
            return null;
        }
        String[] r = o.toArray(new String[o.size()]);
        Arrays.sort(r, this.comparator);
        return r;
    }

    protected void load(String packagename) {
        String[] s;
        TreeSet<String> list = new TreeSet<String>();
        String[] stringArray = s = (this.mode & 1) == 0 ? null : AccessibleJava.getInstance().getContent(packagename);
        if (s != null) {
            int i = 0;
            while (i < s.length) {
                list.add(s[i]);
                ++i;
            }
        }
        boolean exists = this.buildPackage(list, packagename);
        if (s == null && !exists) {
            this.map.put(packagename, EMPTY);
        } else {
            this.map.put(packagename, list);
        }
    }

    protected String extensions() {
        return exts;
    }

    private boolean buildPackage(SortedSet<String> list, String packagename) {
        String pkg = packagename.toLowerCase();
        if (pkg.endsWith(".cvs")) {
            return false;
        }
        if (pkg.endsWith(".svn")) {
            return false;
        }
        boolean exists = false;
        XModelObject fs = FileSystemsHelper.getFileSystems(this.model);
        if (fs == null) {
            return false;
        }
        try {
            exists = this.getChildren(list, packagename);
        }
        catch (JavaModelException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return exists;
    }

    private boolean getChildren(SortedSet<String> list, String packagename) throws JavaModelException {
        if (this.javaProject == null || !this.javaProject.exists()) {
            return false;
        }
        boolean exists = false;
        boolean r = "%root%".equals(packagename);
        String jp = r ? "" : packagename;
        IPackageFragmentRoot[] rs = this.javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < rs.length) {
            IPackageFragmentRoot pf;
            Object object = pf = r ? rs[i] : rs[i].getPackageFragment(packagename);
            if (pf != null && ((IJavaElement)pf).exists()) {
                exists = true;
                IJavaElement[] cs = pf.getChildren();
                this.process(list, cs, jp);
                if (!r) {
                    this.process2(list, rs[i].getChildren(), jp);
                }
            }
            ++i;
        }
        return exists;
    }

    private void process(SortedSet<String> list, IJavaElement[] cs, String jp) throws JavaModelException {
        int j = 0;
        while (j < cs.length) {
            block6: {
                String n;
                block8: {
                    block7: {
                        boolean isp;
                        block5: {
                            isp = cs[j] instanceof IPackageFragment;
                            n = cs[j].getElementName();
                            if (n.length() != 0 || !isp) break block5;
                            this.process(list, ((IPackageFragment)cs[j]).getChildren(), jp);
                            break block6;
                        }
                        if (!isp) break block7;
                        if (n.indexOf(46) >= 0) break block6;
                        n = String.valueOf(n) + ".";
                        break block8;
                    }
                    int d = n.lastIndexOf(46);
                    if (d < 0) break block8;
                    String ext = n.substring(d + 1);
                    n = n.substring(0, d);
                    if (!this.extensions().contains("." + ext + ".")) break block6;
                }
                if (this.accepts(jp, n)) {
                    list.add(n);
                }
            }
            ++j;
        }
    }

    private void process2(SortedSet<String> list, IJavaElement[] cs, String jp) throws JavaModelException {
        int j = 0;
        while (j < cs.length) {
            block5: {
                String n;
                block7: {
                    block6: {
                        n = cs[j].getElementName();
                        if (!n.startsWith(String.valueOf(jp) + ".")) break block5;
                        n = n.substring(jp.length() + 1);
                        boolean isp = cs[j] instanceof IPackageFragment;
                        if (!isp) break block6;
                        if (n.indexOf(46) >= 0) break block5;
                        n = String.valueOf(n) + ".";
                        break block7;
                    }
                    int d = n.lastIndexOf(46);
                    if (d < 0) break block7;
                    String ext = n.substring(d + 1);
                    n = n.substring(0, d);
                    if (!this.extensions().contains("." + ext + ".")) break block5;
                }
                if (this.accepts(jp, n)) {
                    list.add(n);
                }
            }
            ++j;
        }
    }

    protected boolean accepts(String packagename, String n) {
        return !n.equalsIgnoreCase("CVS.") && !n.equalsIgnoreCase("svn.");
    }
}

