/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ISimpleTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibleJava
implements ISimpleTree {
    private static AccessibleJava instance = null;
    private Map<String, JarFile> jarsmap = null;
    private Map<String, SortedSet<String>> map = null;
    private File[] folders = null;
    private HashSet<String> checkedpackages = new HashSet();
    private static String[] serviceroots = new String[]{"CVS/", "META-INF/", ".svn"};

    public static AccessibleJava getInstance() {
        if (instance == null) {
            instance = new AccessibleJava();
        }
        return instance;
    }

    public static String getClassPath() {
        StringBuffer sb = new StringBuffer();
        String[] s = new String[]{};
        int i = 0;
        while (i < s.length) {
            sb.append(File.pathSeparator).append(s[i]);
            ++i;
        }
        return sb.toString();
    }

    private AccessibleJava() {
        this.load();
    }

    private String getJavaLib() {
        String rt = String.valueOf(System.getProperty("java.home")) + "/lib/rt.jar";
        return rt;
    }

    protected String extension() {
        return ".class";
    }

    private void load() {
        this.map = new HashMap<String, SortedSet<String>>();
        this.jarsmap = new HashMap<String, JarFile>();
        this.addJars(this.getJavaLib());
        String paths = AccessibleJava.getClassPath();
        this.addJars(paths);
        Iterator<JarFile> c = this.jarsmap.values().iterator();
        while (c.hasNext()) {
            this.loadJar(c.next());
        }
        this.jarsmap = null;
        this.addFolders(paths);
    }

    private void addJars(String paths) {
        StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            try {
                this.addJar(new JarFile(t));
            }
            catch (IOException e) {
                ModelPlugin.getPluginLog().logError("addJars:" + e.getClass().getName());
            }
        }
    }

    private void addJar(JarFile jf) throws IOException {
        String n = new File(jf.getName()).getCanonicalPath();
        if (this.jarsmap.get(n) != null) {
            return;
        }
        this.jarsmap.put(n, jf);
        this.addJarManifest(jf);
    }

    private void loadJar(JarFile jar) {
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry o = e.nextElement();
            if (!(o instanceof JarEntry)) continue;
            JarEntry je = o;
            this.register(je.getName(), this.map);
        }
        try {
            jar.close();
        }
        catch (IOException iOException) {
            ModelPlugin.getPluginLog().logError("AccessibleJava:Cannot close jar.");
        }
    }

    private void register(String path, Map<String, SortedSet<String>> map) {
        if (path == null || path.indexOf("$") >= 0 || path.equals("/")) {
            return;
        }
        int j = 0;
        while (j < serviceroots.length) {
            if (path.indexOf(serviceroots[j]) >= 0) {
                return;
            }
            ++j;
        }
        boolean isPackage = path.endsWith("/");
        if (!isPackage && !path.endsWith(this.extension())) {
            return;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        path = path.substring(0, path.length() - (isPackage ? 1 : 6)).replace('/', '.');
        this.register0(path, isPackage, map);
    }

    @Override
    public String[] getContent(String packagename) {
        this.checkfolders(packagename);
        SortedSet<String> list = this.map.get(packagename);
        return list == null ? null : list.toArray(new String[list.size()]);
    }

    private void register0(String path, boolean isPackage, Map<String, SortedSet<String>> map) {
        String name;
        String parent;
        int i = path.lastIndexOf(46);
        if (i > 0) {
            parent = path.substring(0, i);
            name = path.substring(i + 1);
        } else {
            parent = "%root%";
            name = path;
        }
        if (!this.isJavaName(name)) {
            return;
        }
        SortedSet<String> list = map.get(parent);
        if (list == null) {
            list = new TreeSet<String>();
            map.put(parent, list);
        }
        String pname = String.valueOf(name) + ".";
        if (list.contains(name) || list.contains(pname)) {
            return;
        }
        list.add(isPackage ? pname : name);
        if (i > 0) {
            this.register0(parent, true, map);
        }
    }

    boolean isJavaName(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addFolders(String paths) {
        StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
        ArrayList<File> l = new ArrayList<File>();
        while (st.hasMoreTokens()) {
            File f;
            String t = st.nextToken().trim();
            if (t.length() == 0 || t.indexOf(126) >= 0 || !(f = new File(t)).isDirectory()) continue;
            l.add(f);
        }
        this.folders = l.toArray(new File[l.size()]);
        int i = 0;
        while (i < this.folders.length) {
            File[] fs = this.folders[i].listFiles();
            if (fs != null) {
                int j = 0;
                while (j < fs.length) {
                    if (fs[j].isDirectory()) {
                        this.register(String.valueOf(fs[j].getName()) + "/", this.map);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void checkfolders(String pkg) {
        if (this.checkedpackages.contains(pkg)) {
            return;
        }
        this.checkedpackages.add(pkg);
        int i = 0;
        while (i < this.folders.length) {
            this.loadfolder(this.folders[i], pkg);
            ++i;
        }
        i = pkg.lastIndexOf(46);
        if (i >= 0) {
            this.checkfolders(pkg.substring(0, i));
        }
    }

    private void loadfolder(File f, String pkg) {
        String p = pkg.replace('.', '/');
        File pf = new File(String.valueOf(f.getAbsolutePath()) + '/' + p);
        if (!pf.exists()) {
            return;
        }
        File[] fs = pf.listFiles();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                String n = fs[i].getName();
                if (fs[i].isDirectory()) {
                    this.register(String.valueOf(p) + '/' + n + '/', this.map);
                } else if (n.endsWith(this.extension())) {
                    this.register(String.valueOf(p) + '/' + n, this.map);
                }
                ++i;
            }
        }
    }

    private void addJarManifest(JarFile jf) throws IOException {
        Manifest m = jf.getManifest();
        Attributes as = m.getMainAttributes();
        String classpath = as.getValue("Class-Path");
        if (classpath == null) {
            return;
        }
        String r = String.valueOf(new File(jf.getName()).getParentFile().getCanonicalPath()) + File.separatorChar;
        StringTokenizer st = new StringTokenizer(classpath, " ");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreElements()) {
            String t = st.nextToken().trim();
            if (t.length() <= 0) continue;
            sb.append(r).append(t).append(File.pathSeparator);
        }
        this.addJars(sb.toString());
    }

    public static interface IContextPackageProvider {
        public void setObject(XModelObject var1);

        public String getContextPackage();
    }
}

