/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.commands.ICommandImageService;
import org.jboss.tools.common.model.Messages;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.osgi.framework.Bundle;

public class ModelImages {
    private static ModelImages instance = new ModelImages(ModelPlugin.getDefault().getBundle().getEntry("/"));
    private URL baseUrl;

    public static Image getImage(String key) {
        return instance.createImageDescriptor(key).createImage();
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return instance.createImageDescriptor(key);
    }

    protected ModelImages(URL url) {
        this.baseUrl = url;
    }

    public ImageDescriptor createImageDescriptor(String key) {
        if (key.startsWith("command:")) {
            key = key.substring("command:".length());
            IWorkbench w = ModelPlugin.getDefault().getWorkbench();
            ICommandImageService s = (ICommandImageService)w.getService(ICommandImageService.class);
            return s.getImageDescriptor(key);
        }
        URL url = this.baseUrl;
        if (key.startsWith("plugin:")) {
            key = key.substring("plugin:".length());
            int i = key.indexOf(":");
            String plugin = key.substring(0, i);
            key = key.substring(i + 1);
            Bundle bundle = Platform.getBundle((String)plugin);
            if (bundle != null) {
                url = bundle.getEntry("/");
            }
        }
        try {
            return ImageDescriptor.createFromURL((URL)this.makeIconFileURL(url, key));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private URL makeIconFileURL(URL url, String name) throws MalformedURLException {
        if (name == null) {
            throw new MalformedURLException(Messages.ModelImages_NullImageName);
        }
        return new URL(url, name);
    }
}

