/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.widgets.DefaultSettings;

public class PropertyEditorDialog
extends Dialog {
    public static final int MINIMUM_WIDTH = 400;
    public static final int MINIMUM_HEIGHT = 300;
    IPropertyEditor propertyEditor;
    ExtendedFieldEditor editor;
    DefaultValueAdapter adapter;
    PropertyChangeListener listener = new VCL();
    Object initValue;

    public PropertyEditorDialog(Shell parentShell, IPropertyEditor editor) {
        super(parentShell);
        this.propertyEditor = editor;
        this.initValue = editor.getValue();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Layout pageContainerLayout = new LayoutFactory(parent.getShell()).createLayout(5, 5, 400, 300);
        composite.setLayout(pageContainerLayout);
        this.createDialogAreaInternal(composite);
        if (this.propertyEditor.getInput() instanceof DefaultValueAdapter) {
            this.adapter = (DefaultValueAdapter)this.propertyEditor.getInput();
            this.adapter.addValueChangeListener(this.listener);
        }
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        Button b = this.getButton(0);
        b.setEnabled(false);
        return c;
    }

    protected Control createDialogAreaInternal(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createFieldEditor(composite);
        return composite;
    }

    protected void createFieldEditor(Composite parent) {
        this.editor = this.propertyEditor.getFieldEditor(parent);
        this.editor.setSettings(new DefaultSettings());
        int cn = this.editor.getNumberOfControls();
        if (cn > 2) {
            GridLayout layout = new GridLayout();
            layout.numColumns = cn;
            parent.setLayout((Layout)layout);
        } else {
            cn = 2;
        }
        this.editor.fillIntoGrid(parent, cn);
        this.editor.setOwnerDialog(this);
    }

    public void okPressed() {
        Button b = this.getButton(0);
        if (b == null || !b.isEnabled()) {
            return;
        }
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.editor.store();
        }
        super.buttonPressed(buttonId);
    }

    public void dispose() {
        if (this.adapter != null) {
            this.adapter.removeValueChangeListener(this.listener);
            this.adapter = null;
        }
        if (this.editor != null) {
            this.editor.setOwnerDialog(null);
        }
    }

    class LayoutFactory
    extends WizardDialog {
        public LayoutFactory(Shell shell) {
            super(shell, null);
        }

        protected void setWizard(IWizard newWizard) {
        }

        public Layout createLayout(int mw, int mh, int minW, int minH) {
            return new WizardDialog.PageContainerFillLayout(this, mw, mh, minW, minH){

                public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
                    Point p = super.computeSize(composite, wHint, hHint, force);
                    if (p.y > 400) {
                        p.y = 400;
                    }
                    return p;
                }
            };
        }
    }

    class VCL
    implements PropertyChangeListener {
        VCL() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Object value = event.getNewValue();
            Button b = PropertyEditorDialog.this.getButton(0);
            if (b == null || b.isDisposed()) {
                PropertyEditorDialog.this.dispose();
                return;
            }
            boolean enabled = value != null && !value.equals(PropertyEditorDialog.this.initValue);
            b.setEnabled(enabled);
        }
    }
}

